/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.consumer.BrokerSubscription;

public class CustomSubscription
extends BrokerSubscription {
    public void setupCustomDurableSubscriber(String topicName, String brokerEpr, MessageListener listener, String ... selector) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(brokerEpr);
        try {
            TopicConnection connection = connectionFactory.createTopicConnection();
            if (selector.length > 0) {
                connection.setClientID(topicName + selector[0]);
            } else {
                connection.setClientID(topicName + listener.getClass());
            }
            connection.start();
            this.connections.add(connection);
            TopicSession session = connection.createTopicSession(transacted, ackMode);
            Topic topic = session.createTopic(topicName);
            TopicSubscriber consumer = null;
            consumer = selector.length > 0 ? session.createDurableSubscriber(topic, topic.getTopicName() + selector[0], selector[0], false) : session.createDurableSubscriber(topic, topic.getTopicName());
            consumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error creating Durable Subscriber", (Throwable)e);
            throw e;
        }
        logger.info((Object)("Started Durable Subscriber for topic: " + topicName));
    }

    @Override
    public void setScope(GCUBEScope scope) {
    }
}

