/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.mail;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class MailMessage {
    String message;
    ArrayList<String> emailRecipients = null;
    String subject;

    public MailMessage(ArrayList<String> emailRecipients, String message, String subject) {
        this.emailRecipients = emailRecipients;
        this.message = message;
        this.subject = subject;
    }

    public void sendMail() {
        try {
            System.getProperties().put("mail.host", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (this.emailRecipients == null) {
            return;
        }
        for (int a = 0; a < this.emailRecipients.size(); ++a) {
            try {
                URL u = new URL("mailto:" + this.emailRecipients.get(a));
                URLConnection c = u.openConnection();
                c.setDoInput(false);
                c.setDoOutput(true);
                c.connect();
                PrintWriter out = new PrintWriter(new OutputStreamWriter(c.getOutputStream()));
                out.println("From: \"ConsumerMonitor@gcube-system.org <" + System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName() + ">");
                out.println("To: " + this.emailRecipients.get(a));
                out.println("Subject: " + this.subject);
                out.println();
                out.println(this.message);
                out.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

