/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.db;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.Constants;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.db.DBManager;
import org.gcube.messaging.common.consumer.db.PoolManager;
import org.gcube.messaging.common.consumer.mail.MailRecipientHelper;
import org.gcube.messaging.common.consumer.notifier.Notification;
import org.gcube.messaging.common.consumer.ri.RINotification;
import org.gcube.messaging.common.messages.GHNMessage;
import org.gcube.messaging.common.messages.RIMessage;

public class MonitoringDBManager
extends DBManager
implements Runnable {
    GCUBELog logger = new GCUBELog(MonitoringDBManager.class);

    public MonitoringDBManager() {
        this.dbFileBaseFolder = ServiceContext.getContext().getPersistenceRoot().getAbsolutePath() + File.separator + "MonitoringDB";
        this.dbName = "monitoring";
        this.dbFileName = this.dbFileBaseFolder + File.separator + this.dbName + ".db";
        backupFolder = new File(System.getenv("HOME") + File.separator + "MonitoringDBBackup");
        this.queriesFile = new File(GHNContext.getContext().getLocation() + File.separator + (String)ServiceContext.getContext().getProperty("configDir", new boolean[0]) + File.separator + (String)ServiceContext.getContext().getProperty("MonitoringDBFile", new boolean[]{true}));
        this.connection = null;
        if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
            Thread t = new Thread(this);
            t.start();
        }
        this.poolManager = new PoolManager(this.dbName);
    }

    @Override
    protected void connectToMySql() throws Exception {
        this.connection = this.poolManager.getInternalDBConnection();
        this.connection.setAutoCommit(true);
    }

    @Override
    public synchronized void open() throws ClassNotFoundException, SQLException, Exception {
        if (this.connection == null) {
            if (ServiceContext.getContext().getUseEmbeddedDB().booleanValue()) {
                this.connectToEmbeddedDB();
            } else {
                this.connectToMySql();
            }
        }
        String testQuery = "SELECT LIMIT 1 1 * FROM GHNMessage";
        DBManager.BaseConsumer baseConsumer = new DBManager.BaseConsumer(){

            @Override
            public void consume(ResultSet resultset) throws Exception {
            }
        };
        try {
            this.queryAndConsume(testQuery, baseConsumer);
        }
        catch (Exception e) {
            this.createDB();
        }
    }

    public void insertUser(MailRecipientHelper.MonitorUser user) {
        this.logger.debug((Object)("INSERT the following user " + user + " INTO DB"));
        try {
            String expression = "INSERT INTO USER VALUES ('" + user.getMail() + "','" + user.getName() + "','" + user.getScope() + "','" + (user.isNotify() ? 1 : 0) + "','" + (user.isReceiveSummary() ? 1 : 0) + "','" + (user.isAdmin() ? 1 : 0) + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    public ResultSet getDomains() {
        String query = "SELECT DISTINCT Name FROM  DOMAIN";
        this.logger.debug((Object)query);
        ResultSet result = null;
        try {
            result = this.query(query);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error querying  DB", (Throwable)e);
        }
        return result;
    }

    public void insertDomain(String domain, String siteName) {
        this.logger.debug((Object)("INSERT the following domain " + domain + " INTO DB"));
        try {
            String expression = "INSERT INTO DOMAIN VALUES ('" + domain + "','" + siteName + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    public void associateUserAndDomain(String userMail, String domain, String scope) {
        this.logger.debug((Object)("INSERT the following domain " + domain + " INTO DB"));
        try {
            String expression = "INSERT INTO USERDOMAIN VALUES ('" + userMail + "','" + domain + "','" + scope + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanMonitoringConf(String scope) {
        this.logger.debug((Object)("Cleaning Monitoring conf for scope " + scope));
        try {
            this.connection.setAutoCommit(false);
            String query1 = "DELETE FROM USER WHERE Scope='" + scope + "';";
            String query2 = "DELETE FROM USERDOMAIN WHERE Scope='" + scope + "';";
            Statement statement = this.connection.createStatement();
            Statement statement2 = this.connection.createStatement();
            statement.executeUpdate(query1);
            statement2.executeUpdate(query2);
            this.connection.commit();
            statement.close();
            statement2.close();
        }
        catch (Exception e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException error) {
                this.logger.error((Object)"Error updating DB", (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.logger.error((Object)"Error setting connection Autocommit", (Throwable)e);
            }
        }
    }

    public void InsertGHNMessage(GHNMessage<?> message) {
        this.logger.debug((Object)("INSERT the following GHN message " + message + " INTO DB"));
        String date = message.getTime().substring(0, message.getTime().indexOf(" "));
        String time = message.getTime().substring(message.getTime().indexOf(" ") + 1);
        try {
            String expression = "INSERT INTO GHNMessage (GHNName,testType,description,result,scope,date,time) VALUES ('" + message.getSourceGHN() + "','" + message.getTest().getType() + "','" + message.getTest().getDescription() + "','" + (message.getTest().getTestResult() != null ? message.getTest().getTestResult().toString() : "") + "','" + message.getScope() + "','" + date + "','" + time + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    public void InsertRIMessage(RIMessage<?> message) {
        this.logger.debug((Object)("INSERT the following RI message: " + message + " INTO DB"));
        String date = message.getTime().substring(0, message.getTime().indexOf(" "));
        String time = message.getTime().substring(message.getTime().indexOf(" ") + 1);
        try {
            String expression = "INSERT INTO RIMessage (ServiceName,ServiceClass,GHNName,testType,description,result,scope,date,time) VALUES ('" + message.getServiceName() + "','" + message.getServiceClass() + "','" + message.getSourceGHN() + "','" + message.getTest().getType() + "','" + message.getTest().getDescription() + "','" + (message.getTest().getTestResult() != null ? message.getTest().getTestResult().toString() : "") + "','" + message.getScope() + "','" + date + "','" + time + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    public void insertNotification(Notification not) {
        this.logger.debug((Object)("INSERT the following Notification : " + not + " INTO DB"));
        String date = not.getTime().substring(0, not.getTime().indexOf(" "));
        String time = not.getTime().substring(not.getTime().indexOf(" ") + 1);
        try {
            String expression = "INSERT INTO NOTIFICATION (GHNName,ServiceName,ServiceClass,testType,testSubType,scope,message,date,time) VALUES ('" + not.getSourceGHN() + "','" + (not instanceof RINotification ? ((RINotification)not).getServiceName() + "','" : "NULL','") + (not instanceof RINotification ? ((RINotification)not).getServiceClass() + "','" : "NULL','") + not.getType() + "','" + this.getSubType(not) + "','" + not.getScope().toString() + "','" + not.getMessage() + "','" + date + "','" + time + "');";
            this.update(expression);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error updating DB", (Throwable)e);
        }
    }

    private String getSubType(Notification not) {
        if (not.getType() != "NOTIFICATION") {
            return not.getType();
        }
        if (not.getMessage().contains("GHN Ready")) {
            return Constants.NotificationSubType.GHN_READY.name();
        }
        if (not.getMessage().contains("GHN shutdown")) {
            return Constants.NotificationSubType.GHN_SHUTDOWN.name();
        }
        if (not.getMessage().contains("Added")) {
            return Constants.NotificationSubType.SCOPE_ADDED.name();
        }
        if (not.getMessage().contains("Removed")) {
            return Constants.NotificationSubType.SCOPE_REMOVED.name();
        }
        return "";
    }

    @Override
    public void run() {
        do {
            try {
                Thread.sleep(backupIntervalMS);
                this.backup();
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Unable to sleep", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to backup", (Throwable)e);
            }
        } while (!Thread.interrupted());
    }
}

