/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.gcube.common.core.utils.calls.RICall;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.json.JSONObject;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;

public abstract class Query<CALL extends RICall>
implements Serializable {
    private static final long serialVersionUID = 1L;
    GCUBELog logger = new GCUBEClientLog(this.getClass(), new Properties[0]);
    protected CALL call;
    protected String results;
    protected String query = null;
    protected String orderClause = "";
    protected String limitClause = "";
    protected String groupClause = "";
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    protected abstract String performQuery() throws Exception;

    public String query() throws Exception, QueryNotSetException {
        if (this.query == null) {
            throw new QueryNotSetException();
        }
        this.checkQuery(this.getQuery());
        this.setResults(this.performQuery());
        return this.getResults();
    }

    private void checkQuery(String string) throws Exception {
        if (!string.startsWith("SELECT") && !string.startsWith("SHOW")) {
            throw new Exception("The query MUST be a SELECT/SHOW statement");
        }
    }

    public JSONArray toJSON() throws EmptyResultException {
        try {
            return new JSONObject(this.getResults()).getJSONArray("data");
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            throw new EmptyResultException();
        }
    }

    public Long getDimensions(String string) throws Exception {
        this.setQuery("SELECT COUNT(*) AS COUNT FROM " + string);
        String string2 = this.performQuery();
        return Long.valueOf((String)new JSONObject(string2).getJSONArray("data").getJSONObject(0).get("COUNT"));
    }

    public void printQueryResults() throws Exception {
        int n;
        for (n = 0; n < this.toJSON().getJSONObject(0).names().length(); ++n) {
            this.logger.debug(this.toJSON().getJSONObject(0).names().get(n));
        }
        for (n = 0; n < this.toJSON().length(); ++n) {
            for (int i = 0; i < this.toJSON().getJSONObject(n).names().length(); ++i) {
                this.logger.debug(this.toJSON().getJSONObject(n).get(this.toJSON().getJSONObject(n).names().getString(i)));
            }
            this.logger.debug((Object)"");
        }
    }

    public CALL getCall() {
        return this.call;
    }

    public void setCall(CALL CALL) {
        this.call = CALL;
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String string) {
        this.results = string;
    }

    public String getQuery() {
        return this.query + this.getGroupClause() + this.getOrderClause() + this.getLimitClause();
    }

    public void setQuery(String string) {
        this.results = null;
        this.query = string;
    }

    public String getOrderClause() {
        return this.orderClause;
    }

    public void setOrderClause(String string) {
        this.orderClause = " ORDER BY " + string;
    }

    public String getLimitClause() {
        return this.limitClause;
    }

    public void setLimitClause(Integer n, Integer n2) {
        this.limitClause = " LIMIT " + n.toString() + "," + n2.toString();
    }

    public void setLimitClause(Integer n) {
        this.limitClause = " LIMIT " + n.toString();
    }

    public String getGroupClause() {
        return this.groupClause;
    }

    public void setGroupClause(String string) {
        this.groupClause = " GROUP BY " + string;
    }

    public ArrayList<ArrayList<String>> getResultsAsArray() throws Exception {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        try {
            int n;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            JSONArray jSONArray = this.toJSON();
            for (n = 0; n < jSONArray.getJSONObject(0).names().length(); ++n) {
                arrayList2.add((String)jSONArray.getJSONObject(0).names().get(n));
            }
            arrayList.add(arrayList2);
            for (n = 0; n < jSONArray.length(); ++n) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (int i = 0; i < jSONArray.getJSONObject(n).names().length(); ++i) {
                    arrayList3.add((String)jSONArray.getJSONObject(n).get(jSONArray.getJSONObject(n).names().getString(i)));
                }
                arrayList.add(arrayList3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return arrayList;
    }
}

