/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.json.JSONObject;
import org.gcube.messaging.common.consumerlibrary.query.AccountingQuery;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.messages.records.AISRecord;
import org.gcube.messaging.common.messages.records.AdvancedSearchRecord;
import org.gcube.messaging.common.messages.records.AnnotationRecord;
import org.gcube.messaging.common.messages.records.AquamapsRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.BrowseRecord;
import org.gcube.messaging.common.messages.records.ContentRecord;
import org.gcube.messaging.common.messages.records.DocumentWorkflowRecord;
import org.gcube.messaging.common.messages.records.GenericRecord;
import org.gcube.messaging.common.messages.records.GoogleSearchRecord;
import org.gcube.messaging.common.messages.records.HLRecord;
import org.gcube.messaging.common.messages.records.LoginRecord;
import org.gcube.messaging.common.messages.records.QuickSearchRecord;
import org.gcube.messaging.common.messages.records.ReportRecord;
import org.gcube.messaging.common.messages.records.SimpleSearchRecord;
import org.gcube.messaging.common.messages.records.StatisticalManagerRecord;
import org.gcube.messaging.common.messages.records.TSRecord;
import org.gcube.messaging.common.messages.records.WarRecord;
import org.gcube.messaging.common.messages.records.WebAppRecord;

public class PortalAccountingQuery
extends AccountingQuery {
    private static final long serialVersionUID = 1L;

    public <TYPE extends BaseRecord> String queryByType(Class<TYPE> type) throws Exception {
        this.setQuery(this.selectQuery(type));
        this.query();
        return this.getResults();
    }

    public String queryByType(String type, String[] date) throws Exception {
        this.setQuery(this.selectQuery(type) + this.selectDateFiler(date, " AND"));
        this.query();
        return this.getResults();
    }

    private String selectDateFiler(String[] date, String delimiter) {
        String ret = "";
        switch (date.length) {
            case 0: {
                break;
            }
            case 1: {
                ret = delimiter + " date='" + date[0] + "'";
                break;
            }
            case 2: {
                ret = delimiter + " date BETWEEN '" + date[0] + "' AND '" + date[1] + "'";
            }
        }
        return ret;
    }

    public <TYPE extends BaseRecord> String queryByUser(Class<TYPE> type, String user, String ... scope) throws Exception {
        this.setQuery(this.selectQuery(type) + " AND user='" + user + "'" + (scope.length > 0 ? " AND vre='" + scope[0].toString() + "'" : ""));
        this.query();
        return this.getResults();
    }

    public String queryByUser(String type, String user, String[] date, String ... scope) throws Exception {
        this.setQuery(this.selectQuery(type) + " AND user='" + user + "'" + this.selectDateFiler(date, " AND") + (scope.length > 0 ? " AND vre='" + scope[0].toString() + "'" : ""));
        this.query();
        return this.getResults();
    }

    public <TYPE extends BaseRecord> Long countByType(Class<TYPE> type, String ... scope) throws Exception {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", type.getSimpleName()) + (scope.length > 0 ? " AND vre='" + scope[0].toString() + "'" : ""));
        this.query();
        Long count = null;
        count = this.toJSON().getJSONObject(0).getLong("COUNT");
        return count;
    }

    public <TYPE extends BaseRecord> Long countByUser(Class<TYPE> type, String user, String ... scope) throws Exception, EmptyResultException {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", type.getSimpleName()) + " AND user='" + user + "'" + (scope.length > 0 ? " AND vre='" + scope[0].toString() + "'" : ""));
        this.query();
        Long count = null;
        count = this.toJSON().getJSONObject(0).getLong("COUNT");
        return count;
    }

    public Long countByType(String type, String ... scope) throws Exception {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", type) + (scope.length > 0 ? " AND vre='" + scope[0].toString() + "'" : ""));
        this.query();
        Long count = null;
        count = this.toJSON().getJSONObject(0).getLong("COUNT");
        return count;
    }

    public Long countByUser(String type, String user, String ... scope) throws Exception, EmptyResultException {
        this.setQuery("SELECT COUNT(Id) AS CNT FROM PORTALACCOUNTING WHERE type='***TYPE***'".replace("***TYPE***", type) + " AND user='" + user + "'" + (scope.length > 0 ? " AND vre='" + scope[0].toString() + "'" : ""));
        this.query();
        Long count = null;
        count = this.toJSON().getJSONObject(0).getLong("COUNT");
        return count;
    }

    public String countByTypeAndUserWithGrouping(String type, String groupBy, String[] dates, String ... user) throws Exception, EmptyResultException {
        String and = "";
        String and1 = "";
        if (type.compareTo("") != 0) {
            and = " AND ";
        }
        if (user.length > 0) {
            and1 = "AND";
        }
        this.setQuery("SELECT COUNT(Id) AS CNT, ***GROUPBY*** AS GRP FROM PORTALACCOUNTING".replace("***GROUPBY***", groupBy) + " WHERE " + this.selectDateFiler(dates, "") + and + (type.compareTo("") != 0 ? " type='" + type + "'" : "") + and1 + (user.length > 0 ? " user='" + user[0].toString() + "'" : ""));
        this.setGroupClause(groupBy);
        this.query();
        return this.getResults();
    }

    public HashMap<String, String> getCollections(String id) throws EmptyResultException, Exception {
        HashMap<String, String> collections = new HashMap<String, String>();
        this.setQuery("SELECT * FROM COLLECTION WHERE Id='***ID***' ".replace("***ID***", id));
        this.query();
        JSONArray tmp = this.toJSON();
        for (int i = 0; i < tmp.length(); ++i) {
            collections.put(tmp.getJSONObject(i).getString("identifier"), tmp.getJSONObject(i).getString("name"));
        }
        return collections;
    }

    public HashMap<String, String> getTerms(String id) throws EmptyResultException, Exception {
        HashMap<String, String> terms = new HashMap<String, String>();
        this.setQuery("SELECT * FROM TERM WHERE Id='***ID***'".replace("***ID***", id));
        this.query();
        JSONArray tmp = this.toJSON();
        for (int i = 0; i < tmp.length(); ++i) {
            terms.put(tmp.getJSONObject(i).getString("name"), tmp.getJSONObject(i).getString("value"));
        }
        return terms;
    }

    public HashMap<String, String> getWebAppDetails(String id) throws EmptyResultException, Exception {
        HashMap<String, String> terms = new HashMap<String, String>();
        this.setQuery("SELECT * FROM WEBAPPDETAIL WHERE Id='***ID***' ".replace("***ID***", id));
        this.query();
        JSONArray tmp = this.toJSON();
        for (int i = 0; i < tmp.length(); ++i) {
            terms.put(tmp.getJSONObject(i).getString("WEBAPPID"), tmp.getJSONObject(i).getString("WEBAPPNAME"));
        }
        return terms;
    }

    public HashMap<String, String> getGHNDetails(String id) throws EmptyResultException, Exception {
        HashMap<String, String> terms = new HashMap<String, String>();
        this.setQuery("SELECT * FROM GHNDETAIL WHERE Id='***ID***' ".replace("***ID***", id));
        this.query();
        JSONArray tmp = this.toJSON();
        for (int i = 0; i < tmp.length(); ++i) {
            terms.put(tmp.getJSONObject(i).getString("GHNID"), tmp.getJSONObject(i).getString("GHNNAME"));
        }
        return terms;
    }

    public HashMap<String, String> getAddresseesGCUBEUsers(String id) throws EmptyResultException, Exception {
        HashMap<String, String> gcubeAddresses = new HashMap<String, String>();
        this.setQuery("SELECT * FROM GCUBEUSERSADDRESSEES WHERE Id='***ID***' ".replace("***ID***", id));
        this.query();
        JSONArray tmp = this.toJSON();
        for (int i = 0; i < tmp.length(); ++i) {
            gcubeAddresses.put(tmp.getJSONObject(i).getString("NAME"), tmp.getJSONObject(i).getString("VRE"));
        }
        return gcubeAddresses;
    }

    public String[] getContent(String id) throws EmptyResultException, Exception {
        String[] results = new String[2];
        this.setQuery("SELECT * FROM CONTENT WHERE Id='***ID***'".replace("***ID***", id));
        this.query();
        JSONArray tmp = this.toJSON();
        results[0] = tmp.getJSONObject(0).getString("identifier");
        results[1] = tmp.getJSONObject(0).getString("name");
        return results;
    }

    public <TYPE extends BaseRecord> ArrayList<PortalAccountingMessage<TYPE>> getResultsAsMessage(Class<TYPE> type) throws Exception, EmptyResultException {
        ArrayList<PortalAccountingMessage<TYPE>> list = new ArrayList<PortalAccountingMessage<TYPE>>();
        JSONArray tmp = this.toJSON();
        for (int i = 0; i < tmp.length(); ++i) {
            PortalAccountingMessage message = new PortalAccountingMessage();
            message.setUser(tmp.getJSONObject(i).getString("user"));
            message.setVre(tmp.getJSONObject(i).getString("vre"));
            message.setTime(tmp.getJSONObject(i).getString("time"));
            message.setId(tmp.getJSONObject(i).getString("Id"));
            BaseRecord record = (BaseRecord)type.newInstance();
            record.setDate(this.dateFormat.parse(tmp.getJSONObject(i).getString("date")));
            this.populateRecord(tmp.getJSONObject(i), record);
            message.addRecord(record);
            list.add(message);
        }
        return list;
    }

    private <TYPE extends BaseRecord> String selectQuery(Class<TYPE> type) {
        if (type.equals(LoginRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, LOGIN.message AS message FROM PORTALACCOUNTING,LOGIN WHERE PORTALACCOUNTING.type='LoginRecord' AND PORTALACCOUNTING.Id=LOGIN.Id";
        }
        if (type.equals(BrowseRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, BROWSE.browseBy AS browseBy, BROWSE.isDistinct AS isDistinct FROM PORTALACCOUNTING, BROWSE WHERE PORTALACCOUNTING.type='BrowseRecord' AND PORTALACCOUNTING.Id=BROWSE.Id";
        }
        if (type.equals(AdvancedSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ADVANCEDSEARCH.operator AS operator  FROM PORTALACCOUNTING,ADVANCEDSEARCH WHERE PORTALACCOUNTING.type='AdvancedSearchRecord' AND PORTALACCOUNTING.Id=ADVANCEDSEARCH.Id";
        }
        if (type.equals(SimpleSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, SIMPLESEARCH.termValue AS termValue FROM PORTALACCOUNTING,SIMPLESEARCH WHERE PORTALACCOUNTING.type='SimpleSearchRecord' AND PORTALACCOUNTING.Id=SIMPLESEARCH.Id";
        }
        if (type.equals(ContentRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, CONTENT.identifier AS identifier, CONTENT.name AS name  FROM  PORTALACCOUNTING, CONTENT WHERE PORTALACCOUNTING.type='ContentRecord' AND PORTALACCOUNTING.Id=CONTENT.Id";
        }
        if (type.equals(GenericRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GENERIC.message AS message  FROM  PORTALACCOUNTING, GENERIC WHERE PORTALACCOUNTING.type='GenericRecord' AND PORTALACCOUNTING.Id=GENERIC.Id";
        }
        if (type.equals(GoogleSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GOOGLESEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, GOOGLESEARCH WHERE PORTALACCOUNTING.type='GoogleSearchRecord' AND PORTALACCOUNTING.Id=GOOGLESEARCH.Id";
        }
        if (type.equals(QuickSearchRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, QUICKSEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, QUICKSEARCH WHERE PORTALACCOUNTING.type='QuickSearchRecord' AND PORTALACCOUNTING.Id=QUICKSEARCH.Id";
        }
        if (type.equals(HLRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, HL.IDENTIFIER AS IDENTIFIER, HL.NAME AS NAME, HL.TYPE AS HL_TYPE, HL.SUBTYPE AS SUBTYPE FROM  PORTALACCOUNTING, HL WHERE PORTALACCOUNTING.type='HLRecord' AND PORTALACCOUNTING.Id=HL.Id";
        }
        if (type.equals(AISRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AIS.IDENTIFIER AS IDENTIFIER, AIS.NAME AS NAME, AIS.SUBTYPE AS SUBTYPE FROM PORTALACCOUNTING, AIS WHERE PORTALACCOUNTING.type='AISRecord' AND PORTALACCOUNTING.Id=AIS.Id";
        }
        if (type.equals(TSRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, TS.TITLE AS TITLE, TS.SUBTYPE AS SUBTYPE   FROM  PORTALACCOUNTING, TS WHERE PORTALACCOUNTING.type='TSRecord' AND PORTALACCOUNTING.Id=TS.Id";
        }
        if (type.equals(AnnotationRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ANNOTATION.NAME AS NAME, ANNOTATION.ACTION AS ACTION,ANNOTATION.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, ANNOTATION WHERE PORTALACCOUNTING.type='AnnotationRecord' AND PORTALACCOUNTING.Id=ANNOTATION.Id";
        }
        if (type.equals(ReportRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, REPORT.SUBTYPE AS SUBTYPE, REPORT.TEMPLATEID AS TEMPLATEID, REPORT.TEMPLATENAME AS TEMPLATENAME, REPORT.AUTHOR AS AUTHOR, REPORT.NAME AS NAME, REPORT.MIMETYPE AS MIMETYPE, REPORT.TYPE AS TYPE  FROM  PORTALACCOUNTING, REPORT WHERE PORTALACCOUNTING.type='ReportRecord' AND PORTALACCOUNTING.Id=REPORT.Id";
        }
        if (type.equals(DocumentWorkflowRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, DOCUMENTWORKFLOW.SUBTYPE AS SUBTYPE, DOCUMENTWORKFLOW.WORKFLOWID AS WORKFLOWID,DOCUMENTWORKFLOW.REPORTNAME AS REPORTNAME,DOCUMENTWORKFLOW.STATUS AS STATUS,DOCUMENTWORKFLOW.STEPNUMBER AS STEPNUMBER  FROM  PORTALACCOUNTING, DOCUMENTWORKFLOW WHERE PORTALACCOUNTING.type='DocumentWorkflowRecord' AND PORTALACCOUNTING.Id=DOCUMENTWORKFLOW.Id";
        }
        if (type.equals(WebAppRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WEBAPP.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, WEBAPP WHERE PORTALACCOUNTING.type='WebAppRecord' AND PORTALACCOUNTING.Id=WEBAPP.Id";
        }
        if (type.equals(WarRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WAR.SUBTYPE AS SUBTYPE,WAR.WARID AS WARID,WAR.WARNAME AS WARNAME,WAR.WEBAPPNAME AS WEBAPPNAME, WAR.WEBAPPVERSION AS WEBAPPVERSION, WAR.CATEGORY AS CATEGORY FROM  PORTALACCOUNTING, WAR WHERE PORTALACCOUNTING.type='WarRecord' AND PORTALACCOUNTING.Id=WAR.Id";
        }
        if (type.equals(AquamapsRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AQUAMAPS.TITLE AS TITLE, AQUAMAPS.AQUAMAPSTYPE AS AQUAMAPSTYPE,AQUAMAPS.SUBTYPE AS SUBTYPE,AQUAMAPS.SPECIESCOUNT AS SPECIESCOUNT ,AQUAMAPS.GIS AS GIS,AQUAMAPS.HSPECID AS HSPECID,AQUAMAPS.OBJECTID AS OBJECTID    FROM  PORTALACCOUNTING, AQUAMAPS WHERE PORTALACCOUNTING.type='AquamapsRecord' AND PORTALACCOUNTING.Id=AQUAMAPS.Id";
        }
        if (type.equals(StatisticalManagerRecord.class)) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, SM.SUBTYPE AS SUBTYPE,SM.FILENAME AS FILENAME ,SM.FILETYPE AS FILETYPE,SM.ALGORITHMNAME AS ALGORITHMNAME,SM.EXECUTIONOUTCOME AS EXECUTIONOUTCOME, SM.EXECUTIONTIME AS EXECUTIONTIME    FROM  PORTALACCOUNTING, SM WHERE PORTALACCOUNTING.type='StatisticalManagerRecord' AND PORTALACCOUNTING.Id=SM.Id";
        }
        return "";
    }

    private String selectQuery(String type) {
        this.logger.debug("QUERY TYPE: " + type);
        if (type.equals("LoginRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, LOGIN.message AS message FROM PORTALACCOUNTING,LOGIN WHERE PORTALACCOUNTING.type='LoginRecord' AND PORTALACCOUNTING.Id=LOGIN.Id";
        }
        if (type.equals("BrowseRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, BROWSE.browseBy AS browseBy, BROWSE.isDistinct AS isDistinct FROM PORTALACCOUNTING, BROWSE WHERE PORTALACCOUNTING.type='BrowseRecord' AND PORTALACCOUNTING.Id=BROWSE.Id";
        }
        if (type.equals("AdvancedSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ADVANCEDSEARCH.operator AS operator  FROM PORTALACCOUNTING,ADVANCEDSEARCH WHERE PORTALACCOUNTING.type='AdvancedSearchRecord' AND PORTALACCOUNTING.Id=ADVANCEDSEARCH.Id";
        }
        if (type.equals("SimpleSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, SIMPLESEARCH.termValue AS termValue FROM PORTALACCOUNTING,SIMPLESEARCH WHERE PORTALACCOUNTING.type='SimpleSearchRecord' AND PORTALACCOUNTING.Id=SIMPLESEARCH.Id";
        }
        if (type.equals("ContentRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, CONTENT.identifier AS identifier, CONTENT.name AS name  FROM  PORTALACCOUNTING, CONTENT WHERE PORTALACCOUNTING.type='ContentRecord' AND PORTALACCOUNTING.Id=CONTENT.Id";
        }
        if (type.equals("GenericRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GENERIC.message AS message  FROM  PORTALACCOUNTING, GENERIC WHERE PORTALACCOUNTING.type='GenericRecord' AND PORTALACCOUNTING.Id=GENERIC.Id";
        }
        if (type.equals("GoogleSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, GOOGLESEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, GOOGLESEARCH WHERE PORTALACCOUNTING.type='GoogleSearchRecord' AND PORTALACCOUNTING.Id=GOOGLESEARCH.Id";
        }
        if (type.equals("QuickSearchRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, QUICKSEARCH.termValue AS termValue  FROM  PORTALACCOUNTING, QUICKSEARCH WHERE PORTALACCOUNTING.type='QuickSearchRecord' AND PORTALACCOUNTING.Id=QUICKSEARCH.Id";
        }
        if (type.equals("HLRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, HL.IDENTIFIER AS IDENTIFIER, HL.NAME AS NAME, HL.TYPE AS HL_TYPE, HL.SUBTYPE AS SUBTYPE FROM  PORTALACCOUNTING, HL WHERE PORTALACCOUNTING.type='HLRecord' AND PORTALACCOUNTING.Id=HL.Id";
        }
        if (type.equals("AISRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AIS.IDENTIFIER AS IDENTIFIER, AIS.NAME AS NAME, AIS.SUBTYPE AS SUBTYPE FROM PORTALACCOUNTING, AIS WHERE PORTALACCOUNTING.type='AISRecord' AND PORTALACCOUNTING.Id=AIS.Id";
        }
        if (type.equals("TSRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, TS.TITLE AS TITLE, TS.SUBTYPE AS SUBTYPE   FROM  PORTALACCOUNTING, TS WHERE PORTALACCOUNTING.type='TSRecord' AND PORTALACCOUNTING.Id=TS.Id";
        }
        if (type.equals("AnnotationRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, ANNOTATION.NAME AS NAME, ANNOTATION.ACTION AS ACTION,ANNOTATION.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, ANNOTATION WHERE PORTALACCOUNTING.type='AnnotationRecord' AND PORTALACCOUNTING.Id=ANNOTATION.Id";
        }
        if (type.equals("WebAppRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WEBAPP.SUBTYPE AS SUBTYPE  FROM  PORTALACCOUNTING, WEBAPP WHERE PORTALACCOUNTING.type='WebAppRecord' AND PORTALACCOUNTING.Id=WEBAPP.Id";
        }
        if (type.equals("WarRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, WAR.SUBTYPE AS SUBTYPE,WAR.WARID AS WARID,WAR.WARNAME AS WARNAME,WAR.WEBAPPNAME AS WEBAPPNAME, WAR.WEBAPPVERSION AS WEBAPPVERSION, WAR.CATEGORY AS CATEGORY FROM  PORTALACCOUNTING, WAR WHERE PORTALACCOUNTING.type='WarRecord' AND PORTALACCOUNTING.Id=WAR.Id";
        }
        if (type.equals("ReportRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, REPORT.SUBTYPE AS SUBTYPE, REPORT.TEMPLATEID AS TEMPLATEID, REPORT.TEMPLATENAME AS TEMPLATENAME, REPORT.AUTHOR AS AUTHOR, REPORT.NAME AS NAME, REPORT.MIMETYPE AS MIMETYPE, REPORT.TYPE AS TYPE  FROM  PORTALACCOUNTING, REPORT WHERE PORTALACCOUNTING.type='ReportRecord' AND PORTALACCOUNTING.Id=REPORT.Id";
        }
        if (type.equals("DocumentWorkflowRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, DOCUMENTWORKFLOW.SUBTYPE AS SUBTYPE, DOCUMENTWORKFLOW.WORKFLOWID AS WORKFLOWID,DOCUMENTWORKFLOW.REPORTNAME AS REPORTNAME,DOCUMENTWORKFLOW.STATUS AS STATUS,DOCUMENTWORKFLOW.STEPNUMBER AS STEPNUMBER  FROM  PORTALACCOUNTING, DOCUMENTWORKFLOW WHERE PORTALACCOUNTING.type='DocumentWorkflowRecord' AND PORTALACCOUNTING.Id=DOCUMENTWORKFLOW.Id";
        }
        if (type.equals("AquamapsRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, AQUAMAPS.TITLE AS TITLE, AQUAMAPS.AQUAMAPSTYPE AS AQUAMAPSTYPE,AQUAMAPS.SUBTYPE AS SUBTYPE,AQUAMAPS.SPECIESCOUNT AS SPECIESCOUNT ,AQUAMAPS.GIS AS GIS,AQUAMAPS.HSPECID AS HSPECID,AQUAMAPS.OBJECTID AS OBJECTID    FROM  PORTALACCOUNTING, AQUAMAPS WHERE PORTALACCOUNTING.type='AquamapsRecord' AND PORTALACCOUNTING.Id=AQUAMAPS.Id";
        }
        if (type.equals("StatisticalManagerRecord")) {
            return "SELECT PORTALACCOUNTING.user AS user, PORTALACCOUNTING.vre as vre,  PORTALACCOUNTING.Id AS Id, PORTALACCOUNTING.date AS date, PORTALACCOUNTING.time AS time, PORTALACCOUNTING.type AS type, SM.SUBTYPE AS SUBTYPE,SM.FILENAME AS FILENAME ,SM.FILETYPE AS FILETYPE,SM.ALGORITHMNAME AS ALGORITHMNAME,SM.EXECUTIONOUTCOME AS EXECUTIONOUTCOME, SM.EXECUTIONTIME AS EXECUTIONTIME    FROM  PORTALACCOUNTING, SM WHERE PORTALACCOUNTING.type='StatisticalManagerRecord' AND PORTALACCOUNTING.Id=SM.Id";
        }
        return "";
    }

    private <TYPE extends BaseRecord> TYPE populateRecord(JSONObject obj, TYPE record) throws JSONException {
        if (record instanceof LoginRecord) {
            ((LoginRecord)record).setMessage(obj.getString("message"));
        } else if (record instanceof ContentRecord) {
            ((ContentRecord)record).setContentId(obj.getString("identifier"));
            ((ContentRecord)record).setContentName(obj.getString("name"));
        } else if (record instanceof BrowseRecord) {
            ((BrowseRecord)record).setBrowseBy(obj.getString("browseBy"));
            ((BrowseRecord)record).setBrowseBy(obj.getString("isDistinct"));
        } else if (record instanceof AdvancedSearchRecord) {
            ((AdvancedSearchRecord)record).setOperator(AdvancedSearchRecord.OperatorType.valueOf((String)obj.getString("operator")));
        } else if (record instanceof SimpleSearchRecord) {
            ((SimpleSearchRecord)record).setTerm(obj.getString("termValue"));
        } else if (record instanceof QuickSearchRecord) {
            ((QuickSearchRecord)record).setTerm(obj.getString("termValue"));
        } else if (record instanceof GoogleSearchRecord) {
            ((GoogleSearchRecord)record).setTerm(obj.getString("termValue"));
        } else if (record instanceof HLRecord) {
            ((HLRecord)record).setHLsubType(HLRecord.HLSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((HLRecord)record).setID(obj.getString("IDENTIFIER"));
            ((HLRecord)record).setType(obj.getString("HL_TYPE"));
            ((HLRecord)record).setName(obj.getString("NAME"));
        } else if (record instanceof AISRecord) {
            ((AISRecord)record).setAISsubType(AISRecord.AISSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((AISRecord)record).setID(obj.getString("IDENTIFIER"));
            ((AISRecord)record).setName(obj.getString("NAME"));
        } else if (record instanceof TSRecord) {
            ((TSRecord)record).setTSsubType(TSRecord.TSSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((TSRecord)record).setTitle(obj.getString("TITLE"));
        } else if (record instanceof WebAppRecord) {
            ((WebAppRecord)record).setSubType(WebAppRecord.WebAppSubType.valueOf((String)obj.getString("SUBTYPE")));
        } else if (record instanceof WarRecord) {
            ((WarRecord)record).setSubType(WarRecord.WarSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((WarRecord)record).setWarId(obj.getString("WARID"));
            ((WarRecord)record).setWarName(obj.getString("WARNAME"));
            ((WarRecord)record).setAppName(obj.getString("WEBAPPNAME"));
            ((WarRecord)record).setAppVersion(obj.getString("WEBAPPVERSION"));
            ((WarRecord)record).setCategory(obj.getString("CATEGORY"));
        } else if (record instanceof AnnotationRecord) {
            ((AnnotationRecord)record).setAnnotationSubType(AnnotationRecord.AnnotationSubType.valueOf((String)obj.getString("ACTION")));
            ((AnnotationRecord)record).setAnnotationName(obj.getString("name"));
            ((AnnotationRecord)record).setAnnotationType(obj.getString("SUBTYPE"));
        } else if (record instanceof ReportRecord) {
            ((ReportRecord)record).setAuthor(obj.getString("AUTHOR"));
            ((ReportRecord)record).setMimetype(obj.getString("MIMETYPE"));
            ((ReportRecord)record).setName(obj.getString("name"));
            ((ReportRecord)record).setSubType(ReportRecord.ReportSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((ReportRecord)record).setTemplateID(obj.getString("TEMPLATEID"));
            ((ReportRecord)record).setTemplateName(obj.getString("TEMPLATENAME"));
            ((ReportRecord)record).setType(obj.getString("***TYPE***"));
        } else if (record instanceof DocumentWorkflowRecord) {
            ((DocumentWorkflowRecord)record).setSubType(DocumentWorkflowRecord.WorkflowSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((DocumentWorkflowRecord)record).setReportname(obj.getString("REPORTNAME"));
            ((DocumentWorkflowRecord)record).setStatus(obj.getString("STATUS"));
            ((DocumentWorkflowRecord)record).setStepsNumber(obj.getString("STEPNUMBER"));
            ((DocumentWorkflowRecord)record).setWorkflowid(obj.getString("WORKFLOWID"));
        } else if (record instanceof AquamapsRecord) {
            ((AquamapsRecord)record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.valueOf((String)obj.getString("SUBTYPE")));
            ((AquamapsRecord)record).setGis(Boolean.parseBoolean(obj.getString("GIS")));
            ((AquamapsRecord)record).setHspecId(obj.getString("HSPECID"));
            ((AquamapsRecord)record).setObjectID(obj.getString("OBJECTID"));
            ((AquamapsRecord)record).setSpeciesCount(Long.parseLong(obj.getString("SPECIESCOUNT")));
            ((AquamapsRecord)record).setTitle(obj.getString("TITLE"));
            ((AquamapsRecord)record).setType(obj.getString("AQUAMAPSTYPE"));
        }
        return record;
    }
}

