/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gcube.messaging.common.consumerlibrary.ConsumerCL;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.Query;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;
import org.gcube.messaging.common.messages.Test;

public class MonitoringQuery
extends Query<ConsumerCL> {
    private static final long serialVersionUID = 1L;

    @Override
    public String performQuery() throws Exception {
        this.logger.debug(this.getQuery());
        Long startTime = System.currentTimeMillis();
        String result = this.call.queryMonitoringDB(this.getQuery());
        Long endTime = System.currentTimeMillis();
        this.logger.debug("Query time = " + (endTime - startTime) + " ms");
        return result;
    }

    public String getGHNAverage(Test.TestType type, String ghn) throws EmptyResultException, Exception {
        String res = null;
        this.setQuery("SELECT AVG(CAST(GHNMessage.result AS " + this.getType(type) + ")) AS AVG FROM GHNMessage " + "WHERE GHNMessage.testType='" + type.name() + "' AND GHNMessage.GHNName='" + ghn + "'");
        try {
            this.query();
            res = this.toJSON().getJSONObject(0).getString("AVG");
        }
        catch (EmptyResultException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Error executing query");
            throw e;
        }
        return res;
    }

    public String getTodayGHNAverage(Test.TestType type, String ghn) throws EmptyResultException, Exception {
        String res = null;
        this.setQuery("SELECT AVG(CAST(GHNMessage.result AS " + this.getType(type) + ")) AS AVG FROM GHNMessage " + "WHERE GHNMessage.testType='" + type.name() + "' AND GHNMessage.GHNName='" + ghn + "' AND GHNMessage.date='" + this.getTodayString() + "'");
        try {
            this.query();
            res = this.toJSON().getJSONObject(0).getString("AVG");
        }
        catch (EmptyResultException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Error executing query");
            throw e;
        }
        return res;
    }

    public HashMap<String, String> getProbes() throws Exception {
        HashMap<String, String> hash = new HashMap<String, String>();
        this.setQuery("SELECT DISTINCT testType, description  FROM GHNMessage ORDER BY testType");
        try {
            this.query();
            JSONArray tmp = this.toJSON();
            for (int i = 0; i < tmp.length(); ++i) {
                String type = tmp.getJSONObject(i).getString("testType");
                String desc = tmp.getJSONObject(i).getString("description");
                hash.put(type, desc);
            }
        }
        catch (JSONException e) {
            this.logger.error("Error executing query");
            throw new Exception(e);
        }
        catch (EmptyResultException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        catch (QueryNotSetException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Error executing query");
            throw e;
        }
        return hash;
    }

    public Map<String, ArrayList<String>> getGHNs() throws Exception {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        this.setQuery("SELECT DISTINCT GHNName  FROM GHNMessage ORDER BY GHNName");
        try {
            this.query();
            JSONArray tmp = this.toJSON();
            for (int i = 0; i < tmp.length(); ++i) {
                String ghn = tmp.getJSONObject(i).getString("GHNName");
                this.logger.debug("GHN: " + ghn);
                String temp = ghn.substring(ghn.indexOf(".") + 1);
                String domain = temp.substring(0, temp.indexOf(":"));
                ArrayList<String> list = null;
                list = (ArrayList<String>)map.get(domain);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(ghn);
                map.put(domain, list);
            }
        }
        catch (JSONException e) {
            this.logger.error("Error executing query");
            throw new Exception(e);
        }
        catch (EmptyResultException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        catch (QueryNotSetException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Error executing query");
            throw e;
        }
        return map;
    }

    public String getAllTodayGHNAverage(Test.TestType type) throws Exception {
        this.setQuery("SELECT AVG(CAST(GHNMessage.result AS " + this.getType(type) + ")) AS AVG, " + "GHNMessage.GHNName FROM " + "GHNMessage WHERE GHNMessage.testType='" + type.name() + "'" + " AND GHNMessage.date='" + this.getTodayString() + "' GROUP BY GHNMessage.GHNName");
        return this.query();
    }

    public String getNotifications() throws Exception {
        this.setQuery("SELECT * FROM NOTIFICATION");
        return this.query();
    }

    public String getTodayNotifications() throws Exception {
        this.setQuery("SELECT * FROM NOTIFICATION WHERE date='" + this.getTodayString() + "'");
        return this.query();
    }

    public String getTodayRIMessages(String serviceClass, String serviceName) throws Exception {
        this.setQuery("SELECT * FROM RIMessage WHERE  ServiceName='" + serviceName + "' " + "AND ServiceClass='" + serviceClass + "' AND date='" + this.getTodayString() + "'");
        return this.query();
    }

    public String getRIMessages(String serviceClass, String serviceName) throws Exception {
        this.setQuery("SELECT * FROM RIMessage WHERE  ServiceName='" + serviceName + "' " + "AND ServiceClass='" + serviceClass + "'");
        return this.query();
    }

    public String getStatistics(String testType, String GHNName, String startDate, String endDate, String groupBy) throws Exception {
        this.setQuery("SELECT COUNT(*) AS CNT, AVG(result) AS AVERAGE, " + groupBy + " FROM GHNMessage " + "WHERE date >= '" + startDate + "' AND date <= '" + endDate + "' " + (testType.compareTo("") == 0 ? "" : " AND testType='" + testType + "'") + (GHNName.compareTo("") == 0 ? "" : " AND GHNName='" + GHNName + "'") + " GROUP BY " + groupBy);
        try {
            this.query();
        }
        catch (JSONException e) {
            this.logger.error("Error executing query");
            throw new Exception(e);
        }
        catch (EmptyResultException e) {
            this.logger.error("Error executing query");
            throw e;
        }
        return this.getResults();
    }

    private String getTodayString() {
        Date date = new Date();
        return this.dateFormat.format(date.getTime());
    }

    private String getType(Test.TestType testType) {
        if (testType.compareTo((Enum)Test.TestType.CPU_LOAD) == 0) {
            return "DECIMAL (3,2)";
        }
        return "UNSIGNED";
    }
}

