/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumerlibrary.query;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.messaging.common.consumer.stubs.calls.MessagingConsumerServiceCall;
import org.gcube.messaging.common.consumerlibrary.json.JSONArray;
import org.gcube.messaging.common.consumerlibrary.json.JSONException;
import org.gcube.messaging.common.consumerlibrary.query.EmptyResultException;
import org.gcube.messaging.common.consumerlibrary.query.Query;
import org.gcube.messaging.common.consumerlibrary.query.QueryNotSetException;

public class NotificationQuery
extends Query<MessagingConsumerServiceCall> {
    private static final long serialVersionUID = 1L;

    @Override
    protected String performQuery() throws Exception {
        this.logger.debug((Object)this.getQuery());
        Long l = System.currentTimeMillis();
        String string = ((MessagingConsumerServiceCall)this.call).queryMonitoringDB(this.getQuery());
        Long l2 = System.currentTimeMillis();
        this.logger.debug((Object)("Query time = " + (l2 - l) + " ms"));
        return string;
    }

    public HashMap<String, ArrayList<String>> getNotificationList() throws Exception {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        this.setQuery("SELECT DISTINCT testType, testSubType FROM NOTIFICATION ORDER BY testType");
        try {
            this.query();
            JSONArray jSONArray = this.toJSON();
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string = jSONArray.getJSONObject(i).getString("testType");
                String string2 = jSONArray.getJSONObject(i).getString("testSubType");
                ArrayList<String> arrayList = null;
                arrayList = hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(string2);
                hashMap.put(string, arrayList);
            }
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        catch (QueryNotSetException queryNotSetException) {
            this.logger.error((Object)"Error executing query");
            throw queryNotSetException;
        }
        catch (Exception exception) {
            this.logger.error((Object)"Error executing query");
            throw exception;
        }
        return hashMap;
    }

    public String getStatistics(String string, String string2, String string3, String string4, String string5) throws Exception {
        this.setQuery("SELECT COUNT(*) AS CNT, " + string5 + " FROM NOTIFICATION " + "WHERE date >= '" + string3 + "' AND date <= '" + string4 + "' " + (string.compareTo("") == 0 ? "" : " AND testSubType='" + string + "'") + (string2.compareTo("") == 0 ? "" : " AND GHNName='" + string2 + "'") + " GROUP BY " + string5);
        try {
            this.query();
        }
        catch (JSONException jSONException) {
            this.logger.error((Object)"Error executing query");
            throw new Exception(jSONException);
        }
        catch (EmptyResultException emptyResultException) {
            this.logger.error((Object)"Error executing query");
            throw emptyResultException;
        }
        return this.getResults();
    }
}

