/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.probes;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.probes.ParseFilters;
import org.gcube.messaging.common.messages.PortalAccountingMessage;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class PortalAccountingProbe
extends GCUBETestProbe {
    private String logsLocation = System.getenv("CATALINA_HOME") + File.separator + "temp" + File.separator + "accessLogs";

    private ArrayList<PortalAccountingMessage<?>> groupAccountingMessages(ArrayList<LogEntry> arrayList, ParseFilters parseFilters) {
        ArrayList arrayList2 = new ArrayList();
        HashMap hashMap = new HashMap();
        for (LogEntry object : arrayList) {
            Class<?> clazz;
            PortalAccountingMessage portalAccountingMessage;
            if (parseFilters != null && parseFilters.applyFilters(object.getUser().trim())) {
                GCUBELocalProducer.logger.error((Object)("The Log Entry Record belongs to a banned user: " + object.getUser() + ", DISCARDED!"));
                continue;
            }
            MapKey<String, String> mapKey = new MapKey<String, String>(object.getUser(), object.getVre());
            HashMap hashMap2 = null;
            hashMap2 = (HashMap)hashMap.get(mapKey.getKey());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            if ((portalAccountingMessage = (PortalAccountingMessage)hashMap2.get(clazz = object.getRecord().getClass())) == null) {
                portalAccountingMessage = new PortalAccountingMessage();
                portalAccountingMessage.setUser(object.getUser());
                portalAccountingMessage.setVre(object.getVre());
            }
            portalAccountingMessage.addRecord(object.fillRecord());
            hashMap2.put(clazz, portalAccountingMessage);
            hashMap.put(mapKey.getKey(), hashMap2);
        }
        for (String string : hashMap.keySet()) {
            for (HashMap hashMap2 : ((HashMap)hashMap.get(string)).values()) {
                arrayList2.add((PortalAccountingMessage<?>)hashMap2);
            }
        }
        return arrayList2;
    }

    private ArrayList<PortalAccountingMessage<?>> createAccoutingMessages(File file, ParseFilters parseFilters) {
        AccessLogParser accessLogParser = new AccessLogParser(file.getAbsolutePath());
        try {
            accessLogParser.parse();
        }
        catch (IOException iOException) {
            GCUBELocalProducer.logger.error((Object)"Error Parsing portal Log file", (Throwable)iOException);
        }
        catch (ParseException parseException) {
            GCUBELocalProducer.logger.error((Object)"Error Parsing portal Log file", (Throwable)parseException);
        }
        return this.groupAccountingMessages(accessLogParser.getEntryList(), parseFilters);
    }

    private File[] getLogFileToParse() {
        File file = new File(this.logsLocation);
        return file.listFiles(new AccessLogFilter());
    }

    private void renameFile(File file) {
        file.renameTo(new File(file.getAbsolutePath() + ".OK"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        ParseFilters parseFilters = null;
        File[] fileArray = this.getLogFileToParse();
        GCUBELocalProducer.logger.debug((Object)"Executing Accounting portal probe");
        try {
            parseFilters = new ParseFilters();
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)"Error creating banned user filters file");
        }
        if (fileArray != null) {
            for (File file : fileArray) {
                try {
                    for (GCUBEScope gCUBEScope : GCUBELocalProducer.getMonitoredScope()) {
                        for (PortalAccountingMessage<?> portalAccountingMessage : this.createAccoutingMessages(file, parseFilters)) {
                            portalAccountingMessage.setTimeNow();
                            portalAccountingMessage.setScope(gCUBEScope.toString());
                            portalAccountingMessage.setSourceGHN(GHNContext.getContext().getHostnameAndPort());
                            portalAccountingMessage.createTopicName(gCUBEScope);
                            Thread.sleep(1000L);
                            this.sendMessage((GCUBEMessage)portalAccountingMessage);
                        }
                    }
                }
                catch (Exception exception) {
                    GCUBELocalProducer.logger.error((Object)"Error Executing Accounting probe", (Throwable)exception);
                }
                finally {
                    this.renameFile(file);
                }
            }
        } else {
            GCUBELocalProducer.logger.warn((Object)"Log file  already processed");
        }
    }

    public void sendMessage(GCUBEMessage gCUBEMessage) {
        ActiveMQClient.getSingleton().sendMessageToQueue(gCUBEMessage);
    }

    private static String getTodayLogFile() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        return "accessLog" + simpleDateFormat.format(date.getTime()) + ".log";
    }

    private class MapKey<USER, VRE> {
        private USER user;
        private VRE vre;

        MapKey(USER USER, VRE VRE) {
            this.user = USER;
            this.vre = VRE;
        }

        public String getKey() {
            return this.user + "_" + this.vre;
        }
    }

    private class AccessLogFilter
    implements FilenameFilter {
        private AccessLogFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith("accessLog") && !string.contains("OK") && string.compareTo(PortalAccountingProbe.getTodayLogFile()) != 0;
        }
    }
}

