/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.accounting.portal.logparser.entry.WarEntry;
import org.gcube.messaging.common.messages.records.BaseRecord;
import org.gcube.messaging.common.messages.records.WarRecord;
import org.gcube.messaging.common.messages.records.WebAppRecord;

public class WarEntry
extends LogEntry {
    private static final long serialVersionUID = -4173528605022856737L;
    private StringTokenizer tokenizer = null;
    private String[] warEntry = new String[5];
    protected static final String hlAddresssesSeparator = ";";
    protected static final String hlAddresssesSeparator2 = ":";

    public WarEntry(String line, AccessLogParser.EntryType type) throws ParseException {
        this.line = line;
        this.entryType = type;
        this.record = new WarRecord();
        this.parse();
    }

    protected static ArrayList<WebAppRecord.GHN> getGHN(String line) {
        ArrayList<WebAppRecord.GHN> ghns = new ArrayList<WebAppRecord.GHN>();
        String ghnString = line.substring(line.indexOf("=") + 1).trim();
        StringTokenizer tokenizer = new StringTokenizer(ghnString, hlAddresssesSeparator);
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            WebAppRecord.GHN ghn = new WebAppRecord.GHN(new WebAppRecord());
            ghn.setGHN_ID(tok.substring(0, tok.indexOf(hlAddresssesSeparator2)));
            ghn.setGHN_NAME(tok.substring(tok.indexOf(hlAddresssesSeparator2) + 1));
            ghns.add(ghn);
        }
        return ghns;
    }

    public BaseRecord fillRecord() {
        this.tokenizer = new StringTokenizer(this.message.getMessage(), "|");
        while (this.tokenizer.hasMoreElements()) {
            String tok = this.tokenizer.nextToken();
            if (tok.contains(WarTokens.ID.tokens)) {
                this.warEntry[0] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(WarTokens.APPLICATION_NAME.tokens)) {
                this.warEntry[1] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(WarTokens.APPLICATION_VERSION.tokens)) {
                this.warEntry[2] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(WarTokens.CATEGORY_NAME.tokens)) {
                this.warEntry[3] = Message.getValue((String)tok);
                continue;
            }
            if (!tok.contains(WarTokens.NAME.tokens)) continue;
            this.warEntry[4] = Message.getValue((String)tok);
        }
        this.record.setDate(this.getDate());
        ((WarRecord)this.record).setSubType(WarRecord.WarSubType.valueOf((String)this.getEntryType().name()));
        if (this.getEntryType().compareTo((Enum)AccessLogParser.EntryType.WAR_REMOVED) == 0) {
            ((WarRecord)this.record).setWarId(this.warEntry[0]);
        } else {
            ((WarRecord)this.record).setWarId(this.warEntry[0]);
            ((WarRecord)this.record).setAppName(this.warEntry[1]);
            ((WarRecord)this.record).setAppVersion(this.warEntry[2]);
            ((WarRecord)this.record).setCategory(this.warEntry[3]);
            ((WarRecord)this.record).setWarName(this.warEntry[4]);
        }
        return this.record;
    }
}

