/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.AISEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.AdvancedSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.AnnotationEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.AquamapsEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.BrowseCollectionEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.GenericEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.GoogleSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.HLEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LoginEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.QuickSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.ReportEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.RetrieveContentEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.SimpleSearchEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.StatisticalManagerEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.TSEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.WarEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.WebAppEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.WorkflowDocumentEntry;

public class AccessLogParser {
    public static String tokensSeparator = ",";
    private String fileName;
    private ArrayList<LogEntry> entryList = new ArrayList();

    public AccessLogParser() {
    }

    public AccessLogParser(String fileName) {
        this.fileName = fileName;
    }

    public void parse() throws IOException, ParseException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(new File(this.fileName)));
        while ((line = reader.readLine()) != null) {
            LogEntry entry = this.parseLine(line);
            if (entry == null) continue;
            this.entryList.add(entry);
        }
    }

    private LogEntry parseLine(String line) throws ParseException {
        LoginEntry entry = null;
        StringTokenizer tokenizer = new StringTokenizer(line, tokensSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.contains(EntryType.Login_To_VRE.type)) {
                entry = new LoginEntry(line);
                continue;
            }
            if (token.contains(EntryType.Generic_Entry.type)) {
                entry = new GenericEntry(line);
                continue;
            }
            if (token.contains(EntryType.Simple_Search.type)) {
                entry = new SimpleSearchEntry(line);
                continue;
            }
            if (token.contains(EntryType.Advanced_Search.type)) {
                entry = new AdvancedSearchEntry(line);
                continue;
            }
            if (token.contains(EntryType.Browse_Collection.type)) {
                entry = new BrowseCollectionEntry(line);
                continue;
            }
            if (token.contains(EntryType.Retrieve_Content.type)) {
                entry = new RetrieveContentEntry(line);
                continue;
            }
            if (token.contains(EntryType.Quick_Search.type)) {
                entry = new QuickSearchEntry(line);
                continue;
            }
            if (token.contains(EntryType.Google_Search.type)) {
                entry = new GoogleSearchEntry(line);
                continue;
            }
            if (token.contains(EntryType.HL_FOLDER_ITEM_CREATED.type)) {
                entry = new HLEntry(line, EntryType.HL_FOLDER_ITEM_CREATED);
                continue;
            }
            if (token.contains(EntryType.HL_FOLDER_ITEM_REMOVED.type)) {
                entry = new HLEntry(line, EntryType.HL_FOLDER_ITEM_REMOVED);
                continue;
            }
            if (token.contains(EntryType.HL_FOLDER_ITEM_IMPORTED.type)) {
                entry = new HLEntry(line, EntryType.HL_FOLDER_ITEM_IMPORTED);
                continue;
            }
            if (token.contains(EntryType.HL_ITEM_SENT.type)) {
                entry = new HLEntry(line, EntryType.HL_ITEM_SENT);
                continue;
            }
            if (token.contains(EntryType.HL_WORKSPACE_CREATED.type)) {
                entry = new HLEntry(line, EntryType.HL_WORKSPACE_CREATED);
                continue;
            }
            if (token.contains(EntryType.TS_CSV_IMPORTED.type)) {
                entry = new TSEntry(line, EntryType.TS_CSV_IMPORTED);
                continue;
            }
            if (token.contains(EntryType.TS_CURATION_STARTED.type)) {
                entry = new TSEntry(line, EntryType.TS_CURATION_STARTED);
                continue;
            }
            if (token.contains(EntryType.TS_CURATION_CLOSED.type)) {
                entry = new TSEntry(line, EntryType.TS_CURATION_CLOSED);
                continue;
            }
            if (token.contains(EntryType.TS_TIMESERIES_SAVED.type)) {
                entry = new TSEntry(line, EntryType.TS_TIMESERIES_SAVED);
                continue;
            }
            if (token.contains(EntryType.TS_TIMESERIES_PUBLISHED.type)) {
                entry = new TSEntry(line, EntryType.TS_TIMESERIES_PUBLISHED);
                continue;
            }
            if (token.contains(EntryType.SCRIPT_CREATED.type)) {
                entry = new AISEntry(line, EntryType.SCRIPT_CREATED);
                continue;
            }
            if (token.contains(EntryType.SCRIPT_REMOVED.type)) {
                entry = new AISEntry(line, EntryType.SCRIPT_REMOVED);
                continue;
            }
            if (token.contains(EntryType.SCRIPT_LAUNCHED.type)) {
                entry = new AISEntry(line, EntryType.SCRIPT_LAUNCHED);
                continue;
            }
            if (token.contains(EntryType.Create_Annotation.type)) {
                entry = new AnnotationEntry(line, EntryType.Create_Annotation);
                continue;
            }
            if (token.contains(EntryType.Edit_Annotation.type)) {
                entry = new AnnotationEntry(line, EntryType.Edit_Annotation);
                continue;
            }
            if (token.contains(EntryType.Delete_Annotation.type)) {
                entry = new AnnotationEntry(line, EntryType.Delete_Annotation);
                continue;
            }
            if (token.contains(EntryType.CREATED_WORKFLOWREPORT_OUTPUT.type)) {
                entry = new WorkflowDocumentEntry(line, EntryType.CREATED_WORKFLOWREPORT_OUTPUT);
                continue;
            }
            if (token.contains(EntryType.DELETED_WORKFLOWREPORT_OUTPUT.type)) {
                entry = new WorkflowDocumentEntry(line, EntryType.DELETED_WORKFLOWREPORT_OUTPUT);
                continue;
            }
            if (token.contains(EntryType.CREATE_REPORT.type)) {
                entry = new ReportEntry(line, EntryType.CREATE_REPORT);
                continue;
            }
            if (token.contains(EntryType.GENERATE_REPORT_OUTPUT.type)) {
                entry = new ReportEntry(line, EntryType.GENERATE_REPORT_OUTPUT);
                continue;
            }
            if (token.contains(EntryType.OPEN_REPORT.type)) {
                entry = new ReportEntry(line, EntryType.OPEN_REPORT);
                continue;
            }
            if (token.contains(EntryType.OPEN_WORKFLOW_REPORT.type)) {
                entry = new ReportEntry(line, EntryType.OPEN_WORKFLOW_REPORT);
                continue;
            }
            if (token.contains(EntryType.SAVE_WORKFLOW_REPORT.type)) {
                entry = new ReportEntry(line, EntryType.SAVE_WORKFLOW_REPORT);
                continue;
            }
            if (token.contains(EntryType.CREATE_TEMPLATE.type)) {
                entry = new ReportEntry(line, EntryType.CREATE_TEMPLATE);
                continue;
            }
            if (token.contains(EntryType.OPEN_TEMPLATE.type)) {
                entry = new ReportEntry(line, EntryType.OPEN_TEMPLATE);
                continue;
            }
            if (token.contains(EntryType.WEB_APPLICATION_DEPLOYED.type)) {
                entry = new WebAppEntry(line, EntryType.WEB_APPLICATION_DEPLOYED);
                continue;
            }
            if (token.contains(EntryType.WEB_APPLICATION_ACTIVATED.type)) {
                entry = new WebAppEntry(line, EntryType.WEB_APPLICATION_ACTIVATED);
                continue;
            }
            if (token.contains(EntryType.WEB_APPLICATION_DEACTIVATED.type)) {
                entry = new WebAppEntry(line, EntryType.WEB_APPLICATION_DEACTIVATED);
                continue;
            }
            if (token.contains(EntryType.WEB_APPLICATION_UNDEPLOYED.type)) {
                entry = new WebAppEntry(line, EntryType.WEB_APPLICATION_UNDEPLOYED);
                continue;
            }
            if (token.contains(EntryType.WAR_REMOVED.type)) {
                entry = new WarEntry(line, EntryType.WAR_REMOVED);
                continue;
            }
            if (token.contains(EntryType.WAR_UPDATED.type)) {
                entry = new WarEntry(line, EntryType.WAR_UPDATED);
                continue;
            }
            if (token.contains(EntryType.WAR_UPLOADED.type)) {
                entry = new WarEntry(line, EntryType.WAR_UPLOADED);
                continue;
            }
            if (token.contains(EntryType.AQUAMAPSOBJECTGENERATION.type)) {
                entry = new AquamapsEntry(line, EntryType.AQUAMAPSOBJECTGENERATION);
                continue;
            }
            if (token.contains(EntryType.AQUAMAPSSAVEDITEM.type)) {
                entry = new AquamapsEntry(line, EntryType.AQUAMAPSSAVEDITEM);
                continue;
            }
            if (token.contains(EntryType.STATISTICALMANAGER_EXECUTION.type)) {
                entry = new StatisticalManagerEntry(line, EntryType.STATISTICALMANAGER_EXECUTION);
                continue;
            }
            if (!token.contains(EntryType.STATISTICALMANAGER_IMPORT.type)) continue;
            entry = new StatisticalManagerEntry(line, EntryType.STATISTICALMANAGER_IMPORT);
        }
        return entry;
    }

    public ArrayList<LogEntry> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(ArrayList<LogEntry> entryList) {
        this.entryList = entryList;
    }
}

