/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.accounting.portal.logparser.entry;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.gcube.messaging.accounting.portal.logparser.AccessLogParser;
import org.gcube.messaging.accounting.portal.logparser.entry.AquamapsEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.LogEntry;
import org.gcube.messaging.accounting.portal.logparser.entry.Message;
import org.gcube.messaging.common.messages.records.AquamapsRecord;
import org.gcube.messaging.common.messages.records.BaseRecord;

public class AquamapsEntry
extends LogEntry {
    private static final long serialVersionUID = 1L;
    private String[] aquamapsEntry = new String[5];
    private String title;
    private String type;
    private long speciesCount;
    private boolean gis;
    private String hspecId;

    public AquamapsEntry(String line, AccessLogParser.EntryType type) throws ParseException {
        this.line = line;
        this.record = new AquamapsRecord();
        this.entryType = type;
        this.parse();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getSpeciesCount() {
        return this.speciesCount;
    }

    public void setSpeciesCount(long speciesCount) {
        this.speciesCount = speciesCount;
    }

    public boolean isGis() {
        return this.gis;
    }

    public void setGis(boolean gis) {
        this.gis = gis;
    }

    public String getHspecId() {
        return this.hspecId;
    }

    public void setHspecId(String hspecId) {
        this.hspecId = hspecId;
    }

    public BaseRecord fillRecord() {
        this.tokenizer = new StringTokenizer(this.message.getMessage(), "|");
        while (this.tokenizer.hasMoreElements()) {
            String tok = this.tokenizer.nextToken();
            if (tok.contains(AquamapsTokens.TITLE.tokens)) {
                this.aquamapsEntry[0] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(AquamapsTokens.TYPE.tokens)) {
                this.aquamapsEntry[1] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(AquamapsTokens.GIS.tokens)) {
                this.aquamapsEntry[2] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(AquamapsTokens.SPECIES_COUNT.tokens)) {
                this.aquamapsEntry[3] = Message.getValue((String)tok);
                continue;
            }
            if (tok.contains(AquamapsTokens.HSPEC.tokens)) {
                this.aquamapsEntry[4] = Message.getValue((String)tok);
                continue;
            }
            if (!tok.contains(AquamapsTokens.ID.tokens)) continue;
            this.aquamapsEntry[4] = Message.getValue((String)tok);
        }
        this.record.setDate(this.getDate());
        ((AquamapsRecord)this.record).setTitle(this.aquamapsEntry[0]);
        ((AquamapsRecord)this.record).setType(this.aquamapsEntry[1]);
        ((AquamapsRecord)this.record).setGis(Boolean.parseBoolean(this.aquamapsEntry[2]));
        ((AquamapsRecord)this.record).setSpeciesCount(Long.parseLong(this.aquamapsEntry[3]));
        if (this.getEntryType().compareTo((Enum)AccessLogParser.EntryType.AQUAMAPSOBJECTGENERATION) == 0) {
            ((AquamapsRecord)this.record).setHspecId(this.aquamapsEntry[4]);
            ((AquamapsRecord)this.record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.AquamapsGeneration);
        } else {
            ((AquamapsRecord)this.record).setObjectID(this.aquamapsEntry[4]);
            ((AquamapsRecord)this.record).setAquamapsSubtype(AquamapsRecord.AquamapsSubType.AquamapsSavedItem);
        }
        return this.record;
    }
}

