/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.gcube.common.accounting.node.persistence.RIAccountingData;
import org.gcube.common.accounting.node.util.Util;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class PersistenceAdapter {
    private GCUBELog logger = null;
    private HashMap<String, HashMap<String, RIAccountingData>> map = null;
    private static String persistenceFolder = GHNContext.getContext().getStorageRoot() + File.separator + "Accounting";
    private static File accountingDataFileName = new File(persistenceFolder + File.separator + "Accounting.store");
    private Calendar lastUpdate;
    private Long interval;
    private boolean recreateState = false;

    public PersistenceAdapter(GCUBELog logger, Long interval) {
        this.interval = interval;
        if (!new File(persistenceFolder).exists()) {
            logger.debug((Object)"Creating persistence folder");
            new File(persistenceFolder).mkdirs();
        }
        this.logger = logger;
    }

    public Calendar getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Calendar lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void store() throws Exception {
        File tmpFile = null;
        ObjectOutputStream oos = null;
        try {
            tmpFile = File.createTempFile("persistence", ".tmp", new File(persistenceFolder));
            FileOutputStream fos = new FileOutputStream(tmpFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.map);
            oos.writeObject(this.lastUpdate);
            oos.writeObject(this.interval);
            oos.flush();
            fos.getFD().sync();
            if (!tmpFile.renameTo(accountingDataFileName)) {
                throw new Exception("Could not rename temporary serialisation file for " + accountingDataFileName);
            }
        }
        catch (Exception e) {
            if (tmpFile != null) {
                tmpFile.delete();
            }
            throw e;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not close stream on file serialisation");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void load() throws Exception {
        if (PersistenceAdapter.accountingDataFileName.exists()) {
            fis = new FileInputStream(PersistenceAdapter.accountingDataFileName);
            ois = null;
            try {
                ois = new ObjectInputStream(fis);
                this.map = (HashMap)ois.readObject();
                this.lastUpdate = (Calendar)ois.readObject();
                pastInterval = (Long)ois.readObject();
                if (pastInterval != null && pastInterval.longValue() != this.interval.longValue()) {
                    this.recreateState = true;
                }
                if (!this.recreateState) ** GOTO lbl23
                this.logger.warn((Object)"Interval changed. recreating state");
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Could not close stream on file deserialisation");
                }
            }
        } else {
            this.recreateState = true;
        }
lbl23:
        // 3 sources

        if (this.recreateState) {
            this.map = new HashMap<K, V>();
            for (GCUBEServiceContext context : GHNContext.getContext().getServiceContexts()) {
                mapServices = null;
                key = new MapKey<String, String>(context.getServiceClass(), context.getName()).getKey();
                mapServices = this.map.get(key);
                if (mapServices == null) {
                    mapServices = new HashMap<K, V>();
                }
                for (GCUBEScope scope : context.getInstance().getScopes().values()) {
                    data = new RIAccountingData(this.getInterval());
                    data.setServiceClass(context.getServiceClass());
                    data.setServiceName(context.getName());
                    mapServices.put(scope.toString(), data);
                }
                this.map.put(key, mapServices);
            }
        } else {
            for (GCUBEServiceContext context : GHNContext.getContext().getServiceContexts()) {
                key = new MapKey<String, String>(context.getServiceClass(), context.getName()).getKey();
                if (this.map.get(key) != null) continue;
                mapServices = new HashMap<String, RIAccountingData>();
                for (GCUBEScope scope : context.getInstance().getScopes().values()) {
                    data = new RIAccountingData(this.getInterval());
                    data.setServiceClass(context.getServiceClass());
                    data.setServiceName(context.getName());
                    mapServices.put(scope.toString(), data);
                }
                this.map.put(key, mapServices);
            }
            servicesToRemove = new ArrayList<String>();
            for (String service : this.map.keySet()) {
                clazz = Util.getClazz(service);
                name = Util.getName(service);
                try {
                    GHNContext.getContext().getServiceContext(clazz, name);
                }
                catch (Exception e) {
                    servicesToRemove.add(service);
                }
            }
            for (String service : servicesToRemove) {
                this.map.remove(service);
            }
        }
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public HashMap<String, HashMap<String, RIAccountingData>> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, HashMap<String, RIAccountingData>> map) {
        this.map = map;
    }

    public boolean alreadyUpdated() {
        if (this.getLastUpdate() == null) {
            return false;
        }
        return Calendar.getInstance().getTimeInMillis() / 1000L - this.getInterval() <= this.getLastUpdate().getTimeInMillis() / 1000L;
    }

    public class MapKey<CLASS, NAME>
    implements Serializable {
        private CLASS clazz;
        private NAME name;

        public MapKey(CLASS clazz, NAME name) {
            this.clazz = clazz;
            this.name = name;
        }

        public String getKey() {
            return this.clazz + "_" + this.name;
        }
    }
}

