/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.probes;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.gcube.common.accounting.node.persistence.RIAccountingData;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.runninginstance.ScopedAccounting;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class RIProfileUpdater
extends GCUBEHandler<GCUBEServiceContext> {
    private HashMap<String, RIAccountingData> data = null;

    public RIProfileUpdater(HashMap<String, RIAccountingData> hashMap) throws Exception {
        this.data = hashMap;
        RIAccountingData rIAccountingData = hashMap.values().iterator().next();
        GCUBELocalProducer.logger.debug((Object)("Publishing RI profile for service " + rIAccountingData.getServiceClass() + "_" + rIAccountingData.getServiceName()));
        this.setHandled(GHNContext.getContext().getServiceContext(rIAccountingData.getServiceClass(), rIAccountingData.getServiceName()));
    }

    public void run() throws Exception {
        this.updateAccoutingInfoOnProfile();
    }

    private void updateAccoutingInfoOnProfile() throws Exception {
        HashMap<GCUBEScope, ScopedAccounting> hashMap = new HashMap<GCUBEScope, ScopedAccounting>();
        for (String string : this.data.keySet()) {
            try {
                ScopedAccounting scopedAccounting = null;
                scopedAccounting = (ScopedAccounting)hashMap.get(GCUBEScope.getScope((String)string));
                if (scopedAccounting == null) {
                    scopedAccounting = new ScopedAccounting();
                    scopedAccounting.setScope(GCUBEScope.getScope((String)string));
                }
                scopedAccounting.setTotalINCalls(Long.valueOf(this.data.get(string).getTotalCalls()));
                scopedAccounting.getAverageCallsMap().clear();
                for (Long l : this.data.get(string).getAvgCallsNumber().getIntervalMapping().keySet()) {
                    scopedAccounting.getAverageCallsMap().put(l, this.data.get(string).getAvgCallsNumber().getStatistics(this.data.get(string).getAvgCallsNumber().getIntervalMapping().get(l)));
                }
                scopedAccounting.getAverageTimeMap().clear();
                for (Long l : this.data.get(string).getAvgInvocationTime().getIntervalMapping().keySet()) {
                    scopedAccounting.getAverageTimeMap().put(l, this.data.get(string).getAvgInvocationTime().getStatistics(this.data.get(string).getAvgInvocationTime().getIntervalMapping().get(l)));
                }
                String string2 = this.data.get(string).getTopCallerData().getTopCallerInfo().getCallerHost();
                scopedAccounting.setTopCallerGHN(string2);
                scopedAccounting.setTopCallerGHNtotalCalls(Long.valueOf(this.data.get(string).getTopCallerData().getTopCallerInfo().getTotalCalls()));
                scopedAccounting.setTopCallerGHNavgDailyCalls(Double.valueOf(this.data.get(string).getTopCallerData().getCallerMap().get(string2).get(this.data.get(string).getTopCallerData().getIntervalXday()).getAvg()));
                scopedAccounting.setTopCallerGHNavgHourlyCalls(Double.valueOf(this.data.get(string).getTopCallerData().getCallerMap().get(string2).get(this.data.get(string).getTopCallerData().getIntervalXHour()).getAvg()));
                hashMap.put(GCUBEScope.getScope((String)string), scopedAccounting);
            }
            catch (Exception exception) {
                GCUBELocalProducer.logger.error((Object)"Error updating RI Profile", (Throwable)exception);
                throw exception;
            }
        }
        try {
            ((GCUBEServiceContext)this.getHandled()).getInstance().setAccounting(hashMap);
            StringWriter stringWriter = new StringWriter();
            ((GCUBEServiceContext)this.getHandled()).getInstance().store((Writer)stringWriter);
            GCUBELocalProducer.logger.debug((Object)stringWriter.toString());
        }
        catch (Exception exception) {
            GCUBELocalProducer.logger.error((Object)"Error updating Map on Profile", (Throwable)exception);
            throw exception;
        }
        ((GCUBEServiceContext)this.getHandled()).setStatus(GCUBEServiceContext.Status.UPDATED);
    }
}

