/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.util;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.gcube.common.accounting.node.util.Util;

public class DateInterval
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Calendar startDate = Calendar.getInstance();
    private Calendar endDate = Calendar.getInstance();
    private Long interval;

    public DateInterval(Long l) {
        this.interval = l;
        this.endDate = Calendar.getInstance();
        this.startDate.setTime(new Date(Calendar.getInstance().getTimeInMillis() - l));
    }

    public DateInterval(Calendar calendar, Calendar calendar2, Long l) {
        this.endDate = calendar2;
        this.startDate = calendar;
        this.interval = l;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long l) {
        this.interval = l;
    }

    public Boolean contains(Date date) {
        if (this.interval.compareTo(new Long(0L)) == 0) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.after(this.endDate) || calendar.before(this.startDate)) {
            return false;
        }
        return true;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public String getStartDateAsShortString() {
        return Util.format_day.format(this.startDate.getTime());
    }

    public String getStartDateAsString() {
        return Util.format.format(this.startDate.getTime());
    }

    public void setStartDate(Calendar calendar) {
        this.startDate = calendar;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public String getEndDateAsString() {
        return Util.format.format(this.endDate.getTime());
    }

    public String getEndDateAsShortString() {
        return Util.format_day.format(this.endDate.getTime());
    }

    public void setEndDate(Calendar calendar) {
        this.endDate = calendar;
    }
}

