/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.storage.ldap.mappers;

import java.util.List;
import org.gcube.keycloak.storage.ldap.mappers.UserAttributeTemplatedLDAPStorageMapper;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.LDAPConfigDecorator;

public class UserAttributeTemplatedLDAPStorageMapperFactory
extends AbstractLDAPStorageMapperFactory
implements LDAPConfigDecorator {
    public static final String PROVIDER_ID = "ua-templated-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties;

    static List<ProviderConfigProperty> getConfigProps(ComponentModel p) {
        String readOnly = "false";
        UserStorageProviderModel parent = new UserStorageProviderModel();
        if (p != null) {
            parent = new UserStorageProviderModel(p);
            LDAPConfig ldapConfig = new LDAPConfig(parent.getConfig());
            readOnly = ldapConfig.getEditMode() == UserStorageProvider.EditMode.WRITABLE ? "false" : "true";
        }
        ProviderConfigurationBuilder config = ProviderConfigurationBuilder.create().property().name("template.string").label("Template string").helpText("Template to be used to compute final value to be set in LDAP. You can user the ${VALUE} placeholder in the text and it will be replaced by the value read by the model property. (e.g. /home/${VALUE}").type("String").add().property().name("user.model.attribute").label("User Model Attribute").helpText("Name of the UserModel property or attribute you want to map the LDAP attribute into. For example 'firstName', 'lastName, 'email', 'street' etc.").type("String").add().property().name("ldap.attribute").label("LDAP Attribute").helpText("Name of mapped attribute on LDAP object. For example 'cn', 'sn, 'mail', 'street' etc.").type("String").add().property().name("read.only").label("Read Only").helpText("Read-only attribute is imported from LDAP to UserModel, but it's not saved back to LDAP when user is updated in Keycloak.").type("boolean").defaultValue((Object)readOnly).add();
        if (parent.isImportEnabled()) {
            config.property().name("always.read.value.from.ldap").label("Always Read Value From LDAP").helpText("If on, then during reading of the LDAP attribute value will always used instead of the value from Keycloak DB").type("boolean").defaultValue((Object)"false").add();
        }
        config.property().name("is.mandatory.in.ldap").label("Is Mandatory In LDAP").helpText("If true, attribute is mandatory in LDAP. Hence if there is no value in Keycloak DB, the empty value will be set to be propagated to LDAP").type("boolean").defaultValue((Object)"false").add();
        return config.build();
    }

    public String getHelpText() {
        return "Used to map single attribute from LDAP user to attribute of UserModel in Keycloak DB";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        this.checkMandatoryConfigAttribute("user.model.attribute", "User Model Attribute", config);
        this.checkMandatoryConfigAttribute("ldap.attribute", "LDAP Attribute", config);
    }

    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider) {
        return new UserAttributeTemplatedLDAPStorageMapper(mapperModel, federationProvider);
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return UserAttributeTemplatedLDAPStorageMapperFactory.getConfigProps(parent);
    }

    public void updateLDAPConfig(LDAPConfig ldapConfig, ComponentModel mapperModel) {
    }

    static {
        List<ProviderConfigProperty> props = UserAttributeTemplatedLDAPStorageMapperFactory.getConfigProps(null);
        configProperties = props;
    }
}

