/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.preprocessing.filters;

import java.util.List;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.Filter;
import org.gcube.informationsystem.registry.impl.preprocessing.filters.FilterExecutor;

public class RIFilterExecutor
extends FilterExecutor {
    private List<Filter> filters = null;
    private GCUBERunningInstance instance = null;

    protected RIFilterExecutor(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public boolean accept(GCUBEResource resource) throws FilterExecutor.InvalidFilterException {
        if (resource.getType().compareTo("RunningInstance") != 0) {
            throw new FilterExecutor.InvalidFilterException("Cannot apply " + this.getClass().getName() + " filter to " + resource.getType());
        }
        this.instance = (GCUBERunningInstance)resource;
        this.logger.trace((Object)("Applying N." + this.filters.size() + " filters to RI"));
        for (Filter filter : this.filters) {
            if (this._accept(filter)) continue;
            return false;
        }
        return true;
    }

    private boolean _accept(Filter filter) {
        if (filter.getTarget().compareToIgnoreCase("AccessPoint/RunningInstanceInterfaces/Endpoint") == 0 && filter.getOperation() == Filter.FILTEROPERATION.exclude_if_contains) {
            return !this.isExcludedIfContainsEPR(filter.getValue());
        }
        if (filter.getTarget().compareToIgnoreCase("AccessPoint/RunningInstanceInterfaces/Endpoint") == 0 && filter.getOperation() == Filter.FILTEROPERATION.exclude) {
            return !this.isExcludedEPR(filter.getValue());
        }
        return true;
    }

    private boolean isExcludedIfContainsEPR(String value) {
        for (Endpoint endpoint : this.instance.getAccessPoint().getRunningInstanceInterfaces().getEndpoint()) {
            this.logger.trace((Object)("Checking endpoint " + endpoint.getValue()));
            if (!endpoint.getValue().contains(value)) continue;
            this.logger.warn((Object)("Detected banned EPR " + value + " for RI " + this.instance.getID()));
            return true;
        }
        return false;
    }

    private boolean isExcludedEPR(String value) {
        for (Endpoint endpoint : this.instance.getAccessPoint().getRunningInstanceInterfaces().getEndpoint()) {
            this.logger.trace((Object)("Checking endpoint " + endpoint.getValue()));
            if (endpoint.getValue().compareToIgnoreCase(value) != 0) continue;
            this.logger.warn((Object)("Detected banned EPR " + value + " for RI " + this.instance.getID()));
            return true;
        }
        return false;
    }
}

