/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.local;

import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISLocalPublisher;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.local.LocalResourceHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryLookup;

public final class GCUBELocalPublisher
implements ISLocalPublisher {
    protected static final GCUBELog logger = new GCUBELog(GCUBELocalPublisher.class);
    private static GCUBELocalPublisher manager = new GCUBELocalPublisher();
    protected static GCUBEProducer<ISLocalPublisher.LocalProfileTopic, Object> eventProducer;

    public void subscribeLocalProfileEvents(ISLocalPublisher.LocalProfileConsumer consumer) throws GCUBEPublisherException {
        try {
            eventProducer.subscribe((GCUBEConsumer)consumer, (GCUBETopic[])ISLocalPublisher.LocalProfileTopic.values());
        }
        catch (Exception e) {
            logger.error((Object)"Unable to subscribe to local events ", (Throwable)e);
            throw new GCUBEPublisherException("Unable to subscribe to local events " + e.getMessage());
        }
    }

    public static GCUBELocalPublisher getManager() {
        return manager;
    }

    public void notifyResourceRemoved(String ID, String type, GCUBEScope scope) throws Exception {
        logger.trace((Object)("Removing resource " + ID + " via local event"));
        this.notify(ISLocalPublisher.LocalProfileTopic.REMOVED, new ISLocalPublisher.LocalProfileEvent(ID, type, scope));
    }

    public void notifyResourceRegistered(GCUBEResource resource, GCUBEScope scope) throws Exception {
        logger.trace((Object)("Updating resource " + resource.getID() + " via local event"));
        this.notify(ISLocalPublisher.LocalProfileTopic.REGISTERED, new ISLocalPublisher.LocalProfileEvent(resource, scope));
    }

    public void notifyResourceUpdated(GCUBEResource resource, GCUBEScope scope) throws Exception {
        logger.trace((Object)("Publishing resource " + resource.getID() + " via local event"));
        this.notify(ISLocalPublisher.LocalProfileTopic.UPDATED, new ISLocalPublisher.LocalProfileEvent(resource, scope));
    }

    public boolean isEnabled(String resourceType, GCUBEScope scope) {
        try {
            Set<ISRegistryInstance> availableInstances = ISRegistryInstanceGroup.getInstanceGroup().getRegistryInstancesForTypeAndScope(resourceType, scope);
            for (ISRegistryInstance instance : availableInstances) {
                if (!instance.getEndpoint().toString().contains(GHNContext.getContext().getHostnameAndPort())) continue;
                return true;
            }
        }
        catch (ISRegistryLookup.NoRegistryAvailableException e) {
            logger.error((Object)"Unable to detect if the local publishing is enabled or not", (Throwable)e);
        }
        return false;
    }

    private void notify(ISLocalPublisher.LocalProfileTopic topic, ISLocalPublisher.LocalProfileEvent event) throws Exception {
        new LocalResourceHandler(topic, event, eventProducer).execute();
    }

    static {
        try {
            eventProducer = new GCUBEProducer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

