/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.publisher.impl.local;

import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISLocalPublisher;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.publisher.impl.GCUBEPublisherException;
import org.gcube.common.informationsystem.publisher.impl.local.LocalResourceHandler;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstance;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryInstanceGroup;
import org.gcube.common.informationsystem.publisher.impl.registrations.resources.ISRegistryLookup;

public final class GCUBELocalPublisher
implements ISLocalPublisher {
    protected static final GCUBELog logger = new GCUBELog(GCUBELocalPublisher.class);
    private static GCUBELocalPublisher manager = new GCUBELocalPublisher();
    protected static GCUBEProducer<ISLocalPublisher.LocalProfileTopic, Object> eventProducer;

    public void subscribeLocalProfileEvents(ISLocalPublisher.LocalProfileConsumer localProfileConsumer) throws GCUBEPublisherException {
        try {
            eventProducer.subscribe((GCUBEConsumer)localProfileConsumer, (GCUBETopic[])ISLocalPublisher.LocalProfileTopic.values());
        }
        catch (Exception exception) {
            logger.error((Object)"Unable to subscribe to local events ", (Throwable)exception);
            throw new GCUBEPublisherException("Unable to subscribe to local events " + exception.getMessage());
        }
    }

    public static GCUBELocalPublisher getManager() {
        return manager;
    }

    public void notifyResourceRemoved(String string, String string2, GCUBEScope gCUBEScope) throws Exception {
        logger.trace((Object)("Removing resource " + string + " via local event"));
        this.notify(ISLocalPublisher.LocalProfileTopic.REMOVED, new ISLocalPublisher.LocalProfileEvent(string, string2, gCUBEScope));
    }

    public void notifyResourceRegistered(GCUBEResource gCUBEResource, GCUBEScope gCUBEScope) throws Exception {
        logger.trace((Object)("Updating resource " + gCUBEResource.getID() + " via local event"));
        this.notify(ISLocalPublisher.LocalProfileTopic.REGISTERED, new ISLocalPublisher.LocalProfileEvent(gCUBEResource, gCUBEScope));
    }

    public void notifyResourceUpdated(GCUBEResource gCUBEResource, GCUBEScope gCUBEScope) throws Exception {
        logger.trace((Object)("Publishing resource " + gCUBEResource.getID() + " via local event"));
        this.notify(ISLocalPublisher.LocalProfileTopic.UPDATED, new ISLocalPublisher.LocalProfileEvent(gCUBEResource, gCUBEScope));
    }

    public boolean isEnabled(String string, GCUBEScope gCUBEScope) {
        try {
            Set<ISRegistryInstance> set = ISRegistryInstanceGroup.getInstanceGroup().getRegistryInstancesForTypeAndScope(string, gCUBEScope);
            for (ISRegistryInstance iSRegistryInstance : set) {
                if (!iSRegistryInstance.getEndpoint().toString().contains(GHNContext.getContext().getHostnameAndPort())) continue;
                return true;
            }
        }
        catch (ISRegistryLookup.NoRegistryAvailableException noRegistryAvailableException) {
            logger.error((Object)"Unable to detect if the local publishing is enabled or not", (Throwable)noRegistryAvailableException);
        }
        return false;
    }

    private void notify(ISLocalPublisher.LocalProfileTopic localProfileTopic, ISLocalPublisher.LocalProfileEvent localProfileEvent) throws Exception {
        new LocalResourceHandler(localProfileTopic, localProfileEvent, eventProducer).execute();
    }

    static {
        try {
            eventProducer = new GCUBEProducer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

