/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.gcube.common.encryption.SymmetricKey;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.discovery.DiscoveredElementAction;
import org.gcube.informationsystem.discovery.Discovery;
import org.gcube.informationsystem.discovery.RegistrationProvider;
import org.gcube.informationsystem.model.reference.properties.Metadata;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.dbinitialization.CreateTypeAction;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.contexts.ContextEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.queries.templates.QueryTemplateEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.types.TypeEnvironment;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.resourceregistry.types.properties.PropertyTypeDefinitionManagement;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.FacetType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.types.reference.relations.ConsistsOfType;
import org.gcube.informationsystem.types.reference.relations.IsRelatedToType;
import org.gcube.informationsystem.types.reference.relations.RelationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseEnvironment {
    private static Logger logger = LoggerFactory.getLogger(DatabaseEnvironment.class);
    protected static final String PROPERTY_FILENAME = "config.properties";
    private static final String HOST_VARNAME = "HOST";
    private static final String REMOTE_PROTOCOL;
    private static final String REMOTE_PROTOCOL_VARNAME = "REMOTE_PROTOCOL";
    private static final String DB;
    private static final String DB_VARNAME = "DB";
    private static final String ROOT_USERNAME;
    private static final String ROOT_USERNAME_VARNAME = "ROOT_USERNAME";
    private static final String ROOT_PASSWORD;
    private static final String ROOT_PASSWORD_VARNAME = "ROOT_PASSWORD";
    public static final String DEFAULT_ADMIN_ROLE = "admin";
    private static final String CHANGED_ADMIN_USERNAME;
    private static final String CHANGED_ADMIN_USERNAME_VARNAME = "CHANGED_ADMIN_USERNAME";
    private static final String CHANGED_ADMIN_PASSWORD;
    private static final String CHANGED_ADMIN_PASSWORD_VARNAME = "CHANGED_ADMIN_PASSWORD";
    private static final String DEFAULT_CREATED_WRITER_USER_PASSWORD;
    private static final String DEFAULT_CREATED_WRITER_USER_PASSWORD_VARNAME = "DEFAULT_CREATED_WRITER_USER_PASSWORD";
    private static final String DEFAULT_CREATED_READER_USER_PASSWORD;
    private static final String DEFAULT_CREATED_READER_USER_PASSWORD_VARNAME = "DEFAULT_CREATED_READER_USER_PASSWORD";
    public static final Map<Environment.PermissionMode, String> DEFAULT_PASSWORDS;
    private static final String HOSTS;
    private static final String SERVER_URI;
    public static final String DB_URI;
    public static final OStorageRemote.CONNECTION_STRATEGY CONNECTION_STRATEGY_PARAMETER;
    protected static final String DB_KEY_FILENAME_VARNAME = "DB_KEY_FILENAME";
    protected static final String DB_KEY_ALGORITHM_VARNAME = "DB_KEY_ALGORITHM";
    private static final Key KEY;
    public static final String VERTEX_CLASS_NAME = "V";
    public static final String EDGE_CLASS_NAME = "E";

    protected static Key initDbKey(Properties properties) {
        try {
            logger.trace("Going to get properties required to load DB key");
            String keyFileName = properties.getProperty("DB_KEY_FILENAME");
            String keyAlgorithm = properties.getProperty("DB_KEY_ALGORITHM");
            logger.debug("Trying to load DB key from file with name {} created for algorithm {}", (Object)keyFileName, (Object)keyAlgorithm);
            URL keyFileURL = DatabaseEnvironment.class.getClassLoader().getResource(keyFileName);
            File keyFile = new File(keyFileURL.toURI());
            logger.debug("Trying to load DB key from file {} created for algorithm {}", (Object)keyFile.getAbsolutePath(), (Object)keyAlgorithm);
            Key key = SymmetricKey.loadKeyFromFile((File)keyFile, (String)keyAlgorithm);
            logger.info("DB Key has been properly initialized");
            return key;
        }
        catch (Throwable e) {
            logger.error("Error loading DB Key", e);
            throw new RuntimeException("Error loading DB Key. Unable to continue", e);
        }
    }

    protected static void setDateTimeFormat(ODatabaseDocument oDatabaseDocument) {
        oDatabaseDocument.set(ODatabase.ATTRIBUTES.DATETIMEFORMAT, (Object)"yyyy-MM-dd HH:mm:ss.SSS Z");
    }

    @Deprecated
    protected static void setRecordLevelSecurity(OMetadata oMetadata) {
        logger.trace("Setting Record-level Security (see https://orientdb.org/docs/3.2.x/security/Database-Security.html#record-level-security-deprecated-in-v-31)");
        OSchema oSchema = oMetadata.getSchema();
        OClass oRestricted = oSchema.getClass("ORestricted");
        OClass v = oSchema.getClass("V");
        v.addSuperClass(oRestricted);
        OClass e = oSchema.getClass("E");
        e.addSuperClass(oRestricted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initGraphDB() throws Exception {
        OLogManager.instance().setWarnEnabled(false);
        OLogManager.instance().setErrorEnabled(false);
        OLogManager.instance().setInfoEnabled(false);
        OLogManager.instance().setDebugEnabled(false);
        logger.info("Connecting as {} to {}", (Object)ROOT_USERNAME, (Object)DB_URI);
        try (OrientDB orientDB = new OrientDB(SERVER_URI, ROOT_USERNAME, ROOT_PASSWORD, OrientDBConfig.defaultConfig());){
            if (!orientDB.exists(DB)) {
                logger.info("The database {} does not exist. Going to create it.", (Object)DB_URI);
                orientDB.create(DB, ODatabaseType.PLOCAL);
                ODatabasePool pool = new ODatabasePool(orientDB, DB, ROOT_USERNAME, ROOT_PASSWORD);
                ODatabaseSession oDatabaseSession = pool.acquire();
                DatabaseEnvironment.setDateTimeFormat((ODatabaseDocument)oDatabaseSession);
                OMetadata oMetadata = oDatabaseSession.getMetadata();
                OSecurity oSecurity = oMetadata.getSecurity();
                logger.trace("Creating new admin named '{}'", (Object)CHANGED_ADMIN_USERNAME);
                ORole adminRole = oSecurity.getRole("admin");
                OUser newAdminUser = oSecurity.createUser(CHANGED_ADMIN_USERNAME, CHANGED_ADMIN_PASSWORD, new ORole[]{adminRole});
                newAdminUser.save();
                DatabaseEnvironment.changeDefaultAdminPassword((OSecurity)oSecurity);
                DatabaseEnvironment.setRecordLevelSecurity((OMetadata)oMetadata);
                oDatabaseSession.commit();
                oDatabaseSession.close();
                pool.close();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static Key getDatabaseKey() {
        return KEY;
    }

    @Deprecated
    public static void changeDefaultAdminPassword(OSecurity oSecurity) {
        for (Environment.PermissionMode permissionMode : DEFAULT_PASSWORDS.keySet()) {
            try {
                logger.trace("Going to update password for user {}", (Object)permissionMode.toString());
                OUser oUser = oSecurity.getUser(permissionMode.toString());
                oUser.setPassword((String)DEFAULT_PASSWORDS.get(permissionMode));
                oUser.save();
                logger.trace("Updated password for user {}", (Object)permissionMode.toString());
            }
            catch (Exception e) {
                logger.trace("Unable to update password for user {}. {}", (Object)permissionMode.toString(), (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        }
        try {
            logger.trace("Removing 'admin' user");
            oSecurity.dropUser("admin");
        }
        catch (Exception e) {
            logger.info("Unable to delete admin user. {}", (Object)e.getMessage());
        }
    }

    static {
        CONNECTION_STRATEGY_PARAMETER = OStorageRemote.CONNECTION_STRATEGY.ROUND_ROBIN_CONNECT;
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = DatabaseEnvironment.class.getClassLoader().getResourceAsStream("config.properties");
            properties.load(input);
            HOSTS = properties.getProperty("HOST");
            REMOTE_PROTOCOL = properties.getProperty("REMOTE_PROTOCOL");
            DB = properties.getProperty("DB");
            SERVER_URI = REMOTE_PROTOCOL + HOSTS;
            DB_URI = SERVER_URI + "/" + DB;
            ROOT_USERNAME = properties.getProperty("ROOT_USERNAME");
            ROOT_PASSWORD = properties.getProperty("ROOT_PASSWORD");
            String changedAdminUsername = null;
            try {
                changedAdminUsername = properties.getProperty("CHANGED_ADMIN_USERNAME");
                if (changedAdminUsername == null) {
                    changedAdminUsername = DB;
                }
            }
            catch (Exception e) {
                changedAdminUsername = DB;
            }
            CHANGED_ADMIN_USERNAME = changedAdminUsername;
            CHANGED_ADMIN_PASSWORD = properties.getProperty("CHANGED_ADMIN_PASSWORD");
            DEFAULT_CREATED_WRITER_USER_PASSWORD = properties.getProperty("DEFAULT_CREATED_WRITER_USER_PASSWORD");
            DEFAULT_CREATED_READER_USER_PASSWORD = properties.getProperty("DEFAULT_CREATED_READER_USER_PASSWORD");
            DEFAULT_PASSWORDS = new HashMap();
            DEFAULT_PASSWORDS.put(Environment.PermissionMode.WRITER, DEFAULT_CREATED_WRITER_USER_PASSWORD);
            DEFAULT_PASSWORDS.put(Environment.PermissionMode.READER, DEFAULT_CREATED_READER_USER_PASSWORD);
        }
        catch (Throwable e) {
            logger.error("Unable to load properties from {}", (Object)"config.properties");
            throw new RuntimeException("Unable to load properties", e);
        }
        try {
            boolean created = DatabaseEnvironment.initGraphDB();
            if (created) {
                AccessType[] veryBaseTypes;
                AccessType[] accessTypes;
                ODatabasePool pool = new ODatabasePool(DB_URI, CHANGED_ADMIN_USERNAME, CHANGED_ADMIN_PASSWORD);
                ODatabaseSession oDatabaseDocument = pool.acquire();
                AdminEnvironment.getInstance().create((ODatabaseDocument)oDatabaseDocument);
                oDatabaseDocument.commit();
                oDatabaseDocument.close();
                pool.close();
                QueryTemplateEnvironment.getInstance().create();
                TypeEnvironment.getInstance().create();
                ContextEnvironment.getInstance().create();
                ArrayList<Class> definitionToBeCreated = new ArrayList<Class>();
                definitionToBeCreated.add(PropertyElement.class);
                definitionToBeCreated.add(Property.class);
                definitionToBeCreated.add(Metadata.class);
                definitionToBeCreated.add(PropertyDefinition.class);
                definitionToBeCreated.add(PropertyType.class);
                definitionToBeCreated.add(LinkedEntity.class);
                definitionToBeCreated.add(EntityElement.class);
                definitionToBeCreated.add(EntityType.class);
                definitionToBeCreated.add(FacetType.class);
                definitionToBeCreated.add(ResourceType.class);
                definitionToBeCreated.add(RelationElement.class);
                definitionToBeCreated.add(RelationType.class);
                definitionToBeCreated.add(IsRelatedToType.class);
                definitionToBeCreated.add(ConsistsOfType.class);
                for (Class clazz : definitionToBeCreated) {
                    TypeManagement typeManagement = new TypeManagement();
                    typeManagement.setTypeAndTypeName(clazz);
                    if (clazz.equals(Property.class) || clazz.equals(Metadata.class)) {
                        typeManagement.setSkipTypeDefinitionCreation(true);
                    }
                    try {
                        typeManagement.create();
                    }
                    catch (SchemaAlreadyPresentException sape) {
                        logger.warn("{} already exists. It will be ignored", (Object)typeManagement.getTypeName());
                    }
                    catch (Exception ex) {
                        logger.error("Error creating schema for {} {}: {}", new Object[]{typeManagement.getType().getAccessType(), typeManagement.getTypeName(), ex.getMessage()});
                        throw ex;
                    }
                }
                ArrayList<Class> schemaToBeCreated = new ArrayList<Class>();
                schemaToBeCreated.add(Property.class);
                schemaToBeCreated.add(Metadata.class);
                for (Class clazz : schemaToBeCreated) {
                    PropertyTypeDefinitionManagement erManagement = new PropertyTypeDefinitionManagement();
                    erManagement.setJson(TypeMapper.serializeType((Class)clazz));
                    erManagement.create();
                }
                ArrayList<Package> arrayList = new ArrayList<Package>();
                Class<Type> typeClz = Type.class;
                arrayList.add(typeClz.getPackage());
                for (AccessType accessType : accessTypes = AccessType.values()) {
                    Class clazz = accessType.getTypeClass();
                    arrayList.add(clazz.getPackage());
                }
                ServiceLoader<RegistrationProvider> regsitrationProviders = ServiceLoader.load(RegistrationProvider.class);
                for (RegistrationProvider registrationProvider : regsitrationProviders) {
                    arrayList.addAll(registrationProvider.getPackagesToRegister());
                }
                for (AccessType accessType : veryBaseTypes = new AccessType[]{AccessType.PROPERTY_ELEMENT, AccessType.ENTITY_ELEMENT, AccessType.RELATION_ELEMENT}) {
                    Discovery discovery = new Discovery(accessType.getTypeClass());
                    discovery.addPackages(arrayList);
                    CreateTypeAction createTypeAction = new CreateTypeAction();
                    discovery.addDiscoveredElementActions((DiscoveredElementAction)createTypeAction);
                    discovery.discover();
                }
            }
            logger.info("Database Connection has been properly initialized");
        }
        catch (Throwable e) {
            logger.error("Error initializing database connection", e);
            throw new RuntimeException("Error initializing database connection", e);
        }
        KEY = DatabaseEnvironment.initDbKey((Properties)properties);
        ServerContextCache.getInstance();
    }
}

