/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.relations;

import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.JsonQueryERElement;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryFacet;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryRelation;

public class JsonQueryConsistsOf
extends JsonQueryRelation {
    protected String requestedResourceType;

    public JsonQueryConsistsOf(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.CONSISTS_OF);
        this.direction = Direction.IN;
    }

    public String getRequestedResourceType() {
        return this.requestedResourceType;
    }

    public void setRequestedResourceType(String requestedResourceType) {
        this.requestedResourceType = requestedResourceType;
    }

    protected StringBuffer traverseBackToCallerResource(StringBuffer stringBuffer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TRAVERSE ");
        buffer.append(this.direction.opposite().name().toLowerCase());
        buffer.append("V(\"");
        buffer.append(this.requestedResourceType);
        buffer.append("\") FROM ( ");
        buffer.append(stringBuffer);
        buffer.append(")");
        return buffer;
    }

    public StringBuffer createSelect(StringBuffer stringBuffer, boolean wrapInnerQuery) throws SchemaException, ResourceRegistryException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FROM ");
        if (wrapInnerQuery) {
            buffer.append("( ");
            buffer.append(stringBuffer);
            buffer.append(")");
        } else {
            buffer.append(this.type);
        }
        if (this.entryPoint || this.size > 1) {
            buffer.append(" WHERE ");
        }
        if (this.size > 1) {
            buffer.append(this.addConstraints(this.jsonNode, null, null));
            if (this.entryPoint) {
                buffer.append(" AND ");
            }
        }
        if (this.entryPoint) {
            buffer.append("@class");
            buffer.append(" INSTANCEOF \"");
            buffer.append(this.type);
            buffer.append("\"");
        }
        return buffer;
    }

    public StringBuffer createTraversalQuery(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        StringBuffer buffer;
        boolean wrapInnerQuery = false;
        if (this.traverseBack) {
            buffer = new StringBuffer();
            buffer.append("TRAVERSE ");
            buffer.append(this.direction.opposite().name().toLowerCase());
            buffer.append("E(\"");
            buffer.append(this.type);
            buffer.append("\") FROM ( ");
            buffer.append(stringBuffer);
            buffer.append(")");
            stringBuffer = buffer;
            wrapInnerQuery = true;
        }
        if (this.jsonNode.has("target")) {
            --this.size;
            JsonNode facetJsonNode = this.jsonNode.get("target");
            JsonQueryFacet jsonQueryFacet = new JsonQueryFacet(facetJsonNode);
            jsonQueryFacet.setTraverseBack(this.traverseBack || wrapInnerQuery);
            stringBuffer = jsonQueryFacet.createTraversalQuery(stringBuffer);
            wrapInnerQuery = true;
        }
        if (this.jsonNode.has("source")) {
            --this.size;
            JsonNode resourceJsonNode = this.jsonNode.get("source");
            JsonQueryResource jsonQueryResource = new JsonQueryResource(resourceJsonNode);
            jsonQueryResource.setTraverseBack(this.traverseBack || wrapInnerQuery);
            stringBuffer = jsonQueryResource.createTraversalQuery(stringBuffer);
            wrapInnerQuery = true;
        }
        if (wrapInnerQuery) {
            buffer = new StringBuffer();
            buffer.append("TRAVERSE ");
            buffer.append(this.direction.name().toLowerCase());
            buffer.append("E(\"");
            buffer.append(this.type);
            buffer.append("\") FROM ( ");
            buffer.append(stringBuffer);
            buffer.append(")");
            stringBuffer = buffer;
        }
        if (this.entryPoint || this.size > 1) {
            stringBuffer = this.createSelect(stringBuffer, wrapInnerQuery);
        }
        if (!this.entryPoint && this.requestedResourceType != null) {
            stringBuffer = this.traverseBackToCallerResource(stringBuffer);
        }
        return stringBuffer;
    }

    protected StringBuffer getSpecificMatchQuery(List<JsonQueryERElement> childrenBreadcrumb) throws SchemaException, ResourceRegistryException {
        Direction direction;
        int childrenPosition = 0;
        boolean traverseBack = this.traverseBack;
        StringBuffer newBuffer = new StringBuffer();
        if (this.jsonNode.has("target")) {
            --this.size;
            JsonNode facetJsonNode = this.jsonNode.get("target");
            JsonQueryFacet jsonQueryFacet = new JsonQueryFacet(facetJsonNode);
            jsonQueryFacet.setBreadcrumb(childrenBreadcrumb);
            jsonQueryFacet.setPosition(childrenPosition++);
            jsonQueryFacet.setTraverseBack(true);
            direction = Direction.IN;
            jsonQueryFacet.setDirection(direction);
            newBuffer = jsonQueryFacet.createMatchQuery(newBuffer);
            newBuffer.append("\n\t");
            newBuffer.append(".");
            newBuffer.append(direction.name().toLowerCase());
            newBuffer.append("E('");
            newBuffer.append(this.type);
            newBuffer.append("') ");
            newBuffer.append(" { where: ($matched.");
            newBuffer.append(this.getAlias(true));
            newBuffer.append(" == $currentMatch)}");
            traverseBack = false;
        }
        if (this.jsonNode.has("source")) {
            --this.size;
            JsonNode resourceJsonNode = this.jsonNode.get("source");
            JsonQueryResource jsonQueryResource = new JsonQueryResource(resourceJsonNode);
            jsonQueryResource.setBreadcrumb(childrenBreadcrumb);
            jsonQueryResource.setPosition(childrenPosition++);
            jsonQueryResource.setTraverseBack(true);
            direction = Direction.OUT;
            jsonQueryResource.setDirection(direction);
            newBuffer = jsonQueryResource.createMatchQuery(newBuffer);
            newBuffer.append("\n\t");
            newBuffer.append(".");
            newBuffer.append(direction.name().toLowerCase());
            newBuffer.append("E('");
            newBuffer.append(this.type);
            newBuffer.append("') ");
            newBuffer.append(" { where: ($matched.");
            newBuffer.append(this.getAlias(true));
            newBuffer.append(" == $currentMatch)}");
            traverseBack = false;
        }
        StringBuffer buffer = new StringBuffer();
        if (!this.entryPoint) {
            buffer.append("\n\t");
            buffer.append(".");
            buffer.append(this.direction.name().toLowerCase());
            buffer.append("E('");
            buffer.append(this.type);
            buffer.append("')");
            this.alias = this.getAlias(true);
            StringBuffer sb = null;
            if (this.size > 0) {
                sb = this.addConstraints(this.jsonNode, null, null);
            }
            buffer.append(" {");
            buffer.append(" as: ");
            buffer.append(this.alias);
            if (sb != null && sb.length() > 0) {
                buffer.append(", where: ");
                buffer.append("(");
            }
            if (sb != null && sb.length() > 0) {
                buffer.append(sb);
                buffer.append(")");
            }
            buffer.append("}");
        }
        buffer.append(newBuffer);
        if (traverseBack) {
            buffer.append("\n\t");
            buffer.append(".");
            buffer.append(this.direction.opposite().name().toLowerCase());
            buffer.append("E('");
            buffer.append(this.type);
            buffer.append("') ");
            buffer.append(" { where: ($matched.");
            buffer.append(this.alias);
            buffer.append(" == $currentMatch)}");
        }
        return buffer;
    }
}

