/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.environments;

import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.utils.UUIDManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class HierarchicalEnvironment
extends Environment {
    private static Logger logger = LoggerFactory.getLogger(HierarchicalEnvironment.class);
    public static final String H = "H";
    protected final boolean hierarchicalMode;
    protected final Map<Environment.PermissionMode, ODatabasePool> hierarchicPoolMap = new HashMap();
    protected HierarchicalEnvironment parentEnvironment;
    protected Set<HierarchicalEnvironment> children;

    public HierarchicalEnvironment(UUID uuid) throws ResourceRegistryException {
        super(uuid);
        boolean hierarchicalModeRequested = ((ServerRequestInfo)RequestUtility.getRequestInfo().get()).isHierarchicalMode();
        logger.trace("HierarchicalMode {}requested", (Object)(hierarchicalModeRequested ? "" : "not "));
        boolean hierarchicalAllowed = this.isUserAllowed((Collection)Environment.getAllOperationsAllowedRoles());
        logger.trace("{} is {}allowed to request the HierarchicalMode", (Object)ContextUtility.getCurrentUserUsername(), (Object)(hierarchicalAllowed ? "" : "not "));
        if (hierarchicalModeRequested && !hierarchicalAllowed) {
            StringBuffer sb = new StringBuffer();
            sb.append("The user ");
            sb.append(ContextUtility.getCurrentUserUsername());
            sb.append(" requested hierarchical mode but he/she does not have one of the following roles ");
            sb.append(allOperationAllowedRoles.toString());
            sb.append(". Instead of complaining, the request will be elaborated not in hierarchical mode.");
            logger.warn(sb.toString());
        }
        this.hierarchicalMode = hierarchicalAllowed && hierarchicalModeRequested;
        this.children = new HashSet();
    }

    protected boolean isHierarchicalMode() {
        return this.hierarchicalMode;
    }

    public void setParentEnvironment(HierarchicalEnvironment parentEnvironment) {
        if (this.parentEnvironment != null) {
            this.parentEnvironment.getChildren().remove(this);
        }
        this.parentEnvironment = parentEnvironment;
        if (parentEnvironment != null) {
            this.parentEnvironment.addChild(this);
        }
    }

    public HierarchicalEnvironment getParentEnvironment() {
        return this.parentEnvironment;
    }

    private void addChild(HierarchicalEnvironment child) {
        this.children.add(child);
    }

    public Set<HierarchicalEnvironment> getChildren() {
        return this.children;
    }

    private Set<HierarchicalEnvironment> getAllChildren() {
        HashSet<HierarchicalEnvironment> allChildren = new HashSet<HierarchicalEnvironment>();
        allChildren.add(this);
        for (HierarchicalEnvironment hierarchicalEnvironment : this.getChildren()) {
            allChildren.addAll(hierarchicalEnvironment.getAllChildren());
        }
        return allChildren;
    }

    private Set<HierarchicalEnvironment> getAllParents() {
        HashSet<HierarchicalEnvironment> allParents = new HashSet<HierarchicalEnvironment>();
        for (HierarchicalEnvironment parent = this.getParentEnvironment(); parent != null; parent = parent.getParentEnvironment()) {
            allParents.add(parent);
        }
        return allParents;
    }

    public void changeParentEnvironment(HierarchicalEnvironment newParentEnvironment, ODatabaseDocument orientGraph) throws ResourceRegistryException {
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        Set allChildren = this.getAllChildren();
        Set oldParents = this.getAllParents();
        Set newParents = new HashSet();
        if (newParentEnvironment != null) {
            newParents = newParentEnvironment.getAllParents();
        }
        oldParents.removeAll(newParents);
        this.removeChildrenHRolesFromParents(oSecurity, oldParents, allChildren);
        this.setParentEnvironment(newParentEnvironment);
        if (newParentEnvironment != null) {
            for (Environment.PermissionMode permissionMode : Environment.PermissionMode.values()) {
                ArrayList<ORole> roles = new ArrayList<ORole>();
                for (HierarchicalEnvironment child : allChildren) {
                    String roleName = child.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.ROLE, true);
                    ORole role = oSecurity.getRole(roleName);
                    roles.add(role);
                }
                newParentEnvironment.addHierarchicalRoleToParent(oSecurity, permissionMode, roles.toArray(new ORole[allChildren.size()]));
            }
        }
    }

    protected synchronized ODatabasePool getPool(Environment.PermissionMode permissionMode, boolean recreate) {
        Map pools;
        ODatabasePool pool = null;
        Boolean h = this.hierarchicalMode || ((ServerRequestInfo)RequestUtility.getRequestInfo().get()).isHierarchicalMode();
        Map map = pools = h != false ? this.hierarchicPoolMap : this.poolMap;
        if (recreate && (pool = (ODatabasePool)pools.get(permissionMode)) != null) {
            pool.close();
            pools.remove(permissionMode);
        }
        if ((pool = (ODatabasePool)pools.get(permissionMode)) == null) {
            String username = this.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.USER, h.booleanValue());
            String password = (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode);
            pool = new ODatabasePool(DatabaseEnvironment.DB_URI, username, password);
            pools.put(permissionMode, pool);
        }
        return pool;
    }

    public static String getRoleOrUserName(Environment.PermissionMode permissionMode, Environment.SecurityType securityType) {
        return HierarchicalEnvironment.getRoleOrUserName((Environment.PermissionMode)permissionMode, (Environment.SecurityType)securityType, (boolean)false);
    }

    public static String getRoleOrUserName(Environment.PermissionMode permissionMode, Environment.SecurityType securityType, boolean hierarchic) {
        StringBuilder stringBuilder = new StringBuilder();
        if (hierarchic) {
            stringBuilder.append("H");
        }
        stringBuilder.append(permissionMode);
        stringBuilder.append(securityType);
        return stringBuilder.toString();
    }

    public String getSecurityRoleOrUserName(Environment.PermissionMode permissionMode, Environment.SecurityType securityType, boolean hierarchic) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HierarchicalEnvironment.getRoleOrUserName((Environment.PermissionMode)permissionMode, (Environment.SecurityType)securityType, (boolean)hierarchic));
        stringBuilder.append("_");
        stringBuilder.append(this.environmentUUID.toString());
        return stringBuilder.toString();
    }

    private OSecurity getOSecurity(ODatabaseDocument oDatabaseDocument) {
        return oDatabaseDocument.getMetadata().getSecurity();
    }

    public static Set<String> getContexts(OElement element) {
        HashSet<String> contexts = new HashSet<String>();
        ORecordLazySet oRecordLazySet = (ORecordLazySet)element.getProperty("_allow");
        for (OIdentifiable oIdentifiable : oRecordLazySet) {
            String[] list;
            ODocument oDocument = (ODocument)oIdentifiable;
            String name = (String)oDocument.getProperty("name");
            if (!name.startsWith(HierarchicalEnvironment.getRoleOrUserName((Environment.PermissionMode)Environment.PermissionMode.WRITER, (Environment.SecurityType)Environment.SecurityType.ROLE)) && !name.startsWith(HierarchicalEnvironment.getRoleOrUserName((Environment.PermissionMode)Environment.PermissionMode.READER, (Environment.SecurityType)Environment.SecurityType.ROLE)) || (list = name.split("_")).length != 2) continue;
            String contextUUID = list[1];
            if (UUIDManager.getInstance().isReservedUUID(contextUUID)) continue;
            contexts.add(contextUUID);
        }
        return contexts;
    }

    protected void allow(OSecurity oSecurity, ODocument oDocument, boolean hierarchic) {
        String writerRoleName = this.getSecurityRoleOrUserName(Environment.PermissionMode.WRITER, Environment.SecurityType.ROLE, hierarchic);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(Environment.PermissionMode.READER, Environment.SecurityType.ROLE, hierarchic);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    public void addElement(OElement element, ODatabaseDocument oDatabaseDocument) {
        ODocument oDocument = (ODocument)element.getRecord();
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.allow(oSecurity, oDocument, false);
        this.allow(oSecurity, oDocument, true);
        oDocument.save();
        element.save();
    }

    protected void deny(OSecurity oSecurity, ODocument oDocument, boolean hierarchical) {
        String writerUserName = this.getSecurityRoleOrUserName(Environment.PermissionMode.WRITER, Environment.SecurityType.USER, hierarchical);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_ALL, writerUserName);
        String readerUserName = this.getSecurityRoleOrUserName(Environment.PermissionMode.WRITER, Environment.SecurityType.USER, hierarchical);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_READ, readerUserName);
        String writerRoleName = this.getSecurityRoleOrUserName(Environment.PermissionMode.WRITER, Environment.SecurityType.ROLE, hierarchical);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(Environment.PermissionMode.READER, Environment.SecurityType.ROLE, hierarchical);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    public void removeElement(OElement element, ODatabaseDocument oDatabaseDocument) {
        ODocument oDocument = (ODocument)element.getRecord();
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.deny(oSecurity, oDocument, false);
        this.deny(oSecurity, oDocument, true);
        oDocument.save();
        element.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowed(ORole role, ODocument oDocument) {
        ServerRequestInfo sri = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        Boolean hm = sri.isHierarchicalMode();
        sri.setHierarchicalMode(false);
        try {
            boolean bl = super.allowed(role, oDocument);
            return bl;
        }
        finally {
            sri.setHierarchicalMode(hm.booleanValue());
        }
    }

    protected void addHierarchicalRoleToParent(OSecurity oSecurity, Environment.PermissionMode permissionMode, ORole ... roles) {
        String userName = this.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.USER, true);
        OUser user = oSecurity.getUser(userName);
        for (ORole role : roles) {
            user.addRole((OSecurityRole)role);
        }
        user.save();
        if (this.getParentEnvironment() != null) {
            this.getParentEnvironment().addHierarchicalRoleToParent(oSecurity, permissionMode, roles);
        }
    }

    protected void createRolesAndUsers(OSecurity oSecurity) {
        boolean[] booleanArray;
        for (boolean hierarchical : booleanArray = new boolean[]{false, true}) {
            for (Environment.PermissionMode permissionMode : Environment.PermissionMode.values()) {
                ORole superRole = this.getSuperRole(oSecurity, permissionMode);
                String roleName = this.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.ROLE, hierarchical);
                ORole role = oSecurity.createRole(roleName, superRole, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
                this.addExtraRules(role, permissionMode);
                role.save();
                logger.trace("{} created", (Object)role);
                if (hierarchical && this.getParentEnvironment() != null) {
                    this.getParentEnvironment().addHierarchicalRoleToParent(oSecurity, permissionMode, new ORole[]{role});
                }
                String userName = this.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.USER, hierarchical);
                OUser user = oSecurity.createUser(userName, (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode), new ORole[]{role});
                user.save();
                logger.trace("{} created", (Object)user);
            }
        }
    }

    protected void removeChildrenHRolesFromParents(OSecurity oSecurity) {
        Set parents = this.getAllParents();
        Set allChildren = this.getAllChildren();
        this.removeChildrenHRolesFromParents(oSecurity, parents, allChildren);
    }

    protected void removeChildrenHRolesFromParents(OSecurity oSecurity, Set<HierarchicalEnvironment> parents, Set<HierarchicalEnvironment> children) {
        for (HierarchicalEnvironment parent : parents) {
            parent.removeChildrenHRolesFromMyHUsers(oSecurity, children);
        }
    }

    protected void removeChildrenHRolesFromMyHUsers(OSecurity oSecurity, Set<HierarchicalEnvironment> children) {
        for (Environment.PermissionMode permissionMode : Environment.PermissionMode.values()) {
            String userName = this.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.USER, true);
            OUser user = oSecurity.getUser(userName);
            for (HierarchicalEnvironment child : children) {
                String roleName = child.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.ROLE, true);
                logger.debug("Going to remove {} from {}", (Object)roleName, (Object)userName);
                boolean removed = user.removeRole(roleName);
                logger.trace("{} {} removed from {}", new Object[]{roleName, removed ? "successfully" : "NOT", userName});
            }
            user.save();
        }
    }

    protected void removeHierarchicRoleFromMyHUser(OSecurity oSecurity, Environment.PermissionMode permissionMode, String roleName) {
        String userName = this.getSecurityRoleOrUserName(permissionMode, Environment.SecurityType.USER, true);
        OUser user = oSecurity.getUser(userName);
        logger.debug("Going to remove {} from {}", (Object)roleName, (Object)userName);
        boolean removed = user.removeRole(roleName);
        logger.trace("{} {} removed from {}", new Object[]{roleName, removed ? "successfully" : "NOT", userName});
        user.save();
    }

    protected void deleteRolesAndUsers(OSecurity oSecurity) {
        boolean[] booleanArray;
        for (boolean hierarchic : booleanArray = new boolean[]{false, true}) {
            if (hierarchic) {
                this.removeChildrenHRolesFromParents(oSecurity);
            }
            for (Environment.PermissionMode permissionMode : Environment.PermissionMode.values()) {
                for (Environment.SecurityType securityType : Environment.SecurityType.values()) {
                    String name = this.getSecurityRoleOrUserName(permissionMode, securityType, hierarchic);
                    this.drop(oSecurity, name, securityType);
                }
            }
        }
    }
}

