/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import jakarta.ws.rs.InternalServerErrorException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.reference.properties.Metadata;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextCache
extends ContextCache {
    private static Logger logger = LoggerFactory.getLogger(ServerContextCache.class);
    protected List<Context> contextsMetaPrivacy;
    protected Map<UUID, Context> uuidToContextMetaPrivacy;
    protected List<Context> contextsBasicInfo;
    protected Map<UUID, Context> uuidToContextBasicInfo;
    protected boolean includeMeta;
    protected static ServerContextCache singleton;

    public static synchronized ServerContextCache getInstance() {
        if (singleton == null) {
            singleton = new ServerContextCache();
        }
        return singleton;
    }

    public void cleanCache() {
        this.cleanCache(Calendar.getInstance());
    }

    protected void cleanCache(Calendar now) {
        super.cleanCache(now);
        this.contextsMetaPrivacy = new ArrayList();
        this.uuidToContextMetaPrivacy = new LinkedHashMap();
        this.contextsBasicInfo = new ArrayList();
        this.uuidToContextBasicInfo = new LinkedHashMap();
    }

    public ServerContextCache() {
        Calendar now = Calendar.getInstance();
        this.cleanCache(now);
        this.initContextCacheRenewal();
    }

    public boolean isIncludeMeta() {
        return this.includeMeta;
    }

    public void setIncludeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
    }

    public void initContextCacheRenewal() {
        1 contextCacheRenewal = new /* Unavailable Anonymous Inner Class!! */;
        this.setContextCacheRenewal((ContextCacheRenewal)contextCacheRenewal);
    }

    public synchronized List<Context> getContexts() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        if (requestInfo != null && !requestInfo.includeMeta()) {
            return this.contextsBasicInfo;
        }
        ContextManagement contextManagement = new ContextManagement();
        if (contextManagement.isUserAllowedToGetPrivacyMeta()) {
            return this.contexts;
        }
        return this.contextsMetaPrivacy;
    }

    public synchronized List<Context> getFullInfoContexts() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return this.contexts;
    }

    public synchronized Context getFullInfoContextByUUID(UUID uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        return (Context)this.uuidToContext.get(uuid);
    }

    public synchronized Context getContextByUUID(UUID uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        if (requestInfo.getUriInfo() != null && !requestInfo.includeMeta()) {
            return (Context)this.uuidToContextBasicInfo.get(uuid);
        }
        ContextManagement contextManagement = new ContextManagement();
        if (contextManagement.isUserAllowedToGetPrivacyMeta()) {
            return (Context)this.uuidToContext.get(uuid);
        }
        return (Context)this.uuidToContextMetaPrivacy.get(uuid);
    }

    public synchronized Context getContextByUUIDFullInfo(UUID uuid) throws ResourceRegistryException {
        return (Context)this.uuidToContext.get(uuid);
    }

    protected Metadata getMetadataForPrivacy(ObjectMapper objectMapper, Metadata metadata) {
        ObjectNode objectNode = (ObjectNode)objectMapper.valueToTree((Object)metadata);
        objectNode.replace("createdBy", (JsonNode)new TextNode("HIDDEN_FOR_PRIVACY"));
        objectNode.replace("lastUpdateBy", (JsonNode)new TextNode("HIDDEN_FOR_PRIVACY"));
        try {
            Metadata metadataWithPrivacy = (Metadata)objectMapper.treeToValue((TreeNode)objectNode, Metadata.class);
            return metadataWithPrivacy;
        }
        catch (JsonProcessingException e) {
            return metadata;
        }
    }

    protected void setContexts(Calendar calendar, List<Context> contexts) {
        UUID uuid;
        this.cleanCache(calendar);
        ObjectMapper objectMapper = ElementMapper.getObjectMapper();
        for (Context c : contexts) {
            UUID uuid2 = c.getID();
            try {
                ContextImpl contextWithMeta = new ContextImpl(c.getName());
                contextWithMeta.setMetadata(c.getMetadata());
                contextWithMeta.setID(uuid2);
                contextWithMeta.setState(c.getState());
                contextWithMeta.setAdditionalProperties(c.getAdditionalProperties());
                this.contexts.add(contextWithMeta);
                this.uuidToContext.put(uuid2, contextWithMeta);
                ContextImpl contextMetaPrivacy = new ContextImpl(c.getName());
                Metadata metadataWithPrivacy = this.getMetadataForPrivacy(objectMapper, c.getMetadata());
                contextMetaPrivacy.setMetadata(metadataWithPrivacy);
                contextMetaPrivacy.setID(uuid2);
                this.contextsMetaPrivacy.add(contextMetaPrivacy);
                this.uuidToContextMetaPrivacy.put(uuid2, contextMetaPrivacy);
                ContextImpl contextNoMeta = new ContextImpl(c.getName());
                contextNoMeta.setMetadata(null);
                contextNoMeta.setID(uuid2);
                this.contextsBasicInfo.add(contextNoMeta);
                this.uuidToContextBasicInfo.put(uuid2, contextNoMeta);
            }
            catch (Exception e) {
                throw new InternalServerErrorException("Error while creating context Cache", (Throwable)e);
            }
        }
        HashMap<UUID, IsParentOf> parentOfWithMetaMap = new HashMap<UUID, IsParentOf>();
        HashMap<UUID, IsParentOf> parentOfMetaWithPrivacyMap = new HashMap<UUID, IsParentOf>();
        HashMap<UUID, IsParentOf> parentOfNoMetaMap = new HashMap<UUID, IsParentOf>();
        for (Context c : contexts) {
            uuid = c.getID();
            Context contextMeta = (Context)this.uuidToContext.get(uuid);
            Context contextMetaPrivacy = (Context)this.uuidToContextMetaPrivacy.get(uuid);
            Context contextNoMeta = (Context)this.uuidToContextBasicInfo.get(uuid);
            if (c.getParent() == null) continue;
            IsParentOf ipo = c.getParent();
            UUID isParentOfParentUUID = ipo.getID();
            UUID contextParentUUID = ipo.getSource().getID();
            Context parentWithMeta = (Context)this.uuidToContext.get(contextParentUUID);
            IsParentOf isParentOfWithMeta = (IsParentOf)parentOfWithMetaMap.get(isParentOfParentUUID);
            if (isParentOfWithMeta == null) {
                isParentOfWithMeta = new IsParentOfImpl(parentWithMeta, contextMeta);
                isParentOfWithMeta.setID(isParentOfParentUUID);
                isParentOfWithMeta.setMetadata(ipo.getMetadata());
                parentOfWithMetaMap.put(isParentOfParentUUID, isParentOfWithMeta);
                parentWithMeta.addChild(isParentOfWithMeta);
            }
            contextMeta.setParent(isParentOfWithMeta);
            Context parentWithMetaPrivacy = (Context)this.uuidToContextMetaPrivacy.get(contextParentUUID);
            IsParentOf isParentOfMetaPrivacy = (IsParentOf)parentOfMetaWithPrivacyMap.get(isParentOfParentUUID);
            if (isParentOfMetaPrivacy == null) {
                isParentOfMetaPrivacy = new IsParentOfImpl(parentWithMetaPrivacy, contextMetaPrivacy);
                isParentOfMetaPrivacy.setID(isParentOfParentUUID);
                Metadata metadataWithPrivacy = this.getMetadataForPrivacy(objectMapper, ipo.getMetadata());
                isParentOfMetaPrivacy.setMetadata(metadataWithPrivacy);
                parentOfMetaWithPrivacyMap.put(isParentOfParentUUID, isParentOfMetaPrivacy);
                parentWithMetaPrivacy.addChild(isParentOfMetaPrivacy);
            }
            contextMetaPrivacy.setParent(isParentOfMetaPrivacy);
            Context parentNoMeta = (Context)this.uuidToContextBasicInfo.get(contextParentUUID);
            IsParentOf isParentOfNoMeta = (IsParentOf)parentOfNoMetaMap.get(isParentOfParentUUID);
            if (isParentOfNoMeta == null) {
                isParentOfNoMeta = new IsParentOfImpl(parentNoMeta, contextNoMeta);
                isParentOfNoMeta.setMetadata(null);
                isParentOfNoMeta.setID(isParentOfParentUUID);
                parentOfNoMetaMap.put(isParentOfParentUUID, isParentOfNoMeta);
                parentNoMeta.addChild(isParentOfNoMeta);
            }
            contextNoMeta.setParent(isParentOfNoMeta);
        }
        for (Context context : contexts) {
            uuid = context.getID();
            String fullName = this.getContextFullName(context);
            this.uuidToContextFullName.put(uuid, fullName);
            this.contextFullNameToUUID.put(fullName, uuid);
        }
        TreeSet contextFullNames = new TreeSet(this.contextFullNameToUUID.keySet());
        for (String contextFullName : contextFullNames) {
            UUID uuid3 = (UUID)this.contextFullNameToUUID.get(contextFullName);
            Context context = (Context)this.uuidToContext.get(uuid3);
            this.contextsTree.addNode((Object)context);
        }
    }
}

