/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.instances.InstanceEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.queries.json.JsonQuery;
import org.gcube.informationsystem.resourceregistry.queries.json.base.JsonQueryERElement;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryFacet;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryIsRelatedTo;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.utils.TypeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonQuery {
    private static Logger logger = LoggerFactory.getLogger(JsonQuery.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected JsonNode jsonQuery;
    protected JsonQueryERElement entryPoint;
    protected ODatabaseDocument oDatabaseDocument;

    public void setJsonQuery(JsonNode jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    public void setJsonQuery(String jsonQuery) throws InvalidQueryException {
        try {
            this.jsonQuery = this.objectMapper.readTree(jsonQuery);
        }
        catch (IOException e) {
            throw new InvalidQueryException((Throwable)e);
        }
    }

    public static JsonQueryERElement getJsonQueryERElement(JsonNode jsonQuery) throws SchemaNotFoundException, SchemaException, ResourceRegistryException {
        String type = TypeUtility.getTypeName((JsonNode)jsonQuery);
        AccessType accessType = TypesCache.getInstance().getCachedType(type).getAccessType();
        JsonQueryResource jsonQueryERElement = null;
        switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[accessType.ordinal()]) {
            case 1: {
                jsonQueryERElement = new JsonQueryResource(jsonQuery);
                jsonQueryERElement.setDirection(Direction.OUT);
                break;
            }
            case 2: {
                jsonQueryERElement = new JsonQueryFacet(jsonQuery);
                break;
            }
            case 3: {
                jsonQueryERElement = new JsonQueryIsRelatedTo(jsonQuery);
                break;
            }
            case 4: {
                jsonQueryERElement = new JsonQueryConsistsOf(jsonQuery);
                break;
            }
            default: {
                throw new InvalidQueryException(String.format("%s is not querable", type.toString()));
            }
        }
        return jsonQueryERElement;
    }

    public StringBuffer createQuery() throws SchemaException, InvalidQueryException, ResourceRegistryException {
        this.entryPoint = JsonQuery.getJsonQueryERElement((JsonNode)this.jsonQuery);
        this.entryPoint.setEntryPoint(true);
        return this.entryPoint.createQuery(new StringBuffer());
    }

    public StringBuffer createMatchQuery() throws SchemaException, InvalidQueryException, ResourceRegistryException {
        this.entryPoint = JsonQuery.getJsonQueryERElement((JsonNode)this.jsonQuery);
        this.entryPoint.setEntryPoint(true);
        return this.entryPoint.createMatchQuery(new StringBuffer());
    }

    public String query() throws InvalidQueryException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        this.oDatabaseDocument = null;
        try {
            Integer offset;
            InstanceEnvironment instanceEnvironment = ContextUtility.getCurrentRequestEnvironment();
            this.oDatabaseDocument = instanceEnvironment.getDatabaseDocument(Environment.PermissionMode.READER);
            this.oDatabaseDocument.begin();
            ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
            Integer limit = requestInfo.getLimit();
            if (limit == null) {
                limit = -1;
            }
            if ((offset = requestInfo.getOffset()) == null) {
                offset = 0;
            }
            StringBuffer stringBuffer = this.createQuery();
            stringBuffer.append(" SKIP :offset");
            stringBuffer.append(" LIMIT :limit");
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("offset", offset);
            map.put("limit", limit);
            String query = stringBuffer.toString();
            logger.trace("Going to execute the following query:\n{} \n from the JSONQuery\n{}", (Object)query, (Object)this.objectMapper.writeValueAsString((Object)this.jsonQuery));
            OResultSet resultSet = this.oDatabaseDocument.query(query, map);
            ArrayNode arrayNode = this.objectMapper.createArrayNode();
            boolean projection = this.entryPoint.isProjection();
            boolean first = true;
            Set keys = new HashSet();
            while (resultSet.hasNext()) {
                OResult oResult = resultSet.next();
                if (projection) {
                    if (first) {
                        keys = oResult.getPropertyNames();
                        first = false;
                    }
                    ObjectNode objectNode = this.objectMapper.createObjectNode();
                    for (String key : keys) {
                        Object value = oResult.getProperty(key);
                        if (value == null) {
                            objectNode.put(key, "");
                            continue;
                        }
                        if (value instanceof String) {
                            objectNode.put(key, (String)value);
                            continue;
                        }
                        if (value instanceof Integer) {
                            objectNode.put(key, (Integer)value);
                            continue;
                        }
                        if (value instanceof Long) {
                            objectNode.put(key, (Long)value);
                            continue;
                        }
                        objectNode.put(key, value.toString());
                    }
                    arrayNode.add((JsonNode)objectNode);
                    continue;
                }
                OElement element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
                try {
                    JsonNode jsonNodeResult = null;
                    ElementManagement erManagement = ERManagementUtility.getERManagement((Environment)instanceEnvironment, (ODatabaseDocument)this.oDatabaseDocument, (OElement)element);
                    erManagement.setAsEntryPoint();
                    jsonNodeResult = erManagement.serializeAsJsonNode();
                    arrayNode.add(jsonNodeResult);
                }
                catch (ResourceRegistryException e) {
                    logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)element.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                }
            }
            String string = this.objectMapper.writeValueAsString((Object)arrayNode);
            return string;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }
}

