/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.relations;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.Iterator;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.types.reference.entities.FacetType;

public class ConsistsOfManagement
extends RelationManagement<FacetManagement, FacetType> {
    public static final PropagationConstraint DEFAULT_CONSISTS_OF_PC = new PropagationConstraintImpl();

    public ConsistsOfManagement() {
        super(AccessType.CONSISTS_OF, Facet.class, DEFAULT_CONSISTS_OF_PC);
    }

    protected ConsistsOfNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new ConsistsOfNotFoundException(e.getMessage(), e.getCause());
    }

    public ConsistsOfAvailableInAnotherContextException getSpecificAvailableInAnotherContextException(String message) {
        return new ConsistsOfAvailableInAnotherContextException(message);
    }

    protected ConsistsOfAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new ConsistsOfAlreadyPresentException(message);
    }

    protected FacetManagement newTargetEntityManagement() throws ResourceRegistryException {
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setODatabaseDocument(this.oDatabaseDocument);
        facetManagement.setWorkingEnvironment(this.getWorkingEnvironment());
        return facetManagement;
    }

    protected OEdge reallyCreate() throws ResourceRegistryException {
        OEdge thisOEdge = super.reallyCreate();
        OVertex target = ((FacetManagement)this.getTargetEntityManagement()).getElement();
        int count = 0;
        Iterable iterable = target.getEdges(ODirection.IN);
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        if (count > 1) {
            throw new SchemaViolationException("It is not possible to create multiple ConsistsOf between the same Facet");
        }
        return thisOEdge;
    }

    protected void checkResource() throws SchemaViolationException, ResourceRegistryException {
        if (!this.entryPoint) {
            return;
        }
        if (this.operation.isSafe()) {
            return;
        }
        if (this.operation == Operation.UPDATE) {
            return;
        }
        ODatabaseDocument targetInstanceEnvironmentODatabaseDocument = null;
        try {
            ResourceManagement resourceManagement = (ResourceManagement)this.getSourceEntityManagement();
            switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$instances$model$Operation[this.operation.ordinal()]) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    resourceManagement = new ResourceManagement();
                    resourceManagement.setElementType(((ResourceManagement)this.sourceEntityManagement).getTypeName());
                    resourceManagement.setUUID(((ResourceManagement)this.sourceEntityManagement).getUUID());
                    if (this.operation == Operation.ADD_TO_CONTEXT) {
                        resourceManagement.setSourceInstanceEnvironment(this.sourceInstanceEnvironment);
                    }
                    resourceManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
                    resourceManagement.setWorkingEnvironment((Environment)this.targetInstanceEnvironment);
                    targetInstanceEnvironmentODatabaseDocument = this.targetInstanceEnvironment.getDatabaseDocument(Environment.PermissionMode.READER);
                    resourceManagement.setODatabaseDocument(targetInstanceEnvironmentODatabaseDocument);
                    break;
                }
                default: {
                    return;
                }
            }
            resourceManagement.setOperation(this.operation);
            resourceManagement.addToRelationManagements((RelationManagement)this);
            resourceManagement.sanityCheck();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (targetInstanceEnvironmentODatabaseDocument != null) {
                targetInstanceEnvironmentODatabaseDocument.close();
                this.oDatabaseDocument.activateOnCurrentThread();
            }
        }
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
        super.sanityCheck();
        this.checkResource();
    }

    static {
        DEFAULT_CONSISTS_OF_PC.setDeleteConstraint(PropagationConstraint.DeleteConstraint.cascade);
        DEFAULT_CONSISTS_OF_PC.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        DEFAULT_CONSISTS_OF_PC.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
    }
}

