/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.relations;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.ForbiddenException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.contexts.reference.ContextState;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.base.relations.RelationElementManagement;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.instances.InstanceEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.FacetManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.types.TypesCache;
import org.gcube.informationsystem.resourceregistry.utils.MetadataUtility;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.resourceregistry.utils.PropagationConstraintOrient;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.relations.RelationType;

public abstract class RelationManagement<T extends EntityManagement<? extends Entity, TET>, TET extends EntityType>
extends RelationElementManagement<ResourceManagement, T, ResourceType, TET>
implements ERManagement {
    protected InstanceEnvironment sourceInstanceEnvironment;
    protected InstanceEnvironment targetInstanceEnvironment;
    protected boolean honourPropagationConstraintsInContextSharing;
    public final PropagationConstraint defaultPropagationConstraint;
    protected PropagationConstraint propagationConstraint;
    protected boolean forceAddToContext;
    protected boolean skipped;

    public void setSourceInstanceEnvironment(InstanceEnvironment source) {
        this.sourceInstanceEnvironment = source;
    }

    public InstanceEnvironment getSourceInstanceEnvironment() {
        return this.sourceInstanceEnvironment;
    }

    public void setTargetInstanceEnvironment(InstanceEnvironment target) {
        this.targetInstanceEnvironment = target;
    }

    public InstanceEnvironment getTargetInstanceEnvironment() {
        return this.targetInstanceEnvironment;
    }

    public boolean isHonourPropagationConstraintsInContextSharing() {
        return this.honourPropagationConstraintsInContextSharing;
    }

    public void setHonourPropagationConstraintsInContextSharing(boolean honourPropagationConstraintsInContextSharing) {
        this.honourPropagationConstraintsInContextSharing = honourPropagationConstraintsInContextSharing;
    }

    public boolean isAvailableOnContext(InstanceEnvironment instanceEnvironment) {
        try {
            return instanceEnvironment.isElementInContext(this.element);
        }
        catch (ResourceRegistryException e) {
            return false;
        }
    }

    protected RelationManagement(AccessType accessType, Class<? extends Entity> targetEntityClass, PropagationConstraint defaultPropagationConstraint) {
        super(accessType, Resource.class, targetEntityClass);
        this.defaultPropagationConstraint = defaultPropagationConstraint;
        this.honourPropagationConstraintsInContextSharing = true;
        this.skipped = false;
    }

    protected Environment getWorkingEnvironment() throws ResourceRegistryException {
        if (this.workingEnvironment == null) {
            Set allowedRoles;
            this.workingEnvironment = ContextUtility.getCurrentRequestEnvironment();
            Context context = ServerContextCache.getInstance().getFullInfoContextByUUID(this.workingEnvironment.getUUID());
            String state = context.getState();
            if (state.compareTo(ContextState.ACTIVE.getState()) != 0 && !this.workingEnvironment.isUserAllowed((Collection)(allowedRoles = this.workingEnvironment.getAllowedRoles()))) {
                throw new ForbiddenException("You are not allowed to operate in non " + ContextState.ACTIVE.getState() + " Contexts. Allowed roles are " + allowedRoles);
            }
        }
        return this.workingEnvironment;
    }

    public OEdge getElement() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.element = super.getElement();
        }
        catch (NotFoundException e) {
            try {
                this.retrieveElementFromAnyContext();
                throw this.getSpecificAvailableInAnotherContextException(this.typeName == null ? this.accessType.getName() : this.typeName + " with UUID " + this.uuid + " is available in another " + Context.class.getSimpleName());
            }
            catch (AvailableInAnotherContextException e1) {
                throw e1;
            }
            catch (Exception e1) {
                throw e;
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return (OEdge)this.element;
    }

    public ResourceManagement giveMeSourceEntityManagementAsIs() throws ResourceRegistryException {
        return (ResourceManagement)this.sourceEntityManagement;
    }

    protected Map<String, JsonNode> fullSerialize(Map<String, JsonNode> visitedSourceResources) throws ResourceRegistryException {
        OVertex source = this.getElement().getVertex(ODirection.OUT);
        String id = source.getIdentity().toString();
        JsonNode sourceResource = visitedSourceResources.get(id);
        ResourceManagement resourceManagement = null;
        if (sourceResource == null) {
            resourceManagement = (ResourceManagement)ElementManagementUtility.getEntityManagement((Environment)this.getWorkingEnvironment(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)source);
            if (this instanceof IsRelatedToManagement) {
                sourceResource = resourceManagement.createCompleteJsonNode();
            } else if (this instanceof ConsistsOfManagement) {
                if (this.includeSource) {
                    sourceResource = resourceManagement.serializeSelfAsJsonNode();
                }
            } else {
                String error = String.format("{%s is not a %s nor a %s. %s", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName(), "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(error);
            }
        }
        if (this instanceof IsRelatedToManagement) {
            sourceResource = ResourceManagement.addIsRelatedTo((JsonNode)sourceResource, (JsonNode)this.serializeAsJsonNode());
        } else if (this instanceof ConsistsOfManagement) {
            sourceResource = ResourceManagement.addConsistsOf((JsonNode)sourceResource, (JsonNode)this.serializeAsJsonNode());
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName(), "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        visitedSourceResources.put(id, sourceResource);
        return visitedSourceResources;
    }

    protected PropagationConstraintOrient getPropagationConstraint(ODocument oDocument) throws ResourceRegistryException {
        PropagationConstraintOrient propagationConstraintOrient = new PropagationConstraintOrient();
        PropagationConstraint propagationConstraint = null;
        if (oDocument == null) {
            propagationConstraint = this.defaultPropagationConstraint;
        } else if (oDocument instanceof PropagationConstraintOrient) {
            propagationConstraint = (PropagationConstraint)oDocument;
        } else {
            try {
                propagationConstraint = (PropagationConstraint)ElementMapper.unmarshal(PropagationConstraint.class, (String)OrientDBUtility.toJsonString((ORecord)oDocument));
            }
            catch (Exception e) {
                this.logger.warn("Unable to recreate {}. {}", (Object)"PropagationConstraint", (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        PropagationConstraint.AddConstraint addConstraint = propagationConstraint.getAddConstraint();
        if (addConstraint == null) {
            addConstraint = this.defaultPropagationConstraint.getAddConstraint();
            this.logger.debug("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.AddConstraint.class.getSimpleName(), (Object)addConstraint);
        }
        propagationConstraintOrient.setAddConstraint(addConstraint);
        PropagationConstraint.RemoveConstraint removeConstraint = propagationConstraint.getRemoveConstraint();
        if (removeConstraint == null) {
            removeConstraint = this.defaultPropagationConstraint.getRemoveConstraint();
            this.logger.debug("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.RemoveConstraint.class.getSimpleName(), (Object)removeConstraint);
        } else if (this instanceof ConsistsOfManagement && removeConstraint == PropagationConstraint.RemoveConstraint.keep) {
            removeConstraint = this.defaultPropagationConstraint.getRemoveConstraint();
            this.logger.warn("A {} cannot use {}.{}. Default value ({}) will be used", new Object[]{"ConsistsOf", PropagationConstraint.RemoveConstraint.class.getSimpleName(), PropagationConstraint.RemoveConstraint.keep, removeConstraint});
        }
        propagationConstraintOrient.setRemoveConstraint(removeConstraint);
        PropagationConstraint.DeleteConstraint deleteConstraint = propagationConstraint.getDeleteConstraint();
        if (deleteConstraint == null) {
            deleteConstraint = this.defaultPropagationConstraint.getDeleteConstraint();
            this.logger.debug("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.DeleteConstraint.class.getSimpleName(), (Object)deleteConstraint);
        } else if (this instanceof ConsistsOfManagement && deleteConstraint == PropagationConstraint.DeleteConstraint.keep) {
            deleteConstraint = this.defaultPropagationConstraint.getDeleteConstraint();
            this.logger.warn("A {} cannot use {}.{}. Default value ({}) will be used", new Object[]{"ConsistsOf", PropagationConstraint.DeleteConstraint.class.getSimpleName(), PropagationConstraint.DeleteConstraint.keep, deleteConstraint});
        }
        propagationConstraintOrient.setDeleteConstraint(deleteConstraint);
        return propagationConstraintOrient;
    }

    protected void checkPropagationConstraint() throws ResourceRegistryException {
        Object object = this.getElement().getProperty("propagationConstraint");
        PropagationConstraintOrient pc = this.getPropagationConstraint((ODocument)object);
        this.getElement().setProperty("propagationConstraint", (Object)pc, new OType[]{OType.EMBEDDED});
    }

    protected OEdge reallyCreate() throws ResourceRegistryException {
        this.element = super.reallyCreate();
        this.checkPropagationConstraint();
        this.logger.trace("{} successfully created", (Object)this.typeName);
        return (OEdge)this.element;
    }

    protected ResourceManagement newSourceEntityManagement() throws ResourceRegistryException {
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setWorkingEnvironment(this.getWorkingEnvironment());
        resourceManagement.setODatabaseDocument(this.oDatabaseDocument);
        return resourceManagement;
    }

    protected String getEntityTypeNotValidErrroMessage(String entityPosition, String requiredType, String effectiveType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The ");
        stringBuffer.append(entityPosition);
        stringBuffer.append(" instance of the relation ");
        stringBuffer.append(this.typeName);
        stringBuffer.append(" is of type ");
        stringBuffer.append(effectiveType);
        stringBuffer.append(" which is not a specialisation of ");
        stringBuffer.append(requiredType);
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    protected void checksourceAndTargetEntityCompliancy() throws NotFoundException, AvailableInAnotherContextException, SchemaViolationException, ResourceRegistryException {
        String sourceType = ((ResourceManagement)this.sourceEntityManagement).getTypeName();
        String targetType = ((EntityManagement)this.targetEntityManagement).getTypeName();
        RelationType relationType = (RelationType)this.getCachedType().getType();
        ResourceType resourceType = (ResourceType)relationType.getSource();
        EntityType tet = relationType.getTarget();
        String requiredSourceType = resourceType.getName();
        String requiredTargetType = tet.getName();
        TypesCache typesCache = TypesCache.getInstance();
        if (!this.typeSatified(typesCache, requiredSourceType, sourceType)) {
            String message = this.getEntityTypeNotValidErrroMessage("source", requiredSourceType, sourceType);
            throw new SchemaViolationException(message);
        }
        if (!this.typeSatified(typesCache, requiredTargetType, targetType)) {
            String message = this.getEntityTypeNotValidErrroMessage("target", requiredTargetType, targetType);
            throw new SchemaViolationException(message);
        }
    }

    protected OEdge reallyUpdate() throws ResourceRegistryException {
        JsonNode target;
        this.logger.trace("Trying to update {} with UUID {}", (Object)this.typeName, (Object)this.uuid);
        this.logger.trace("Trying to update {} : {}", (Object)this.typeName, (Object)this.jsonNode);
        OEdge edge = this.getElement();
        this.updateProperties(this.oClass, (OElement)edge, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        if (this.accessType.compareTo((Enum)AccessType.CONSISTS_OF) == 0 && (target = this.jsonNode.get("target")) != null) {
            FacetManagement facetManagement = new FacetManagement();
            facetManagement.setWorkingEnvironment(this.getWorkingEnvironment());
            facetManagement.setODatabaseDocument(this.oDatabaseDocument);
            facetManagement.setJsonNode(target);
            facetManagement.internalUpdate();
        }
        this.logger.info("{} with UUID {} successfully updated", (Object)this.typeName, (Object)this.uuid);
        this.logger.trace("{} {} successfully updated", (Object)this.typeName, (Object)this.jsonNode);
        return edge;
    }

    protected void reallyAddToContext() throws ContextException, ResourceRegistryException {
        if (!this.forceAddToContext && !this.sourceInstanceEnvironment.isElementInContext((OElement)this.getElement())) {
            this.skipped = true;
            return;
        }
        if (this.honourPropagationConstraintsInContextSharing) {
            PropagationConstraint.AddConstraint addConstraint = PropagationConstraint.AddConstraint.unpropagate;
            try {
                this.propagationConstraint = (PropagationConstraint)OrientDBUtility.getPropertyDocument(PropagationConstraint.class, (OElement)this.element, (String)"propagationConstraint");
                if (this.propagationConstraint.getAddConstraint() == null) {
                    String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "add", OrientDBUtility.getAsStringForException((ORecord)this.element), "This is really strange and should not occur. Please contact the system administrator.");
                    this.logger.error(error);
                    throw new ResourceRegistryException(error);
                }
                addConstraint = this.propagationConstraint.getAddConstraint();
            }
            catch (Exception e) {
                String error = String.format("Error while getting %s from %s while performing AddToContext. %s", "propagationConstraint", OrientDBUtility.getAsStringForException((ORecord)this.element), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.warn(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
            switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$AddConstraint[addConstraint.ordinal()]) {
                case 1: {
                    ((EntityManagement)this.getTargetEntityManagement()).setDryRun(this.dryRun);
                    ((EntityManagement)this.targetEntityManagement).setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
                    ((EntityManagement)this.targetEntityManagement).setSourceInstanceEnvironment(this.sourceInstanceEnvironment);
                    ((EntityManagement)this.targetEntityManagement).setTargetInstanceEnvironment(this.targetInstanceEnvironment);
                    ((EntityManagement)this.targetEntityManagement).internalAddToContext();
                    this.affectedInstances.putAll(((EntityManagement)this.targetEntityManagement).getAffectedInstances());
                    this.targetInstanceEnvironment.addElement((OElement)this.getElement(), this.oDatabaseDocument);
                    break;
                }
                case 2: {
                    break;
                }
            }
        } else {
            this.targetInstanceEnvironment.addElement((OElement)this.getElement(), this.oDatabaseDocument);
        }
    }

    public void internalAddToContext() throws ContextException, ResourceRegistryException {
        try {
            this.operation = Operation.ADD_TO_CONTEXT;
            this.reallyAddToContext();
            if (!this.skipped && this.propagationConstraint.getAddConstraint() == PropagationConstraint.AddConstraint.propagate) {
                MetadataUtility.updateModifiedByAndLastUpdate((OElement)this.element);
                ((OEdge)this.element).save();
                this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Adding " + this.typeName + " to " + this.targetInstanceEnvironment.toString(), e.getCause());
        }
    }

    public void forcedAddToContext() throws ContextException, ResourceRegistryException {
        this.setOperation(Operation.ADD_TO_CONTEXT);
        ((ResourceManagement)this.getSourceEntityManagement()).setDryRun(this.dryRun);
        ((ResourceManagement)this.sourceEntityManagement).setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
        ((ResourceManagement)this.sourceEntityManagement).setTargetInstanceEnvironment(this.targetInstanceEnvironment);
        ((ResourceManagement)this.sourceEntityManagement).internalAddToContext();
        this.affectedInstances.putAll(((ResourceManagement)this.sourceEntityManagement).getAffectedInstances());
        ((EntityManagement)this.getTargetEntityManagement()).setDryRun(this.dryRun);
        ((EntityManagement)this.targetEntityManagement).setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
        ((EntityManagement)this.targetEntityManagement).setTargetInstanceEnvironment(this.targetInstanceEnvironment);
        ((EntityManagement)this.targetEntityManagement).internalAddToContext();
        this.affectedInstances.putAll(((EntityManagement)this.targetEntityManagement).getAffectedInstances());
        this.targetInstanceEnvironment.addElement((OElement)this.getElement(), this.oDatabaseDocument);
        this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
    }

    public void addToContext(UUID contextUUID) throws SchemaViolationException, NotFoundException, ContextException, ResourceRegistryException {
        String contextFullName = ServerContextCache.getInstance().getContextFullNameByUUID(contextUUID);
        this.logger.debug("Going to add {} with UUID {} to Context with UUID {} (i.e {})", new Object[]{this.accessType.getName(), this.uuid, contextUUID, contextFullName});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingEnvironment = AdminEnvironment.getInstance();
            this.oDatabaseDocument = this.workingEnvironment.getDatabaseDocument(Environment.PermissionMode.WRITER);
            this.setAsEntryPoint();
            this.sourceInstanceEnvironment = ContextUtility.getCurrentRequestEnvironment();
            this.targetInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(contextUUID);
            this.forcedAddToContext();
            this.sanityCheck();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
            } else {
                this.oDatabaseDocument.rollback();
            }
            this.logger.info("{} with UUID {} successfully added to Context with UUID {} (i.e {})", new Object[]{this.accessType.getName(), this.uuid, contextUUID, contextFullName});
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {} (i.e. {})", new Object[]{this.accessType.getName(), this.uuid, contextUUID, contextFullName, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected Map<UUID, JsonNode> reallyRemoveFromContext() throws ContextException, ResourceRegistryException {
        if (!this.targetInstanceEnvironment.isElementInContext((OElement)this.getElement())) {
            return this.affectedInstances;
        }
        ((ResourceManagement)this.getSourceEntityManagement()).getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            this.propagationConstraint = (PropagationConstraint)OrientDBUtility.getPropertyDocument(PropagationConstraint.class, (OElement)this.element, (String)"propagationConstraint");
            if (this.propagationConstraint.getRemoveConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "remove", OrientDBUtility.getAsStringForException((ORecord)this.element), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            removeConstraint = this.propagationConstraint.getRemoveConstraint();
        }
        catch (Exception e) {
            String error = String.format("Error while getting %s from %s while performing RemoveFromContext. %s", "propagationConstraint", OrientDBUtility.getAsStringForException((ORecord)this.element), "This is really strange and should not occur. Please contact the system administrator.");
            this.logger.error(error);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        this.targetInstanceEnvironment.removeElement((OElement)this.getElement(), this.oDatabaseDocument);
        this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
        EntityManagement targetEntityManagement = (EntityManagement)this.getTargetEntityManagement();
        targetEntityManagement.setDryRun(this.dryRun);
        targetEntityManagement.setHonourPropagationConstraintsInContextSharing(this.honourPropagationConstraintsInContextSharing);
        targetEntityManagement.setTargetInstanceEnvironment(this.targetInstanceEnvironment);
        if (targetEntityManagement instanceof ResourceManagement) {
            ((ResourceManagement)targetEntityManagement).setSanityCheckNotRequired();
        }
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                targetEntityManagement.internalRemoveFromContext();
                this.affectedInstances.putAll(targetEntityManagement.getAffectedInstances());
                break;
            }
            case 2: {
                OVertex target = targetEntityManagement.getElement();
                Iterable iterable = target.getEdges(ODirection.IN);
                Iterator iterator = iterable.iterator();
                int count = 0;
                OEdge edge = null;
                while (iterator.hasNext()) {
                    OEdge thisOEdge;
                    edge = (OEdge)iterator.next();
                    if (edge.compareTo((Object)(thisOEdge = this.getElement())) == 0 || thisOEdge.getVertex(ODirection.OUT).compareTo((Object)edge.getVertex(ODirection.OUT)) == 0) continue;
                    ++count;
                    break;
                }
                if (count > 0) {
                    this.logger.trace("{} point to {} which is not orphan ({} exists). Giving {} directive, it will be not remove from {}.", new Object[]{this.element, target, edge, removeConstraint, this.targetInstanceEnvironment});
                    break;
                }
                targetEntityManagement.internalRemoveFromContext();
                this.affectedInstances.putAll(targetEntityManagement.getAffectedInstances());
                break;
            }
            case 3: {
                break;
            }
        }
        return this.affectedInstances;
    }

    public void internalRemoveFromContext() throws ContextException, ResourceRegistryException {
        try {
            this.setOperation(Operation.REMOVE_FROM_CONTEXT);
            this.reallyRemoveFromContext();
            MetadataUtility.updateModifiedByAndLastUpdate((OElement)this.element);
            ((OEdge)this.element).save();
            this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error Removing " + this.typeName + " from " + this.targetInstanceEnvironment.toString(), e.getCause());
        }
    }

    public void removeFromContext(UUID contextUUID) throws NotFoundException, ContextException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.workingEnvironment = AdminEnvironment.getInstance();
            this.oDatabaseDocument = this.workingEnvironment.getDatabaseDocument(Environment.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            this.setAsEntryPoint();
            this.targetInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(contextUUID);
            this.internalRemoveFromContext();
            this.sanityCheck();
            if (!this.dryRun) {
                this.oDatabaseDocument.commit();
            } else {
                this.oDatabaseDocument.rollback();
            }
            this.logger.info("{} with UUID {} successfully removed from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to remove {} with UUID {} from Context with UUID {}", new Object[]{this.typeName, this.uuid, contextUUID, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {}. Related {}s will be detached.", new Object[]{this.accessType.getName(), this.uuid, this.targetEntityClass.getSimpleName()});
        this.getElement();
        ((ResourceManagement)this.getSourceEntityManagement()).getElement();
        PropagationConstraint.DeleteConstraint deleteConstraint = PropagationConstraint.DeleteConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)OrientDBUtility.getPropertyDocument(PropagationConstraint.class, (OElement)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getDeleteConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "delete", OrientDBUtility.getAsStringForException((ORecord)this.element), "This is really strange and should not occur. Please contact the system administrator.");
                deleteConstraint = PropagationConstraint.DeleteConstraint.values()[propagationConstraint.getRemoveConstraint().ordinal()];
                throw new ResourceRegistryException(error);
            }
            deleteConstraint = propagationConstraint.getDeleteConstraint();
        }
        catch (Exception e) {
            this.logger.warn("Error while getting {} from {}. Assuming {}. {}", new Object[]{"propagationConstraint", OrientDBUtility.getAsStringForException((ORecord)this.element), deleteConstraint, "This is really strange and should not occur. Please contact the system administrator."});
        }
        EntityManagement t = (EntityManagement)this.getTargetEntityManagement();
        if (this.targetEntityManagement instanceof ResourceManagement) {
            ((ResourceManagement)this.targetEntityManagement).setSanityCheckNotRequired();
        }
        this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
        ((OEdge)this.element).delete();
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$DeleteConstraint[deleteConstraint.ordinal()]) {
            case 1: {
                t.internalDelete();
                break;
            }
            case 2: {
                OVertex target = t.getElement();
                Iterable iterable = target.getEdges(ODirection.IN);
                Iterator iterator = iterable.iterator();
                if (iterator.hasNext()) {
                    this.logger.trace("{} point to {} which is not orphan. Giving {} directive, it will be keep.", new Object[]{this.element, target, deleteConstraint});
                    break;
                }
                ((EntityManagement)this.getTargetEntityManagement()).internalDelete();
                break;
            }
            case 3: {
                break;
            }
        }
        this.affectedInstances.putAll(t.getAffectedInstances());
    }

    private Collection<JsonNode> serializeEdges(Iterable<ODocument> edges, boolean postFilterPolymorphic) throws ResourceRegistryException {
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        int limit = requestInfo.getLimit();
        int offset = requestInfo.getOffset();
        int position = -1;
        int count = 0;
        ArrayList<JsonNode> serilizedEdges = new ArrayList<JsonNode>();
        for (ODocument d : edges) {
            if (++position < offset) continue;
            OEdge edge = (OEdge)d;
            if (postFilterPolymorphic && this.getOClass().isSubClassOf(this.typeName)) continue;
            RelationManagement relationManagement = ElementManagementUtility.getRelationManagement((Environment)this.getWorkingEnvironment(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
            serilizedEdges.add(relationManagement.serializeAsJsonNode());
            if (limit <= 0 || ++count < limit) continue;
            break;
        }
        return serilizedEdges;
    }

    protected String serializeJsonNodeCollectionAsString(Collection<JsonNode> collection) throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = (ArrayNode)objectMapper.valueToTree(collection);
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ORecordIteratorClass edges = this.oDatabaseDocument.browseClass(this.typeName, polymorphic);
        Collection collection = this.serializeEdges((Iterable)edges, false);
        return this.serializeJsonNodeCollectionAsString(collection);
    }

    public void setForceAddToContext(Boolean forceAddToContext) {
        this.forceAddToContext = forceAddToContext;
    }
}

