/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts.entities;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.NullNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.reference.ContextState;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.contexts.relations.IsParentOfManagement;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.HierarchicalEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.contexts.ContextEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.instances.InstanceEnvironment;
import org.gcube.informationsystem.resourceregistry.queries.operators.ComparisonOperator;
import org.gcube.informationsystem.resourceregistry.queries.operators.LogicalOperator;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.utils.UUIDManager;
import org.gcube.informationsystem.utils.UUIDUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextManagement
extends EntityElementManagement<Context, EntityType> {
    private static Logger logger = LoggerFactory.getLogger(ContextManagement.class);
    protected String name;
    protected Integer forceOffset;
    protected Integer forceLimit;

    public void setForceOffset(Integer forceOffset) {
        this.forceOffset = forceOffset;
    }

    public void setForceLimit(Integer forceLimit) {
        this.forceLimit = forceLimit;
    }

    private void init() {
        this.ignoreStartWithKeys.add("parent");
        this.ignoreStartWithKeys.add("children");
        this.typeName = "Context";
        this.forceIncludeMeta = true;
        this.forceIncludeAllMeta = true;
        this.forceOffset = null;
        this.forceLimit = null;
    }

    public ContextManagement() {
        super(AccessType.CONTEXT);
        this.init();
    }

    public ContextManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.getWorkingEnvironment();
    }

    public Map<UUID, JsonNode> getAffectedInstances() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OVertex)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected Environment getWorkingEnvironment() throws ResourceRegistryException {
        if (this.workingEnvironment == null) {
            this.workingEnvironment = ContextEnvironment.getInstance();
        }
        return this.workingEnvironment;
    }

    protected ContextNotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new ContextNotFoundException(e.getMessage(), e.getCause());
    }

    protected ContextAlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new ContextAlreadyPresentException(message);
    }

    protected void checkContext(ContextManagement parentContext) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        StringBuffer select = new StringBuffer();
        StringBuffer errorMessage = new StringBuffer();
        if (parentContext != null) {
            String parentId = ((OVertex)parentContext.getElement()).getIdentity().toString();
            select.append("SELECT FROM (TRAVERSE out(");
            select.append("IsParentOf");
            select.append(") FROM ");
            select.append(parentId);
            select.append(" MAXDEPTH 1) WHERE ");
            select.append("name");
            select.append(ComparisonOperator.EQ.getDbOperator());
            select.append("\"");
            select.append(this.getName());
            select.append("\"");
            select.append(LogicalOperator.AND.getDbOperator());
            select.append("id");
            select.append(ComparisonOperator.NE.getDbOperator());
            select.append("\"");
            select.append(parentContext.uuid);
            select.append("\"");
            errorMessage.append("A ");
            errorMessage.append("Context");
            errorMessage.append(" with ");
            errorMessage.append(this.getName());
            errorMessage.append(" has been already created as child of ");
            errorMessage.append(((OVertex)parentContext.getElement()).toString());
        } else {
            select.append("SELECT FROM ");
            select.append("Context");
            select.append(" WHERE ");
            select.append("name");
            select.append(ComparisonOperator.EQ.getDbOperator());
            select.append("\"");
            select.append(this.getName());
            select.append("\"");
            select.append(LogicalOperator.AND.getDbOperator());
            select.append("in(\"");
            select.append("IsParentOf");
            select.append("\").size() = 0");
            errorMessage.append("A root ");
            errorMessage.append("Context");
            errorMessage.append(" with ");
            errorMessage.append(this.getName());
            errorMessage.append(" already exist");
        }
        logger.trace("Checking if {} -> {}", (Object)errorMessage, (Object)select);
        OResultSet resultSet = this.oDatabaseDocument.command(select.toString(), new HashMap());
        if (resultSet != null && resultSet.hasNext()) {
            throw new ContextAlreadyPresentException(errorMessage.toString());
        }
    }

    private JsonNode filterFieldsByRole(JsonNode context) {
        return context;
    }

    protected JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        JsonNode context = this.serializeSelfAsJsonNode();
        context = this.filterFieldsByRole(context);
        int count = 0;
        Iterable parents = ((OVertex)this.getElement()).getEdges(ODirection.IN);
        for (OEdge edge : parents) {
            if (++count > 1) {
                throw new ContextException("A Context can not have more than one parent");
            }
            try {
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
                isParentOfManagement.setElement((OElement)edge);
                isParentOfManagement.includeSource(true);
                isParentOfManagement.includeTarget(false);
                JsonNode isParentOf = isParentOfManagement.createCompleteJsonNode();
                if (isParentOf == null) continue;
                ((ObjectNode)context).replace("parent", isParentOf);
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ContextException("");
            }
        }
        Iterable childrenEdges = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        for (OEdge edge : childrenEdges) {
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
            isParentOfManagement.setElement((OElement)edge);
            try {
                JsonNode isParentOf = isParentOfManagement.serializeAsJsonNode();
                context = ContextManagement.addRelation((JsonNode)context, (JsonNode)isParentOf, (String)"children");
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return context;
    }

    protected OVertex reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        InstanceEnvironment newInstanceEnvironment = null;
        InstanceEnvironment parentInstanceEnvironment = null;
        if (this.uuid == null) {
            this.uuid = UUIDManager.getInstance().generateValidUUID();
        }
        newInstanceEnvironment = new InstanceEnvironment(this.uuid);
        boolean vertexCreated = false;
        try {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
                Set allowedRoles;
                JsonNode parentJsonNode = isParentOfJsonNode.get("source");
                ContextManagement parentContextManagement = new ContextManagement(this.oDatabaseDocument);
                parentContextManagement.setJsonNode(parentJsonNode);
                UUID parentUUID = parentContextManagement.getUUID();
                parentInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(parentUUID);
                InstanceEnvironment requestEnvironment = null;
                try {
                    requestEnvironment = ContextUtility.getCurrentRequestEnvironment();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (requestEnvironment != null && requestEnvironment.getUUID().compareTo(parentContextManagement.getUUID()) == 0) {
                    allowedRoles = requestEnvironment.getAllowedRoles();
                    if (!parentInstanceEnvironment.isUserAllowed((Collection)allowedRoles)) {
                        throw new NotAuthorizedException((Object)("Only user with one of the following roles " + allowedRoles + " can create a child Context."), new Object[0]);
                    }
                } else {
                    allowedRoles = Environment.getAllOperationsAllowedRoles();
                    if (!newInstanceEnvironment.isUserAllowed((Collection)allowedRoles)) {
                        throw new NotAuthorizedException((Object)("Only user with one of the following roles " + allowedRoles + " can create a child Context requesting the operation from a Context which is not the parent."), new Object[0]);
                    }
                }
                this.checkContext(parentContextManagement);
                this.logFullPath();
                this.createVertex();
                vertexCreated = true;
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
                isParentOfManagement.setJsonNode(isParentOfJsonNode);
                isParentOfManagement.setSourceEntityManagement((EntityElementManagement)parentContextManagement);
                isParentOfManagement.setTargetEntityManagement((EntityElementManagement)this);
                isParentOfManagement.internalCreate();
            } else {
                Set allowedRoles = Environment.getAllOperationsAllowedRoles();
                if (!newInstanceEnvironment.isUserAllowed((Collection)allowedRoles)) {
                    throw new NotAuthorizedException((Object)("Only user with one of the following roles " + allowedRoles + " can create a root Context."), new Object[0]);
                }
                this.checkContext(null);
                this.logFullPath();
                this.createVertex();
                vertexCreated = true;
            }
            ((OVertex)this.element).setProperty("state", (Object)ContextState.CREATED.getState());
            newInstanceEnvironment.setParentEnvironment((HierarchicalEnvironment)parentInstanceEnvironment);
            newInstanceEnvironment.create(this.oDatabaseDocument);
            ContextUtility.getInstance().addInstanceEnvironment(newInstanceEnvironment);
            OVertex oVertex = (OVertex)this.getElement();
            return oVertex;
        }
        catch (Exception e) {
            this.oDatabaseDocument.rollback();
            if (vertexCreated) {
                newInstanceEnvironment.delete(this.oDatabaseDocument);
                if (parentInstanceEnvironment != null && newInstanceEnvironment != null) {
                    parentInstanceEnvironment.getChildren().remove(newInstanceEnvironment);
                }
            }
            throw e;
        }
        finally {
            ServerContextCache.getInstance().cleanCache();
        }
    }

    protected void logFullPath() {
    }

    protected void checkStateChange(ContextState newContextstate) {
        if (newContextstate == ContextState.DELETED || newContextstate == ContextState.CREATED) {
            throw new BadRequestException("A Context cannot be set to " + newContextstate.getState());
        }
    }

    protected OVertex reallyUpdate() throws NotFoundException, ResourceRegistryException {
        Set allowedRoles = Environment.getAllOperationsAllowedRoles();
        if (!this.workingEnvironment.isUserAllowed((Collection)allowedRoles)) {
            throw new ForbiddenException("You are not allowed to update a Context. Allowed roles are " + allowedRoles);
        }
        boolean parentChanged = false;
        boolean nameChanged = false;
        boolean stateChanged = false;
        OVertex parent = null;
        boolean found = false;
        Iterable iterable = ((OVertex)this.getElement()).getVertices(ODirection.IN, new String[]{"IsParentOf"});
        for (OVertex p : iterable) {
            if (found) {
                String message = String.format("{} has more than one parent. {}", "Context", "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(message.toString());
            }
            parent = p;
            found = true;
        }
        ContextManagement actualParentContextManagement = null;
        if (parent != null) {
            actualParentContextManagement = new ContextManagement(this.oDatabaseDocument);
            actualParentContextManagement.setElement((OElement)parent);
        }
        ContextManagement newParentContextManagement = actualParentContextManagement;
        JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
        JsonNode parentContextJsonNode = null;
        if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
            parentContextJsonNode = isParentOfJsonNode.get("source");
        }
        if (parentContextJsonNode != null && !(parentContextJsonNode instanceof NullNode)) {
            UUID parentUUID = UUIDUtility.getUUID((JsonNode)parentContextJsonNode);
            if (actualParentContextManagement != null) {
                if (parentUUID.compareTo(actualParentContextManagement.uuid) != 0) {
                    parentChanged = true;
                }
            } else {
                parentChanged = true;
            }
            if (parentChanged) {
                newParentContextManagement = new ContextManagement(this.oDatabaseDocument);
                newParentContextManagement.setJsonNode(parentContextJsonNode);
            }
        } else if (actualParentContextManagement != null) {
            parentChanged = true;
            newParentContextManagement = null;
        }
        String oldName = (String)((OVertex)this.element).getProperty("name");
        String newName = this.jsonNode.get("name").asText();
        if (oldName.compareTo(newName) != 0) {
            this.name = newName;
            nameChanged = true;
        }
        String oldStateString = (String)((OVertex)this.element).getProperty("state");
        ContextState state = ContextState.fromString((String)oldStateString);
        JsonNode stateNode = this.jsonNode.get("state");
        String newStateString = stateNode.asText();
        if (newStateString.compareTo(oldStateString) != 0) {
            state = ContextState.fromString((String)newStateString);
            stateChanged = true;
        }
        if (stateChanged) {
            this.checkStateChange(state);
        }
        if (parentChanged || nameChanged) {
            this.checkContext(newParentContextManagement);
        }
        if (parentChanged) {
            this.move(newParentContextManagement, false);
        }
        if (parentChanged || nameChanged) {
            this.logFullPath();
        }
        this.element = (OVertex)this.updateProperties(this.oClass, this.getElement(), this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        ServerContextCache.getInstance().cleanCache();
        return (OVertex)this.element;
    }

    private void move(ContextManagement newParentContextManagement, boolean check) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        if (check) {
            this.checkContext(newParentContextManagement);
        }
        InstanceEnvironment newParentInstanceEnvironment = null;
        Iterable edges = ((OVertex)this.getElement()).getEdges(ODirection.IN, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            Iterator edgeIterator = edges.iterator();
            OEdge edge = (OEdge)edgeIterator.next();
            if (edgeIterator.hasNext()) {
                throw new ContextException("Seems that the Context has more than one Parent. This is really strange and should not occur. Please contact the system administrator.");
            }
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement();
            isParentOfManagement.setElement((OElement)edge);
            isParentOfManagement.internalDelete();
        }
        if (newParentContextManagement != null) {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.oDatabaseDocument);
            isParentOfManagement.setJsonNode(isParentOfJsonNode);
            isParentOfManagement.setSourceEntityManagement((EntityElementManagement)newParentContextManagement);
            isParentOfManagement.setTargetEntityManagement((EntityElementManagement)this);
            isParentOfManagement.internalCreate();
            newParentInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(newParentContextManagement.uuid);
        }
        InstanceEnvironment thisInstanceEnvironment = ContextUtility.getInstance().getEnvironmentByUUID(this.uuid);
        thisInstanceEnvironment.changeParentEnvironment(newParentInstanceEnvironment, this.oDatabaseDocument);
    }

    protected void reallyDelete() throws NotFoundException, ResourceRegistryException {
        Iterable iterable;
        Iterator iterator;
        ContextUtility contextUtility = ContextUtility.getInstance();
        InstanceEnvironment instanceEnvironment = contextUtility.getEnvironmentByUUID(this.uuid);
        InstanceEnvironment parentInstanceEnvironment = (InstanceEnvironment)instanceEnvironment.getParentEnvironment();
        if (parentInstanceEnvironment == null) {
            Set allowedRoles = Environment.getAllOperationsAllowedRoles();
            if (!instanceEnvironment.isUserAllowed((Collection)allowedRoles)) {
                throw new ForbiddenException("Only user with one of the following roles " + allowedRoles + " can delete the root Context.");
            }
        } else {
            Set allowedRoles;
            InstanceEnvironment requestInstanceEnvironment = null;
            try {
                requestInstanceEnvironment = ContextUtility.getCurrentRequestEnvironment();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (requestInstanceEnvironment != null && requestInstanceEnvironment.getUUID().compareTo(parentInstanceEnvironment.getUUID()) == 0) {
                allowedRoles = requestInstanceEnvironment.getAllowedRoles();
                if (!parentInstanceEnvironment.isUserAllowed((Collection)allowedRoles)) {
                    throw new NotAuthorizedException((Object)("Only user with one of the following roles " + allowedRoles + " can delete a child Context."), new Object[0]);
                }
            } else {
                allowedRoles = Environment.getAllOperationsAllowedRoles();
                if (!instanceEnvironment.isUserAllowed((Collection)allowedRoles)) {
                    throw new NotAuthorizedException((Object)("Only user with one of the following roles " + allowedRoles + " can delete a Context requesting the operation from a Context which is not the parent."), new Object[0]);
                }
            }
        }
        if ((iterator = (iterable = ((OVertex)this.getElement()).getEdges(ODirection.OUT)).iterator()).hasNext()) {
            throw new ContextException("Cannot remove a Context having children");
        }
        ((OVertex)this.element).delete();
        instanceEnvironment.delete(this.oDatabaseDocument);
        ServerContextCache.getInstance().cleanCache();
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        Integer limit = requestInfo.getLimit();
        if (this.forceLimit != null) {
            limit = this.forceLimit;
        }
        if (limit == null) {
            limit = -1;
        }
        Integer offset = requestInfo.getOffset();
        if (this.forceOffset != null) {
            offset = this.forceOffset;
        }
        if (offset == null) {
            offset = 0;
        }
        int position = -1;
        int count = 0;
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.typeName, polymorphic);
        for (ODocument vertex : iterable) {
            if (++position < offset) continue;
            ContextManagement contextManagement = new ContextManagement();
            contextManagement.setForceIncludeMeta(this.forceIncludeMeta);
            contextManagement.setForceIncludeAllMeta(this.forceIncludeAllMeta);
            contextManagement.setElement((OElement)((OVertex)vertex));
            try {
                JsonNode jsonObject = contextManagement.serializeAsJsonNode();
                arrayNode.add(jsonObject);
                if (limit <= 0 || ++count < limit) continue;
                break;
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String allFromDatabase(boolean polymorphic) throws ResourceRegistryException {
        return super.all(polymorphic);
    }

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            ServerContextCache contextCache = ServerContextCache.getInstance();
            List contexts = contextCache.getContexts();
            ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
            Integer limit = requestInfo.getLimit();
            if (this.forceLimit != null) {
                limit = this.forceLimit;
            } else if (limit == null) {
                limit = -1;
            }
            Integer offset = requestInfo.getOffset();
            if (this.forceOffset != null) {
                offset = this.forceOffset;
            } else if (offset == null) {
                offset = 0;
            }
            int position = -1;
            int count = 0;
            if (offset == 0 && limit <= 0) {
                return ElementMapper.marshal((List)contexts);
            }
            ArrayList<Context> requestedContexts = new ArrayList<Context>();
            for (Context c : contexts) {
                if (++position < offset) continue;
                requestedContexts.add(c);
                if (limit <= 0 || ++count < limit) continue;
                break;
            }
            return ElementMapper.marshal(requestedContexts);
        }
        catch (JsonProcessingException | ResourceRegistryException e) {
            return this.allFromDatabase(polymorphic);
        }
    }

    public String readFromServer() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        return super.read().toString();
    }

    public String readAsString() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            ServerContextCache contextCache = ServerContextCache.getInstance();
            return ElementMapper.marshal((Element)contextCache.getContextByUUID(this.uuid));
        }
        catch (JsonProcessingException | ResourceRegistryException e) {
            return this.readFromServer();
        }
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
    }
}

