package org.gcube.informationsystem.resourceregistry.contexts.security;

import java.util.UUID;

import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class ShadowContextSecurityContext extends SecurityContext {
	
	private static Logger logger = LoggerFactory.getLogger(SecurityContext.class);
	
	private static final String SHADOW_CONTEXT_SECURITY_CONTEXT;
	private static final UUID SHADOW_CONTEXT_SECURITY_CONTEXT_UUID;
	
	
	static {
		SHADOW_CONTEXT_SECURITY_CONTEXT = "cccccccc-cccc-cccc-cccc-cccccccccccc";
		SHADOW_CONTEXT_SECURITY_CONTEXT_UUID = UUID.fromString(SHADOW_CONTEXT_SECURITY_CONTEXT);
		
	}
	
	private static ShadowContextSecurityContext instance;
	
	public static ShadowContextSecurityContext getInstance() throws ResourceRegistryException {
		if(instance==null) {
			instance = new ShadowContextSecurityContext();
			ContextUtility contextUtility = ContextUtility.getInstance();
			contextUtility.addSecurityContext(SHADOW_CONTEXT_SECURITY_CONTEXT, instance);
		}
		return instance;
	}
	
	private ShadowContextSecurityContext() throws ResourceRegistryException {
		super(SHADOW_CONTEXT_SECURITY_CONTEXT_UUID, false);
	}
	
	@Override
	protected boolean isHierarchicalMode() {
		return false;
	}
	
	@Override
	protected ORole addExtraRules(ORole role, PermissionMode permissionMode) {
		logger.trace("Adding extra rules for {}", role.getName());
		switch(permissionMode) {
			case WRITER:
				role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
				role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL);
				role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
				break;
			
			case READER:
				role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_READ);
				role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_READ);
				role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_READ);
				break;
			
			default:
				break;
		}
		return role;
	}
	
}
