package org.gcube.informationsystem.resourceregistry.queries.json.base.relations;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryFacet;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class JsonQueryConsistsOf extends JsonQueryRelation {

	protected String requestedResourceType;
	
	public JsonQueryConsistsOf(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
		super(jsonQuery, AccessType.CONSISTS_OF);
		this.direction = Direction.IN;
	}
	
	public String getRequestedResourceType() {
		return requestedResourceType;
	}

	public void setRequestedResourceType(String requestedResourceType) {
		this.requestedResourceType = requestedResourceType;
	}

	@Override
	public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
		StringBuffer consistsOfBuffer = new StringBuffer();
		
		if(!jsonNode.has(ConsistsOf.SOURCE_PROPERTY)) {
			consistsOfBuffer.append("TRAVERSE ");
			consistsOfBuffer.append(direction.opposite().name().toLowerCase());
			consistsOfBuffer.append("V(\"");
			consistsOfBuffer.append(requestedResourceType);
			consistsOfBuffer.append("\") FROM ( "); // Open ( 1
		}
		
		int size = jsonNode.size();
		if(size > 2) {
			consistsOfBuffer.append("SELECT FROM ( "); // Open ( SELECT
		}
		
		consistsOfBuffer.append("TRAVERSE ");
		consistsOfBuffer.append(direction.name().toLowerCase());
		consistsOfBuffer.append("E(\"");
		consistsOfBuffer.append(type);
		consistsOfBuffer.append("\") FROM ( "); // Open ( 2
		
		if(!entryPoint) {
			StringBuffer buffer = new StringBuffer();
			buffer.append("TRAVERSE ");
			buffer.append(direction.opposite().name().toLowerCase());		
			buffer.append("E(\"");
			buffer.append(type);
			buffer.append("\") FROM ( ");
			buffer.append(stringBuffer);
			buffer.append(")");
			stringBuffer = buffer;
		}
		
		if(jsonNode.has(ConsistsOf.TARGET_PROPERTY)) {
			JsonNode facetJsonNode = jsonNode.get(ConsistsOf.TARGET_PROPERTY);
			JsonQueryFacet jsonQueryFacet = new JsonQueryFacet(facetJsonNode);
			jsonQueryFacet.setEntryPoint(entryPoint);
			stringBuffer = jsonQueryFacet.analize(stringBuffer);
		} else if(jsonNode.has(ConsistsOf.SOURCE_PROPERTY)) {
			JsonNode resourceJsonNode = jsonNode.get(ConsistsOf.SOURCE_PROPERTY);
			JsonQueryResource jsonQueryResource = new JsonQueryResource(resourceJsonNode);
			jsonQueryResource.setEntryPoint(entryPoint);
			stringBuffer = jsonQueryResource.analize(stringBuffer);
		}
		
		consistsOfBuffer.append(stringBuffer);
		consistsOfBuffer.append(")"); // Close ) 2
		
		// Size 2 means that only 'type' and 'target' properties are present
		if(size > 2) {
			consistsOfBuffer.append(") WHERE "); // Close ) SELECT
			consistsOfBuffer.append(addConstraints(jsonNode, null, null));
		}
		
		if(!jsonNode.has(ConsistsOf.SOURCE_PROPERTY)) {
			consistsOfBuffer.append(")"); // Close ) 1
		}
		
		return consistsOfBuffer;
		
	}
}
