/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.json.base.relations;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryFacet;
import org.gcube.informationsystem.resourceregistry.queries.json.base.entities.JsonQueryResource;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryRelation;

public class JsonQueryConsistsOf
extends JsonQueryRelation {
    protected String requestedResourceType;

    public JsonQueryConsistsOf(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
        super(jsonQuery, AccessType.CONSISTS_OF);
        this.direction = Direction.IN;
    }

    public String getRequestedResourceType() {
        return this.requestedResourceType;
    }

    public void setRequestedResourceType(String requestedResourceType) {
        this.requestedResourceType = requestedResourceType;
    }

    public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
        int size;
        StringBuffer consistsOfBuffer = new StringBuffer();
        if (!this.jsonNode.has("source")) {
            consistsOfBuffer.append("TRAVERSE ");
            consistsOfBuffer.append(this.direction.opposite().name().toLowerCase());
            consistsOfBuffer.append("V(\"");
            consistsOfBuffer.append(this.requestedResourceType);
            consistsOfBuffer.append("\") FROM ( ");
        }
        if ((size = this.jsonNode.size()) > 2) {
            consistsOfBuffer.append("SELECT FROM ( ");
        }
        consistsOfBuffer.append("TRAVERSE ");
        consistsOfBuffer.append(this.direction.name().toLowerCase());
        consistsOfBuffer.append("E(\"");
        consistsOfBuffer.append(this.type);
        consistsOfBuffer.append("\") FROM ( ");
        if (!this.entryPoint) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TRAVERSE ");
            buffer.append(this.direction.opposite().name().toLowerCase());
            buffer.append("E(\"");
            buffer.append(this.type);
            buffer.append("\") FROM ( ");
            buffer.append(stringBuffer);
            buffer.append(")");
            stringBuffer = buffer;
        }
        if (this.jsonNode.has("target")) {
            JsonNode facetJsonNode = this.jsonNode.get("target");
            JsonQueryFacet jsonQueryFacet = new JsonQueryFacet(facetJsonNode);
            jsonQueryFacet.setEntryPoint(this.entryPoint);
            stringBuffer = jsonQueryFacet.analize(stringBuffer);
        } else if (this.jsonNode.has("source")) {
            JsonNode resourceJsonNode = this.jsonNode.get("source");
            JsonQueryResource jsonQueryResource = new JsonQueryResource(resourceJsonNode);
            jsonQueryResource.setEntryPoint(this.entryPoint);
            stringBuffer = jsonQueryResource.analize(stringBuffer);
        }
        consistsOfBuffer.append(stringBuffer);
        consistsOfBuffer.append(")");
        if (size > 2) {
            consistsOfBuffer.append(") WHERE ");
            consistsOfBuffer.append(this.addConstraints(this.jsonNode, null, null));
        }
        if (!this.jsonNode.has("source")) {
            consistsOfBuffer.append(")");
        }
        return consistsOfBuffer;
    }
}

