/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Optional;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.queries.Query;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static Logger logger = LoggerFactory.getLogger(QueryImpl.class);

    public String query(String query, boolean raw) throws InvalidQueryException {
        ODatabaseDocument oDatabaseDocument = null;
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            SecurityContext securityContext = ContextUtility.getCurrentSecurityContext();
            oDatabaseDocument = securityContext.getDatabaseDocument(SecurityContext.PermissionMode.READER);
            oDatabaseDocument.begin();
            logger.debug("Going to execute query '{} limit {}'", (Object)query);
            OResultSet resultSet = oDatabaseDocument.query(query, new Object[0]);
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = objectMapper.createArrayNode();
            while (resultSet.hasNext()) {
                OResult oResult = resultSet.next();
                try {
                    OElement element;
                    JsonNode jsonNode = null;
                    if (raw) {
                        if (oResult.isElement()) {
                            element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
                            jsonNode = OrientDBUtility.toJsonNode((OElement)element);
                        } else {
                            ObjectMapper mapper = new ObjectMapper();
                            jsonNode = mapper.readTree(OrientDBUtility.toJsonString((OResult)oResult));
                        }
                    } else {
                        element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getElement());
                        ElementManagement erManagement = ElementManagementUtility.getERManagement((SecurityContext)securityContext, (ODatabaseDocument)oDatabaseDocument, (OElement)element);
                        erManagement.setAsEntryPoint();
                        jsonNode = erManagement.serializeAsJsonNode();
                    }
                    arrayNode.add(jsonNode);
                }
                catch (ResourceRegistryException e) {
                    logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)OrientDBUtility.toJsonString((OResult)oResult), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                }
            }
            String string = objectMapper.writeValueAsString((Object)arrayNode);
            return string;
        }
        catch (Exception e) {
            throw new InvalidQueryException(e.getMessage());
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }
}

