/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.core.TreeNode;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.reference.properties.Metadata;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ServerContextCache;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.requests.ServerRequestInfo;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextCache
extends ContextCache {
    private static Logger logger = LoggerFactory.getLogger(ServerContextCache.class);
    protected List<Context> contextsNoMeta;
    protected Map<UUID, Context> uuidToContextNoMeta;
    protected List<Context> contextsMetaPrivacy;
    protected Map<UUID, Context> uuidToContextMetaPrivacy;
    protected boolean includeMeta;
    protected static ServerContextCache singleton;

    public static synchronized ServerContextCache getInstance() {
        if (singleton == null) {
            singleton = new ServerContextCache();
        }
        return singleton;
    }

    public void cleanCache() {
        this.cleanCache(Calendar.getInstance());
    }

    protected void cleanCache(Calendar now) {
        super.cleanCache(now);
        this.contextsNoMeta = null;
        this.uuidToContextNoMeta = new LinkedHashMap();
        this.contextsMetaPrivacy = null;
        this.uuidToContextMetaPrivacy = new LinkedHashMap();
    }

    public ServerContextCache() {
        this.cleanCache();
        this.initContextCacheRenewal();
    }

    public boolean isIncludeMeta() {
        return this.includeMeta;
    }

    public void setIncludeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
    }

    public void initContextCacheRenewal() {
        1 contextCacheRenewal = new /* Unavailable Anonymous Inner Class!! */;
        this.setContextCacheRenewal((ContextCacheRenewal)contextCacheRenewal);
    }

    protected boolean isUserAllowedToGetPrivacyMeta() {
        return ElementManagement.isUserAllowedToGetPrivacyMeta();
    }

    public synchronized List<Context> getContexts() throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        if (requestInfo.getUriInfo() != null && !requestInfo.includeMeta()) {
            return this.contextsNoMeta;
        }
        if (this.isUserAllowedToGetPrivacyMeta()) {
            return this.contexts;
        }
        return this.contextsMetaPrivacy;
    }

    public synchronized Context getContextByUUID(UUID uuid) throws ResourceRegistryException {
        this.refreshContextsIfNeeded();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        if (requestInfo.getUriInfo() != null && !requestInfo.includeMeta()) {
            return (Context)this.uuidToContextNoMeta.get(uuid);
        }
        if (this.isUserAllowedToGetPrivacyMeta()) {
            return (Context)this.uuidToContext.get(uuid);
        }
        return (Context)this.uuidToContextMetaPrivacy.get(uuid);
    }

    protected Metadata getMetadataForPrivacy(ObjectMapper objectMapper, Metadata metadata) {
        ObjectNode objectNode = (ObjectNode)objectMapper.valueToTree((Object)metadata);
        objectNode.replace("createdBy", (JsonNode)new TextNode("HIDDEN_FOR_PRIVACY"));
        objectNode.replace("lastUpdateBy", (JsonNode)new TextNode("HIDDEN_FOR_PRIVACY"));
        try {
            Metadata metadataWithPrivacy = (Metadata)objectMapper.treeToValue((TreeNode)objectNode, Metadata.class);
            return metadataWithPrivacy;
        }
        catch (JsonProcessingException e) {
            return metadata;
        }
    }

    protected void setContexts(List<Context> contexts) {
        Context contextMetaPrivacy;
        UUID uuid;
        this.contexts = new ArrayList();
        this.contextsNoMeta = new ArrayList();
        this.contextsMetaPrivacy = new ArrayList();
        ObjectMapper objectMapper = ElementMapper.getObjectMapper();
        for (Context c : contexts) {
            uuid = c.getID();
            ContextImpl contextWithMeta = new ContextImpl(c.getName());
            contextWithMeta.setMetadata(c.getMetadata());
            contextWithMeta.setID(uuid);
            this.contexts.add(contextWithMeta);
            this.uuidToContext.put(uuid, contextWithMeta);
            contextMetaPrivacy = new ContextImpl(c.getName());
            Metadata metadataWithPrivacy = this.getMetadataForPrivacy(objectMapper, c.getMetadata());
            contextMetaPrivacy.setMetadata(metadataWithPrivacy);
            contextMetaPrivacy.setID(uuid);
            this.contextsMetaPrivacy.add(contextMetaPrivacy);
            this.uuidToContextMetaPrivacy.put(uuid, contextMetaPrivacy);
            ContextImpl contextNoMeta = new ContextImpl(c.getName());
            contextNoMeta.setMetadata(null);
            contextNoMeta.setID(uuid);
            this.contextsNoMeta.add(contextNoMeta);
            this.uuidToContextNoMeta.put(uuid, contextNoMeta);
        }
        for (Context c : contexts) {
            uuid = c.getID();
            Context contextMeta = (Context)this.uuidToContext.get(uuid);
            contextMetaPrivacy = (Context)this.uuidToContextMetaPrivacy.get(uuid);
            Context contextNoMeta = (Context)this.uuidToContextNoMeta.get(uuid);
            if (c.getParent() == null) continue;
            IsParentOf ipo = c.getParent();
            UUID isParentOfParentUUID = ipo.getID();
            UUID contextParentUUID = ipo.getSource().getID();
            Context parentWithMeta = (Context)this.uuidToContext.get(contextParentUUID);
            IsParentOfImpl isParentOfWithMeta = new IsParentOfImpl(parentWithMeta, contextMeta);
            isParentOfWithMeta.setID(isParentOfParentUUID);
            isParentOfWithMeta.setMetadata(ipo.getMetadata());
            parentWithMeta.addChild((IsParentOf)isParentOfWithMeta);
            contextMeta.setParent((IsParentOf)isParentOfWithMeta);
            Context parentWithMetaPrivacy = (Context)this.uuidToContextMetaPrivacy.get(contextParentUUID);
            IsParentOfImpl isParentOfMetaPrivacy = new IsParentOfImpl(parentWithMetaPrivacy, contextMetaPrivacy);
            isParentOfMetaPrivacy.setID(isParentOfParentUUID);
            Metadata metadataWithPrivacy = this.getMetadataForPrivacy(objectMapper, ipo.getMetadata());
            isParentOfMetaPrivacy.setMetadata(metadataWithPrivacy);
            parentWithMetaPrivacy.addChild((IsParentOf)isParentOfMetaPrivacy);
            contextMetaPrivacy.setParent((IsParentOf)isParentOfMetaPrivacy);
            Context parentNoMeta = (Context)this.uuidToContextNoMeta.get(contextParentUUID);
            IsParentOfImpl isParentOfNoMeta = new IsParentOfImpl(parentNoMeta, contextNoMeta);
            isParentOfNoMeta.setMetadata(null);
            isParentOfNoMeta.setID(isParentOfParentUUID);
            parentNoMeta.addChild((IsParentOf)isParentOfNoMeta);
            contextNoMeta.setParent((IsParentOf)isParentOfNoMeta);
        }
        for (Context context : contexts) {
            uuid = context.getID();
            String fullName = this.getContextFullName(context);
            this.uuidToContextFullName.put(uuid, fullName);
            this.contextFullNameToUUID.put(fullName, uuid);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

