package org.gcube.informationsystem.resourceregistry.queries.json.base.entities;

import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Direction;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.queries.json.base.relations.JsonQueryConsistsOf;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class JsonQueryFacet extends JsonQueryEntity {

	public final static String _IN = "_in";
	
	public JsonQueryFacet(JsonNode jsonQuery) throws SchemaException, ResourceRegistryException {
		super(jsonQuery, AccessType.FACET);
		fieldNamesToRemove.add(JsonQueryFacet._IN);
	}

	@Override
	public StringBuffer analize(StringBuffer stringBuffer) throws SchemaException, ResourceRegistryException {
		StringBuffer newBuffer = new StringBuffer();
		
		int size = jsonNode.size();
		
		boolean entry = entryPoint;
		if(jsonNode.has(_IN)) {
			if(!entryPoint) {
				throw new InvalidQueryException(_IN + " property cannot be used in a facet if it is not the entry object");
			}
			JsonNode consistsOfNode = jsonNode.get(_IN);
			JsonQueryConsistsOf jsonQueryConsistsOf = new JsonQueryConsistsOf(consistsOfNode);
			jsonQueryConsistsOf.setEntryPoint(entryPoint);
			jsonQueryConsistsOf.setDirection(Direction.OUT);
			stringBuffer = jsonQueryConsistsOf.analize(stringBuffer);
			entry = false;
			
			/* Need to substract 1 from size otherwise
			 * it add WHERE at the end because _in 
			 * is not a property to be used for a WHERE compare
			 */
			--size;
		}
		
		newBuffer.append("SELECT FROM ");
		
		if(!entry) {
			newBuffer.append("( ");
			newBuffer.append("TRAVERSE inV(\"");
		}
		
		newBuffer.append(type);
		
		if(!entry) {
			newBuffer.append("\") FROM ( ");
			newBuffer.append(stringBuffer);
			newBuffer.append(")");
			newBuffer.append(")");
		}
		
		// Size 1 means that only '@class' property is present
		if(size > 1) {
			newBuffer.append(" WHERE ");
			newBuffer.append(addConstraints(jsonNode, null, null));
		}
		
		return newBuffer;
	}
	
	
}
