/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.GCubeSecret;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
public class RequestFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestFilter.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        JWTSecret secret;
        logger.trace("PreMatching RequestFilter");
        SecretManagerProvider.instance.reset();
        SecretManager secretManager = new SecretManager();
        String token = AccessTokenProvider.instance.get();
        if (token != null) {
            secret = new JWTSecret(token);
            secretManager.addSecret((Secret)secret);
        }
        if ((token = SecurityTokenProvider.instance.get()) != null) {
            secret = new GCubeSecret(token);
            secretManager.addSecret((Secret)secret);
        }
        SecretManagerProvider.instance.set(secretManager);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        logger.trace("ResponseFilter");
        SecretManagerProvider.instance.reset();
    }
}

