/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base.relations;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.relations.RelationType;
import org.gcube.informationsystem.utils.Utility;

public abstract class RelationElementManagement<SEM extends EntityElementManagement<? extends EntityElement, SET>, TEM extends EntityElementManagement<? extends EntityElement, TET>, SET extends EntityType, TET extends EntityType>
extends ElementManagement<OEdge, RelationType<SET, TET>> {
    public static final String IN = "in";
    public static final String OUT = "out";
    protected final Class<? extends EntityElement> sourceEntityClass;
    protected final Class<? extends EntityElement> targetEntityClass;
    protected SEM sourceEntityManagement;
    protected TEM targetEntityManagement;
    protected boolean includeSource;
    protected boolean includeTarget;

    protected RelationElementManagement(AccessType accessType, Class<? extends EntityElement> sourceEntityClass, Class<? extends EntityElement> targetEntityClass) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreKeys.add("source");
        this.ignoreKeys.add("target");
        this.ignoreKeys.add(IN.toLowerCase());
        this.ignoreKeys.add(OUT.toLowerCase());
        this.ignoreKeys.add(IN.toUpperCase());
        this.ignoreKeys.add(OUT.toUpperCase());
        this.sourceEntityClass = sourceEntityClass;
        this.targetEntityClass = targetEntityClass;
        this.sourceEntityManagement = null;
        this.targetEntityManagement = null;
        this.includeSource = true;
        this.includeTarget = true;
    }

    public void includeSource(boolean includeSource) {
        this.includeSource = includeSource;
    }

    public void includeTarget(boolean includeTarget) {
        this.includeTarget = includeTarget;
    }

    protected RelationElementManagement(AccessType accessType, Class<? extends EntityElement> sourceEntityClass, Class<? extends EntityElement> targetEntityClass, SecurityContext workingContext, ODatabaseDocument orientGraph) {
        this(accessType, sourceEntityClass, targetEntityClass);
        this.oDatabaseDocument = orientGraph;
        this.setWorkingContext(workingContext);
    }

    public SEM getSourceEntityManagement() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            OVertex source = ((OEdge)this.getElement()).getVertex(ODirection.OUT);
            this.sourceEntityManagement = this.newSourceEntityManagement();
            this.sourceEntityManagement.setElement((OElement)source);
        }
        this.sourceEntityManagement.setReload(this.reload);
        return (SEM)this.sourceEntityManagement;
    }

    public TEM getTargetEntityManagement() throws ResourceRegistryException {
        if (this.targetEntityManagement == null) {
            OVertex target = ((OEdge)this.getElement()).getVertex(ODirection.IN);
            this.targetEntityManagement = this.newTargetEntityManagement();
            this.targetEntityManagement.setElement((OElement)target);
        }
        this.targetEntityManagement.setReload(this.reload);
        return (TEM)this.targetEntityManagement;
    }

    public void setSourceEntityManagement(SEM sourceEntityManagement) {
        this.sourceEntityManagement = sourceEntityManagement;
    }

    public void setTargetEntityManagement(TEM targetEntityManagement) {
        this.targetEntityManagement = targetEntityManagement;
    }

    protected JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfAsJsonNode();
        try {
            if (this.includeSource) {
                EntityElementManagement sourceEntityManagement = this.getSourceEntityManagement();
                ((ObjectNode)relation).replace("source", sourceEntityManagement.serializeSelfAsJsonNode());
            }
            if (this.includeTarget) {
                EntityElementManagement targetEntityManagement = this.getTargetEntityManagement();
                ((ObjectNode)relation).replace("target", targetEntityManagement.serializeAsJsonNode());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected abstract void checksourceAndTargetEntityCompliancy() throws NotFoundException, AvailableInAnotherContextException, SchemaViolationException, ResourceRegistryException;

    protected OEdge reallyCreate() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            if (!this.jsonNode.has("source")) {
                throw new ResourceRegistryException("Error while creating relation. No source definition found");
            }
            UUID sourceUUID = Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode.get("source"));
            this.sourceEntityManagement = this.newSourceEntityManagement();
            this.sourceEntityManagement.setUUID(sourceUUID);
        }
        if (this.targetEntityManagement == null) {
            this.targetEntityManagement = this.newTargetEntityManagement();
            if (!this.jsonNode.has("target")) {
                throw new ResourceRegistryException("Error while creating " + this.typeName + ". No target definition found");
            }
            try {
                this.targetEntityManagement.setJsonNode(this.jsonNode.get("target"));
            }
            catch (SchemaException e) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("A ");
                errorMessage.append(this.typeName);
                errorMessage.append(" can be only created beetween ");
                errorMessage.append(this.sourceEntityManagement.getAccessType().getName());
                errorMessage.append(" and ");
                errorMessage.append(this.targetEntityManagement.getAccessType().getName());
                throw new SchemaViolationException(errorMessage.toString(), (Throwable)e);
            }
            try {
                this.targetEntityManagement.getElement();
            }
            catch (Exception e) {
                this.targetEntityManagement.internalCreate();
            }
        }
        OVertex source = (OVertex)this.getSourceEntityManagement().getElement();
        OVertex target = (OVertex)this.getTargetEntityManagement().getElement();
        this.checksourceAndTargetEntityCompliancy();
        this.logger.trace("Going to create {} beetween {} -> {}", new Object[]{this.typeName, source.toString(), target.toString()});
        this.element = this.oDatabaseDocument.newEdge(source, target, this.typeName);
        this.updateProperties(this.oClass, this.element, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        return (OEdge)this.element;
    }

    protected abstract SEM newSourceEntityManagement() throws ResourceRegistryException;

    protected abstract TEM newTargetEntityManagement() throws ResourceRegistryException;

    protected OEdge reallyUpdate() throws ResourceRegistryException {
        JsonNode target;
        this.logger.debug("Trying to update {} : {}", (Object)this.typeName, (Object)this.jsonNode);
        OEdge edge = (OEdge)this.getElement();
        this.updateProperties(this.oClass, (OElement)edge, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
        if (this.accessType.compareTo((Enum)AccessType.CONSISTS_OF) == 0 && (target = this.jsonNode.get("target")) != null) {
            this.targetEntityManagement = this.newTargetEntityManagement();
            this.targetEntityManagement.setJsonNode(target);
            this.targetEntityManagement.internalUpdate();
        }
        this.logger.info("{} {} successfully updated", (Object)this.typeName, (Object)this.jsonNode);
        return edge;
    }

    protected void reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {}. Related {}s will be detached.", new Object[]{this.accessType.getName(), this.uuid, this.targetEntityClass.getSimpleName()});
        this.affectedInstances.put(this.uuid, this.serializeAsAffectedInstance());
        ((OEdge)this.getElement()).delete();
    }
}

