/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.types.SchemaManagementImpl;
import org.gcube.informationsystem.types.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="types")
public class SchemaManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);

    @PUT
    @Path(value="{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(@PathParam(value="TYPE_NAME") String type, String json) throws SchemaException, ResourceRegistryException {
        logger.info("Requested {} creation with schema {}", (Object)type, (Object)json);
        CalledMethodProvider.instance.set("createType");
        AccessType accessType = null;
        Object firstGotType = null;
        try {
            Set superClasses = TypeMapper.deserializeTypeDefinition((String)json).getSuperClasses();
            if (superClasses.size() == 0) {
                throw new ResourceRegistryException("No superclasses defined");
            }
            Iterator iterator = superClasses.iterator();
            if (iterator.hasNext()) {
                String superClass = (String)iterator.next();
                accessType = ElementManagementUtility.getBaseAccessType((String)superClass);
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            String error = String.format("Cannot register %s schema. Superclass %s not found", type, firstGotType);
            throw new ResourceRegistryException(error);
        }
        SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
        schemaManagement.setTypeName(type);
        String ret = schemaManagement.create(json, accessType);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @GET
    @Path(value="{TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        logger.info("Requested Schema for type {}", (Object)type);
        CalledMethodProvider.instance.set("readType");
        SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
        return schemaManagement.read(type, polymorphic.booleanValue());
    }
}

