/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.model.entities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.EntityManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.relations.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

public abstract class EntityManagement<E extends EntityElement>
extends EntityElementManagement<E> {
    protected Map<String, RelationManagement> relationManagements;

    protected EntityManagement(AccessType accessType) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.relationManagements = new HashMap();
    }

    protected EntityManagement(AccessType accessType, SecurityContext workingContext, ODatabaseDocument orientGraph) {
        this(accessType);
        this.oDatabaseDocument = orientGraph;
        this.setWorkingContext(workingContext);
    }

    protected RelationManagement getRelationManagement(OEdge edge) throws ResourceRegistryException {
        String id = edge.getIdentity().toString();
        RelationManagement relationManagement = (RelationManagement)this.relationManagements.get(id);
        if (relationManagement == null) {
            relationManagement = ElementManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OEdge)edge);
            this.relationManagements.put(id, relationManagement);
        }
        return relationManagement;
    }

    protected void addToRelationManagement(RelationManagement relationManagement) throws ResourceRegistryException {
        OElement elem = relationManagement.getElement();
        String id = elem.getIdentity().toString();
        if (this.relationManagements.get(id) != null && this.relationManagements.get(id) != relationManagement) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Two different instance of ");
            errorMessage.append(relationManagement.getClass().getSimpleName());
            errorMessage.append(" point to the same ");
            errorMessage.append(elem.getClass().getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(errorMessage.toString());
        }
        this.relationManagements.put(id, relationManagement);
    }

    protected static JsonNode addRelation(JsonNode sourceResource, JsonNode relation, String arrayKey) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode relationArray = objectMapper.createArrayNode();
        try {
            if (sourceResource.has(arrayKey)) {
                relationArray = (ArrayNode)sourceResource.get(arrayKey);
            }
            relationArray.add(relation);
            ((ObjectNode)sourceResource).replace(arrayKey, (JsonNode)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    protected OVertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        this.logger.trace("Going to create {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = String.format("Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.", this.accessType.getName(), this.elementType);
                throw new ResourceRegistryException(error);
            }
            OVertex vertexEntity = this.oDatabaseDocument.newVertex(this.elementType);
            try {
                OVertex v;
                if (this.uuid != null && (v = (OVertex)this.getElement()) != null) {
                    String error = String.format("A %s with UUID %s already exist", this.elementType, this.uuid.toString());
                    throw this.getSpecificERAlreadyPresentException(error);
                }
            }
            catch (NotFoundException e) {
                try {
                    OElement el = ElementManagementUtility.getAnyElementByUUID((UUID)this.uuid);
                    String error = String.format("UUID %s is already used by another %s. This is not allowed.", this.uuid.toString(), el instanceof OVertex ? "Entity" : "Relation");
                    throw this.getSpecificERAvailableInAnotherContextException(error);
                }
                catch (NotFoundException notFoundException) {
                }
            }
            catch (AvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            if (this.accessType != AccessType.RESOURCE) {
                ElementManagement.updateProperties((OClass)this.oClass, (OElement)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            }
            this.logger.info("Created {} is {}", (Object)OVertex.class.getSimpleName(), (Object)Utility.toJsonString((OElement)((OVertex)this.element), (boolean)true));
            return (OVertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, e.getCause());
        }
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        targetSecurityContext.addElement(this.getElement(), this.oDatabaseDocument);
        Iterable edges = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        for (OEdge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.internalAddToContext(targetSecurityContext);
        }
        return true;
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        Iterable edges = ((OVertex)this.getElement()).getEdges(ODirection.OUT);
        for (OEdge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.internalRemoveFromContext(targetSecurityContext);
        }
        targetSecurityContext.removeElement(this.getElement(), this.oDatabaseDocument);
        return true;
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.elementType, polymorphic);
        for (ODocument vertex : iterable) {
            EntityManagement entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)((OVertex)vertex));
            try {
                JsonNode jsonNode = entityManagement.serializeAsJson();
                arrayNode.add(jsonNode);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public String reallyQuery(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        objectMapper = new ObjectMapper();
        arrayNode = objectMapper.createArrayNode();
        references /* !! */  = null;
        if (referenceUUID == null) ** GOTO lbl19
        element = ElementManagementUtility.getAnyElementByUUID((UUID)referenceUUID);
        if (element instanceof OVertex) {
            entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)((OVertex)element));
            elementType = entityManagement.getElementType();
            if (!(elementType.compareTo(referenceType) == 0 || polymorphic && this.getOClass().isSubClassOf(referenceType))) {
                error = String.format("Referenced instace with UUID %s is not a %s", new Object[]{referenceUUID, referenceType});
                throw new InvalidQueryException(error);
            }
            vertexes = new ArrayList<OVertex>();
            vertexes.add((OVertex)element);
            references /* !! */  = vertexes;
        } else {
            error = String.format("Referenced instace with UUID %s is not an %s", new Object[]{referenceUUID, "Entity"});
            throw new InvalidQueryException(error);
lbl19:
            // 1 sources

            references /* !! */  = this.oDatabaseDocument.browseClass(referenceType, polymorphic);
        }
        for (E r : references /* !! */ ) {
            v = (OVertex)r;
            directions = new ArrayList<ODirection>();
            if (direction == ODirection.BOTH) {
                directions.add(ODirection.IN);
                directions.add(ODirection.OUT);
            } else {
                directions.add(direction);
            }
            for (ODirection d : directions) {
                edges = v.getEdges(d.opposite(), new String[]{relationType});
                for (OEdge edge : edges) {
                    vertex = edge.getVertex(d);
                    if (v.getIdentity().compareTo((Object)vertex.getIdentity()) == 0) continue;
                    oClass = ElementManagement.getOClass((OElement)vertex);
                    if (!polymorphic || !oClass.isSubClassOf(this.elementType)) continue;
                    entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)vertex);
                    try {
                        if (referenceUUID != null && entityManagement.getUUID().compareTo(referenceUUID) == 0) continue;
                        jsonNode = entityManagement.serializeAsJson();
                        arrayNode.add(jsonNode);
                    }
                    catch (ResourceRegistryException e) {
                        this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                    }
                }
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyQueryTraversal(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        if (referenceUUID != null) {
            constraint.put("header.uuid", referenceUUID.toString());
        }
        StringBuilder selectStringBuilder = new StringBuilder("SELECT FROM (TRAVERSE ");
        selectStringBuilder.append(direction.name().toLowerCase());
        selectStringBuilder.append("E('");
        selectStringBuilder.append(relationType);
        selectStringBuilder.append("'), ");
        selectStringBuilder.append(direction.opposite().name().toLowerCase());
        selectStringBuilder.append("V('");
        selectStringBuilder.append(this.elementType);
        selectStringBuilder.append("') FROM (SELECT FROM ");
        selectStringBuilder.append(referenceType);
        boolean first = true;
        for (String key : constraint.keySet()) {
            if (first) {
                selectStringBuilder.append(" WHERE ");
                first = false;
            } else {
                selectStringBuilder.append(" AND ");
            }
            selectStringBuilder.append(key);
            selectStringBuilder.append("=");
            String value = constraint.get(key).trim();
            selectStringBuilder.append("'");
            selectStringBuilder.append(value);
            selectStringBuilder.append("'");
        }
        selectStringBuilder.append(" ))");
        if (!polymorphic) {
            selectStringBuilder.append(" WHERE @class='");
            selectStringBuilder.append(this.elementType);
            selectStringBuilder.append("'");
        }
        String select = selectStringBuilder.toString();
        this.logger.trace(select);
        OResultSet resultSet = this.oDatabaseDocument.command(select, new HashMap());
        while (resultSet.hasNext()) {
            OResult oResult = resultSet.next();
            OElement element = ElementManagement.getElementFromOptional((Optional)oResult.getElement());
            if (polymorphic) {
                OClass oClass = null;
                try {
                    if (element instanceof OEdge) continue;
                    oClass = ElementManagement.getOClass((OElement)element);
                }
                catch (Exception e) {
                    String error = String.format("Unable to detect type of %s. %s", element.toString(), "This is really strange and should not occur. Please contact the system administrator.");
                    this.logger.error(error, (Throwable)e);
                    throw new ResourceRegistryException(error);
                }
                if (oClass.isSubClassOf(this.elementType)) continue;
            }
            OVertex vertex = (OVertex)element;
            EntityManagement entityManagement = ElementManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (ODatabaseDocument)this.oDatabaseDocument, (OVertex)vertex);
            try {
                if (constraint.containsKey("header.uuid")) {
                    String uuid = constraint.get("header.uuid");
                    if (entityManagement.getUUID().compareTo(UUID.fromString(uuid)) == 0) continue;
                }
                JsonNode jsonNode = entityManagement.serializeAsJson();
                arrayNode.add(jsonNode);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String query(String relationType, String referenceType, UUID referenceUUID, ODirection direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        try {
            this.oDatabaseDocument = this.getWorkingContext().getDatabaseDocument(SecurityContext.PermissionMode.READER);
            AccessType relationAccessType = ElementManagementUtility.getBaseAccessType((String)relationType);
            if (relationAccessType != AccessType.IS_RELATED_TO && relationAccessType != AccessType.CONSISTS_OF) {
                String error = String.format("%s must be a relation type", relationType);
                throw new ResourceRegistryException(error);
            }
            AccessType referenceAccessType = ElementManagementUtility.getBaseAccessType((String)referenceType);
            if (referenceAccessType != AccessType.RESOURCE && referenceAccessType != AccessType.FACET) {
                String error = String.format("%s must be a en entity type", referenceType);
                throw new ResourceRegistryException(error);
            }
            if (constraint == null) {
                constraint = new HashMap<String, String>();
            }
            switch (1.$SwitchMap$org$gcube$informationsystem$base$reference$AccessType[this.accessType.ordinal()]) {
                case 1: {
                    if (relationAccessType != AccessType.CONSISTS_OF) break;
                    if (direction != ODirection.OUT) {
                        String error = String.format("%s can only goes %s from %s.", relationType, ODirection.OUT.name(), this.elementType);
                        throw new InvalidQueryException(error);
                    }
                    if (referenceAccessType == AccessType.FACET) break;
                    String error = String.format("%s can only has as target a %s. Provided instead %s : %s", relationType, "Facet", referenceAccessType, referenceType);
                    throw new InvalidQueryException(error);
                }
                case 2: {
                    if (relationAccessType == AccessType.CONSISTS_OF && direction == ODirection.IN && referenceAccessType == AccessType.RESOURCE) break;
                    String error = String.format("%s can only has %s %s from a %s.", this.elementType, ODirection.IN.name(), "ConsistsOf", "Resource");
                    throw new InvalidQueryException(error);
                }
            }
            String string = this.reallyQuery(relationType, referenceType, referenceUUID, direction, polymorphic, constraint);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
        }
    }
}

