/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.instances.base.properties;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.impl.properties.EncryptedImpl;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.instances.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.utils.EncryptedOrient;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyElementManagement {
    private static Logger logger = LoggerFactory.getLogger(PropertyElementManagement.class);
    public static final Set<String> PROPERTY_IGNORE_KEYS = new HashSet();
    public static final Set<String> PROPERTY_IGNORE_START_WITH_KEYS = new HashSet();
    public static final String AT = "@";
    public static final String UNDERSCORE = "_";

    public static ODocument getPropertyDocument(JsonNode jsonNode) throws ResourceRegistryException {
        ODocument oDocument = null;
        if (jsonNode.has("@class")) {
            String type = ElementManagement.getClassProperty((JsonNode)jsonNode);
            OClass oClass = null;
            oClass = ElementManagementUtility.getTypeSchema((String)type, (AccessType)AccessType.PROPERTY_ELEMENT);
            try {
                Header header = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)false);
                if (header != null) {
                    throw new ResourceRegistryException("A property object cannot have an Header");
                }
            }
            catch (Exception e) {
                logger.warn("An invalid Header has been provided. Anyway property object cannot have an Header.");
                throw new ResourceRegistryException("An property object cannot have an Header");
            }
            if (oClass.isSubClassOf("Encrypted")) {
                EncryptedOrient encrypted = new EncryptedOrient();
                oDocument = encrypted;
                oDocument.fromJSON(jsonNode.toString());
                try {
                    String contextEncryptedValue = encrypted.getEncryptedValue();
                    String decryptedValue = EncryptedImpl.decrypt((String)contextEncryptedValue);
                    encrypted.setDecryptedValue(decryptedValue, false);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Unable to manage Encrypted Property");
                }
                return oDocument;
            }
            oDocument = new ODocument(type);
        } else {
            oDocument = new ODocument();
        }
        return oDocument.fromJSON(jsonNode.toString());
    }

    public static JsonNode getJsonNode(ODocument oDocument) throws ResourceRegistryException {
        try {
            String type = oDocument.getClassName();
            String json = oDocument.toJSON("class");
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(json);
            if (type == null) {
                return jsonNode;
            }
            OClass oClass = ElementManagementUtility.getTypeSchema((String)type, (AccessType)AccessType.PROPERTY_ELEMENT);
            if (oClass.isSubClassOf("Encrypted")) {
                try {
                    EncryptedOrient encrypted = null;
                    String encryptedValue = (String)oDocument.getProperty("value");
                    if (oDocument instanceof EncryptedOrient) {
                        encrypted = (EncryptedOrient)oDocument;
                        if (encrypted.getDbEncryptedValue().compareTo(encryptedValue) == 0) {
                            ((ObjectNode)jsonNode).put("value", encrypted.getContextEncryptedValue());
                        }
                    } else {
                        encrypted = new EncryptedOrient();
                        oDocument = encrypted;
                        Key databaseKey = DatabaseEnvironment.getDatabaseKey();
                        String decryptedValue = EncryptedImpl.decrypt((String)encryptedValue, (Key)databaseKey);
                        String contextEncryptedValue = EncryptedImpl.encrypt((String)decryptedValue);
                        ((ObjectNode)jsonNode).put("value", contextEncryptedValue);
                    }
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Errror while managing Encrypted Property", (Throwable)e);
                }
            }
            return jsonNode;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    static {
        PROPERTY_IGNORE_START_WITH_KEYS.add(AT);
        PROPERTY_IGNORE_START_WITH_KEYS.add(UNDERSCORE);
    }
}

