package org.gcube.informationsystem.resourceregistry.types.relations;

import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.types.entities.ResourceTypeDefinitionManagement;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.relations.IsRelatedToType;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;

public class IsRelatedToTypeDefinitionManagement
		extends RelationTypeDefinitionManagement<ResourceTypeDefinitionManagement,ResourceType> {
	
	public IsRelatedToTypeDefinitionManagement() {
		super(ResourceType.class);
		this.elementType = IsRelatedToType.NAME;
	}
	
	public IsRelatedToTypeDefinitionManagement(SecurityContext securityContext, ODatabaseDocument oDatabaseDocument)
			throws ResourceRegistryException {
		super(securityContext, oDatabaseDocument, ResourceType.class);
		this.elementType = IsRelatedToType.NAME;
	}
	
	@Override
	protected ResourceTypeDefinitionManagement newTargetEntityManagement() throws ResourceRegistryException {
		return new ResourceTypeDefinitionManagement(getWorkingContext(), oDatabaseDocument);
	}
	
}
