/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.gcube.common.encryption.SymmetricKey;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.ContextSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SchemaSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SchemaActionImpl;
import org.gcube.informationsystem.utils.discovery.ISMDiscovery;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseEnvironment {
    private static Logger logger = LoggerFactory.getLogger(DatabaseEnvironment.class);
    protected static final String PROPERTY_FILENAME = "config.properties";
    private static final String HOST_VARNAME = "HOST";
    private static final String REMOTE_PROTOCOL;
    private static final String REMOTE_PROTOCOL_VARNAME = "REMOTE_PROTOCOL";
    private static final String DB;
    private static final String DB_VARNAME = "DB";
    private static final String ROOT_USERNAME;
    private static final String ROOT_USERNAME_VARNAME = "ROOT_USERNAME";
    private static final String ROOT_PASSWORD;
    private static final String ROOT_PASSWORD_VARNAME = "ROOT_PASSWORD";
    private static final String DEFAULT_ADMIN_USERNAME;
    private static final String DEFAULT_ADMIN_USERNAME_VARNAME = "DEFAULT_ADMIN_USERNAME";
    public static final String DEFAULT_ADMIN_ROLE = "admin";
    private static final String CHANGED_ADMIN_USERNAME;
    private static final String CHANGED_ADMIN_USERNAME_VARNAME = "CHANGED_ADMIN_USERNAME";
    private static final String DEFAULT_ADMIN_PASSWORD;
    private static final String DEFAULT_ADMIN_PASSWORD_VARNAME = "DEFAULT_ADMIN_PASSWORD";
    private static final String CHANGED_ADMIN_PASSWORD;
    private static final String CHANGED_ADMIN_PASSWORD_VARNAME = "CHANGED_ADMIN_PASSWORD";
    private static final String DEFAULT_CREATED_WRITER_USER_PASSWORD;
    private static final String DEFAULT_CREATED_WRITER_USER_PASSWORD_VARNAME = "DEFAULT_CREATED_WRITER_USER_PASSWORD";
    private static final String DEFAULT_CREATED_READER_USER_PASSWORD;
    private static final String DEFAULT_CREATED_READER_USER_PASSWORD_VARNAME = "DEFAULT_CREATED_READER_USER_PASSWORD";
    public static final Map<SecurityContext.PermissionMode, String> DEFAULT_PASSWORDS;
    private static final String HOSTS;
    private static final String SERVER_URI;
    public static final String DB_URI;
    public static final String O_RESTRICTED_CLASS = "ORestricted";
    public static final OStorageRemote.CONNECTION_STRATEGY CONNECTION_STRATEGY_PARAMETER;
    private static final String ADMIN_SECURITY_CONTEXT;
    public static final UUID ADMIN_SECURITY_CONTEXT_UUID;
    private static final String SCHEMA_SECURITY_CONTEXT;
    public static final UUID SCHEMA_SECURITY_CONTEXT_UUID;
    private static final String CONTEXT_SECURITY_CONTEXT;
    public static final UUID CONTEXT_SECURITY_CONTEXT_UUID;
    protected static final String DB_KEY_FILENAME_VARNAME = "DB_KEY_FILENAME";
    protected static final String DB_KEY_ALGORITHM_VARNAME = "DB_KEY_ALGORITHM";
    private static final Key KEY;

    protected static Key initDbKey(Properties properties) {
        try {
            logger.trace("Going to get properties required to load DB key");
            String keyFileName = properties.getProperty("DB_KEY_FILENAME");
            String keyAlgorithm = properties.getProperty("DB_KEY_ALGORITHM");
            logger.debug("Trying to load DB key from file with name {} created for algorithm {}", (Object)keyFileName, (Object)keyAlgorithm);
            URL keyFileURL = DatabaseEnvironment.class.getClassLoader().getResource(keyFileName);
            File keyFile = new File(keyFileURL.toURI());
            logger.debug("Trying to load DB key from file {} created for algorithm {}", (Object)keyFile.getAbsolutePath(), (Object)keyAlgorithm);
            Key key = SymmetricKey.loadKeyFromFile((File)keyFile, (String)keyAlgorithm);
            logger.info("DB Key has been properly initialized");
            return key;
        }
        catch (Throwable e) {
            logger.error("Error loading DB Key", e);
            throw new RuntimeException("Error loading DB Key. Unable to continue", e);
        }
    }

    protected static void setDateTimeFormat(ODatabaseSession oDatabaseSession) {
        oDatabaseSession.set(ODatabase.ATTRIBUTES.DATETIMEFORMAT, (Object)"yyyy-MM-dd HH:mm:ss.SSS Z");
    }

    private static boolean initGraphDB() throws Exception {
        OLogManager.instance().setWarnEnabled(false);
        OLogManager.instance().setErrorEnabled(false);
        OLogManager.instance().setInfoEnabled(false);
        OLogManager.instance().setDebugEnabled(false);
        logger.info("Connecting as {} to {}", (Object)ROOT_USERNAME, (Object)DB_URI);
        OrientDB orientDB = new OrientDB(SERVER_URI, ROOT_USERNAME, ROOT_PASSWORD, OrientDBConfig.defaultConfig());
        if (!orientDB.exists(DB)) {
            logger.info("The database {} does not exist. Going to create it.", (Object)DB_URI);
            orientDB.create(DB, ODatabaseType.PLOCAL);
            logger.trace("Connecting to newly created database {} as {} with default password", (Object)DB_URI, (Object)DEFAULT_ADMIN_USERNAME);
            ODatabasePool pool = new ODatabasePool(orientDB, DB, DEFAULT_ADMIN_USERNAME, DEFAULT_ADMIN_PASSWORD);
            ODatabaseSession oDatabaseSession = pool.acquire();
            DatabaseEnvironment.setDateTimeFormat((ODatabaseSession)oDatabaseSession);
            OMetadata oMetadata = oDatabaseSession.getMetadata();
            OSecurity oSecurity = oMetadata.getSecurity();
            logger.trace("Changing {} password", (Object)DEFAULT_ADMIN_USERNAME);
            OUser admin = oSecurity.getUser(DEFAULT_ADMIN_USERNAME);
            admin.setPassword(CHANGED_ADMIN_PASSWORD);
            admin.save();
            logger.trace("Creating new admin named '{}'", (Object)CHANGED_ADMIN_USERNAME);
            ORole adminRole = oSecurity.getRole("admin");
            OUser newAdminUser = oSecurity.createUser(CHANGED_ADMIN_USERNAME, CHANGED_ADMIN_PASSWORD, new ORole[]{adminRole});
            newAdminUser.save();
            for (SecurityContext.PermissionMode permissionMode : DEFAULT_PASSWORDS.keySet()) {
                OUser oUser = oSecurity.getUser(permissionMode.toString());
                oUser.setPassword((String)DEFAULT_PASSWORDS.get(permissionMode));
                oUser.save();
                logger.trace("Updating password for user {}", (Object)permissionMode.toString());
            }
            logger.trace("Setting Record-level Security (see https://orientdb.com/docs/last/Database-Security.html)");
            OSchema oSchema = oMetadata.getSchema();
            OClass oRestricted = oSchema.getClass("ORestricted");
            OClass v = oSchema.getClass("V");
            v.addSuperClass(oRestricted);
            OClass e = oSchema.getClass("E");
            e.addSuperClass(oRestricted);
            oDatabaseSession.commit();
            oDatabaseSession.close();
            pool.close();
            return true;
        }
        orientDB.close();
        return false;
    }

    public static Key getDatabaseKey() {
        return KEY;
    }

    static {
        CONNECTION_STRATEGY_PARAMETER = OStorageRemote.CONNECTION_STRATEGY.ROUND_ROBIN_CONNECT;
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = DatabaseEnvironment.class.getClassLoader().getResourceAsStream("config.properties");
            properties.load(input);
            HOSTS = properties.getProperty("HOST");
            REMOTE_PROTOCOL = properties.getProperty("REMOTE_PROTOCOL");
            DB = properties.getProperty("DB");
            SERVER_URI = REMOTE_PROTOCOL + HOSTS;
            DB_URI = SERVER_URI + "/" + DB;
            ROOT_USERNAME = properties.getProperty("ROOT_USERNAME");
            ROOT_PASSWORD = properties.getProperty("ROOT_PASSWORD");
            String changedAdminUsername = null;
            try {
                changedAdminUsername = properties.getProperty("CHANGED_ADMIN_USERNAME");
                if (changedAdminUsername == null) {
                    changedAdminUsername = DB;
                }
            }
            catch (Exception e) {
                changedAdminUsername = DB;
            }
            CHANGED_ADMIN_USERNAME = changedAdminUsername;
            CHANGED_ADMIN_PASSWORD = properties.getProperty("CHANGED_ADMIN_PASSWORD");
            DEFAULT_CREATED_WRITER_USER_PASSWORD = properties.getProperty("DEFAULT_CREATED_WRITER_USER_PASSWORD");
            DEFAULT_CREATED_READER_USER_PASSWORD = properties.getProperty("DEFAULT_CREATED_READER_USER_PASSWORD");
            DEFAULT_ADMIN_USERNAME = properties.getProperty("DEFAULT_ADMIN_USERNAME");
            DEFAULT_ADMIN_PASSWORD = properties.getProperty("DEFAULT_ADMIN_PASSWORD");
            DEFAULT_PASSWORDS = new HashMap();
            DEFAULT_PASSWORDS.put(SecurityContext.PermissionMode.WRITER, DEFAULT_CREATED_WRITER_USER_PASSWORD);
            DEFAULT_PASSWORDS.put(SecurityContext.PermissionMode.READER, DEFAULT_CREATED_READER_USER_PASSWORD);
        }
        catch (Exception e) {
            logger.error("Unable to load properties from {}", (Object)"config.properties");
            throw new RuntimeException("Unable to load properties", e);
        }
        ADMIN_SECURITY_CONTEXT = "00000000-0000-0000-0000-000000000000";
        ADMIN_SECURITY_CONTEXT_UUID = UUID.fromString(ADMIN_SECURITY_CONTEXT);
        SCHEMA_SECURITY_CONTEXT = "eeeeeeee-eeee-eeee-eeee-eeeeeeeeeeee";
        SCHEMA_SECURITY_CONTEXT_UUID = UUID.fromString(SCHEMA_SECURITY_CONTEXT);
        CONTEXT_SECURITY_CONTEXT = "ffffffff-ffff-ffff-ffff-ffffffffffff";
        CONTEXT_SECURITY_CONTEXT_UUID = UUID.fromString(CONTEXT_SECURITY_CONTEXT);
        try {
            boolean created = DatabaseEnvironment.initGraphDB();
            ContextUtility contextUtility = ContextUtility.getInstance();
            AdminSecurityContext adminSecurityContext = new AdminSecurityContext();
            contextUtility.addSecurityContext(adminSecurityContext.getUUID().toString(), (SecurityContext)adminSecurityContext);
            ContextSecurityContext contextSecurityContext = new ContextSecurityContext();
            contextUtility.addSecurityContext(contextSecurityContext.getUUID().toString(), (SecurityContext)contextSecurityContext);
            SchemaSecurityContext schemaSecurityContext = new SchemaSecurityContext();
            contextUtility.addSecurityContext(schemaSecurityContext.getUUID().toString(), (SecurityContext)schemaSecurityContext);
            if (created) {
                OrientGraphFactory factory = new OrientGraphFactory(DB_URI, CHANGED_ADMIN_USERNAME, CHANGED_ADMIN_PASSWORD).setupPool(1, 10);
                OrientGraph orientGraph = factory.getTx();
                adminSecurityContext.create(orientGraph);
                orientGraph.commit();
                orientGraph.shutdown();
                factory.close();
                contextSecurityContext.create();
                schemaSecurityContext.create();
                SchemaActionImpl schemaAction = new SchemaActionImpl();
                ISMDiscovery.manageISM((SchemaAction)schemaAction, (Package[])new Package[0]);
            }
            logger.info("Database Connection has been properly initialized");
        }
        catch (Throwable e) {
            logger.error("Error initializing database connection", e);
            throw new RuntimeException("Error initializing database connection", e);
        }
        KEY = DatabaseEnvironment.initDbKey((Properties)properties);
    }
}

