/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.impls.orient.OrientElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.activation.UnsupportedDataTypeException;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaManagementImpl
implements SchemaManagement {
    private static Logger logger = LoggerFactory.getLogger(SchemaManagementImpl.class);
    protected String typeName;

    protected static OClass getOClass(OSchema oSchema, String type) throws SchemaException {
        return oSchema.getClass(type);
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public static OClass getTypeSchema(ODatabaseSession oDatabaseSession, String type, AccessType accessType) throws SchemaException {
        OMetadata oMetadata = oDatabaseSession.getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        return SchemaManagementImpl.getTypeSchema((OSchema)oSchema, (String)type, (AccessType)accessType);
    }

    public static OClass getTypeSchema(OSchema oSchema, String type, AccessType accessType) throws SchemaException {
        try {
            OClass oClass = oSchema.getClass(type);
            if (oClass == null) {
                throw new SchemaNotFoundException(type + " was not registered");
            }
            if (accessType != null && type.compareTo(accessType.getName()) != 0 && !oClass.isSubClassOf(accessType.getName())) {
                throw new SchemaException(type + " is not a " + accessType.getName());
            }
            return oClass;
        }
        catch (SchemaNotFoundException snfe) {
            throw snfe;
        }
        catch (Exception e) {
            throw new SchemaException(e.getMessage());
        }
    }

    public static OClass getTypeSchema(String type, AccessType accessType) throws SchemaException, ResourceRegistryException {
        try {
            ExecutorService es = Executors.newSingleThreadExecutor();
            Future result = es.submit(new /* Unavailable Anonymous Inner Class!! */);
            return (OClass)result.get();
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected static TypeBinder.TypeDefinition getTypeDefinition(OClass oClass) throws SchemaException {
        ODocument oDocument = ((OClassImpl)oClass).toStream();
        String json = oDocument.toJSON();
        try {
            return TypeBinder.deserializeTypeDefinition((String)json);
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    protected static String getTypeDefinitionAsString(OClass oClass) throws SchemaException {
        try {
            TypeBinder.TypeDefinition typeDefinition = SchemaManagementImpl.getTypeDefinition((OClass)oClass);
            return TypeBinder.serializeTypeDefinition((TypeBinder.TypeDefinition)typeDefinition);
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
    }

    protected List<OClass> getSuperclassesAndCheckCompliancy(ODatabaseSession oDatabaseSession, TypeBinder.TypeDefinition typeDefinition, String baseType) throws SchemaException {
        Set superClasses = typeDefinition.getSuperClasses();
        if (baseType != null && (superClasses == null || superClasses.size() == 0)) {
            throw new RuntimeException(String.format("No Superclass found in schema %s. The Type Definition must extend %s", typeDefinition, baseType));
        }
        OMetadata oMetadata = oDatabaseSession.getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        ArrayList<OClass> oSuperclasses = new ArrayList<OClass>();
        for (String superClass : superClasses) {
            OClass oSuperClass = SchemaManagementImpl.getOClass((OSchema)oSchema, (String)superClass);
            if (oSuperClass == null) {
                throw new SchemaNotFoundException("Superclass " + superClass + " does not exists");
            }
            if (baseType != null && typeDefinition.getName().compareTo(baseType) != 0 && !oSuperClass.isSubClassOf(baseType)) {
                throw new RuntimeException(superClass + " is not a subsclass of " + baseType + ". Each Superclass MUST be a subclass of " + baseType);
            }
            oSuperclasses.add(oSuperClass);
        }
        return oSuperclasses;
    }

    protected String registerTypeSchema(String jsonSchema, AccessType baseType) throws SchemaException {
        try (ODatabaseSession oDatabaseSession = null;){
            logger.info("Trying to register {} {}", (Object)baseType.getName(), (Object)jsonSchema);
            ObjectMapper mapper = new ObjectMapper();
            TypeBinder.TypeDefinition typeDefinition = (TypeBinder.TypeDefinition)mapper.readValue(jsonSchema, TypeBinder.TypeDefinition.class);
            if (this.typeName.compareTo(typeDefinition.getName()) != 0) {
                String error = String.format("Provided type name path argument %s does not match with the type name in the definition %S. Please be coherent.", this.typeName, typeDefinition.getName());
                throw new SchemaCreationException(error);
            }
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseSession = adminSecurityContext.getDatabaseSession(SecurityContext.PermissionMode.WRITER);
            OMetadata oMetadata = oDatabaseSession.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass oClass = null;
            if (Entity.class.isAssignableFrom(baseType.getTypeClass())) {
                oClass = oDatabaseSession.createVertexClass(typeDefinition.getName());
            } else if (Relation.class.isAssignableFrom(baseType.getTypeClass())) {
                oClass = oDatabaseSession.createEdgeClass(typeDefinition.getName());
            } else if (Property.class.isAssignableFrom(baseType.getTypeClass())) {
                oClass = oSchema.createClass(typeDefinition.getName());
            } else {
                String error = String.format("Allowed superclass are %s, %s, %s, or any subclasses of them.", "Entity", "Relation", "Property");
                throw new SchemaCreationException(error);
            }
            try {
                String description = typeDefinition.getDescription();
                if (description != null && description.compareTo("") != 0) {
                    try {
                        oClass.setDescription(description);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to set description. This is an orient bug. See https://github.com/orientechnologies/orientdb/issues/7065");
                    }
                }
                try {
                    oClass.setAbstract(typeDefinition.isAbstract());
                }
                catch (Exception e) {
                    logger.error("Unable to set the Vertex Type {} as abstract. This is an OrientDB <= 2.2.12 bug. The Type will be created as it is not abstract.", (Object)typeDefinition.getName());
                }
                if (typeDefinition.getName().compareTo("Property") != 0) {
                    List oSuperclasses = this.getSuperclassesAndCheckCompliancy(oDatabaseSession, typeDefinition, baseType.getName());
                    oClass.setSuperClasses(oSuperclasses);
                }
                if (Resource.class.isAssignableFrom(baseType.getTypeClass())) {
                    Set propertyDefinitions = typeDefinition.getProperties();
                    if (propertyDefinitions != null && propertyDefinitions.size() > 0) {
                        throw new SchemaCreationException("A Resource cannot contains any properties.");
                    }
                } else {
                    for (TypeBinder.PropertyDefinition propertyDefinition : typeDefinition.getProperties()) {
                        OType oType = OType.getById((byte)propertyDefinition.getType().byteValue());
                        switch (2.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                            case 1: {
                                throw new UnsupportedDataTypeException(oType.name() + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                            }
                            case 2: {
                                throw new UnsupportedDataTypeException(oType.name() + " support is currently disabled due to OrientDB bug see https://github.com/orientechnologies/orientdb/issues/7354");
                            }
                        }
                        OProperty op = oClass.createProperty(propertyDefinition.getName(), oType);
                        op.setDescription(propertyDefinition.getDescription());
                        op.setMandatory(false);
                        op.setNotNull(false);
                        op.setReadonly(propertyDefinition.isReadonly());
                        op.setRegexp(propertyDefinition.getRegexp());
                        if (propertyDefinition.getLinkedClass() != null) {
                            OClass linkedClass = SchemaManagementImpl.getOClass((OSchema)oSchema, (String)propertyDefinition.getLinkedClass());
                            if (linkedClass == null) {
                                logger.trace("class {} not found in schema", (Object)propertyDefinition.getLinkedClass());
                                throw new Exception("class " + propertyDefinition.getLinkedClass() + " not found in schema");
                            }
                            if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                                throw new Exception("A Property Field cannot be an Entity or a Relation");
                            }
                            op.setLinkedClass(linkedClass);
                            continue;
                        }
                        if (propertyDefinition.getLinkedType() == null) continue;
                        op.setLinkedType(OType.getById((byte)propertyDefinition.getLinkedType().byteValue()));
                    }
                }
                OClass toBeSerializedOClass = oClass;
                if (oClass instanceof OrientElementType) {
                    toBeSerializedOClass = SchemaManagementImpl.getOClass((OSchema)oSchema, (String)typeDefinition.getName());
                }
                String ret = SchemaManagementImpl.getTypeDefinitionAsString((OClass)toBeSerializedOClass);
                logger.info("{} type registered successfully: {}", (Object)baseType.getName(), (Object)jsonSchema);
                String string = ret;
                return string;
            }
            catch (Exception e) {
                try {
                    oSchema.dropClass(typeDefinition.getName());
                    throw e;
                }
                catch (OSchemaException ex) {
                    if (ex.getMessage().contains("already exists")) {
                        throw new SchemaAlreadyPresentException((Throwable)ex);
                    }
                    throw new SchemaException((Throwable)ex);
                }
                catch (SchemaException e2) {
                    throw e2;
                }
                catch (Exception ex) {
                    throw new SchemaCreationException((Throwable)ex);
                }
            }
        }
    }

    protected String getSchema(String type, boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        try (ODatabaseSession oDatabaseSession = null;){
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            oDatabaseSession = adminSecurityContext.getDatabaseSession(SecurityContext.PermissionMode.WRITER);
            OMetadata oMetadata = oDatabaseSession.getMetadata();
            OSchema oSchema = oMetadata.getSchema();
            OClass baseOClass = SchemaManagementImpl.getTypeSchema((OSchema)oSchema, (String)type, null);
            ArrayList<TypeBinder.TypeDefinition> typeDefinitions = new ArrayList<TypeBinder.TypeDefinition>();
            typeDefinitions.add(SchemaManagementImpl.getTypeDefinition((OClass)baseOClass));
            if (includeSubtypes) {
                Collection subClasses = baseOClass.getAllSubclasses();
                for (OClass oClass : subClasses) {
                    typeDefinitions.add(SchemaManagementImpl.getTypeDefinition((OClass)oClass));
                }
            }
            String string = TypeBinder.serializeTypeDefinitions(typeDefinitions);
            return string;
        }
    }

    public String create(String jsonSchema, AccessType accessType) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, accessType);
    }

    public String read(String entityType, boolean includeSubtypes) throws SchemaNotFoundException, SchemaException {
        return this.getSchema(entityType, includeSubtypes);
    }

    public String update(String entityType, AccessType accessType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String delete(String entityType, AccessType accessType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

