/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.entity.Entity;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

public abstract class EntityManagement<E extends Entity>
extends ERManagement<E, Vertex> {
    protected Map<String, RelationManagement> relationManagements;

    protected EntityManagement(AccessType accessType) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreStartWithKeys.add("in_".toLowerCase());
        this.ignoreStartWithKeys.add("out_".toLowerCase());
        this.ignoreStartWithKeys.add("in_".toUpperCase());
        this.ignoreStartWithKeys.add("out_".toUpperCase());
        this.relationManagements = new HashMap();
    }

    protected EntityManagement(AccessType accessType, SecurityContext workingContext, OrientGraph orientGraph) {
        this(accessType);
        this.orientGraph = orientGraph;
        this.setWorkingContext(workingContext);
    }

    protected RelationManagement getRelationManagement(Edge edge) throws ResourceRegistryException {
        String id = edge.getId().toString();
        RelationManagement relationManagement = (RelationManagement)this.relationManagements.get(id);
        if (relationManagement == null) {
            relationManagement = ERManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Edge)edge);
            this.relationManagements.put(id, relationManagement);
        }
        return relationManagement;
    }

    protected void addToRelationManagement(RelationManagement relationManagement) throws ResourceRegistryException {
        Element elem = relationManagement.getElement();
        String id = elem.getId().toString();
        if (this.relationManagements.get(id) != null && this.relationManagements.get(id) != relationManagement) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("Two different instance of ");
            errorMessage.append(relationManagement.getClass().getSimpleName());
            errorMessage.append(" point to the same ");
            errorMessage.append(elem.getClass().getSimpleName());
            errorMessage.append(". ");
            errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(errorMessage.toString());
        }
        this.relationManagements.put(id, relationManagement);
    }

    protected static JSONObject addRelation(JSONObject sourceResource, JSONObject relation, String arrayKey) throws ResourceRegistryException {
        JSONArray relationArray = null;
        try {
            relationArray = sourceResource.has(arrayKey) ? sourceResource.getJSONArray(arrayKey) : new JSONArray();
            relationArray.put((Object)relation);
            sourceResource.putOpt(arrayKey, (Object)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    protected Vertex createVertex() throws EntityAlreadyPresentException, ResourceRegistryException {
        this.logger.trace("Going to create {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode});
        try {
            if (this.oClass.isAbstract()) {
                String error = String.format("Trying to create an instance of %s of type %s which is abstract. The operation will be aborted.", this.accessType.getName(), this.elementType);
                throw new ResourceRegistryException(error);
            }
            OrientVertex vertexEntity = this.orientGraph.addVertex((Object)("class:" + this.elementType));
            try {
                Vertex v;
                if (this.uuid != null && (v = (Vertex)this.getElement()) != null) {
                    String error = String.format("A %s with UUID %s already exist", this.elementType, this.uuid.toString());
                    throw this.getSpecificERAlreadyPresentException(error);
                }
            }
            catch (NotFoundException e) {
                try {
                    Element el = ERManagementUtility.getAnyElementByUUID((UUID)this.uuid);
                    String error = String.format("UUID %s is already used by another %s. This is not allowed.", this.uuid.toString(), el instanceof Vertex ? "Entity" : "Relation");
                    throw this.getSpecificERAvailableInAnotherContextException(error);
                }
                catch (NotFoundException notFoundException) {
                }
            }
            catch (AvailableInAnotherContextException e) {
                throw e;
            }
            this.element = vertexEntity;
            if (this.accessType != AccessType.RESOURCE) {
                ERManagement.updateProperties((OClass)this.oClass, (Element)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
            }
            this.logger.info("Created {} is {}", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)((OrientVertex)this.element), (boolean)true));
            return (Vertex)this.element;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), this.accessType.getName(), this.elementType, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.elementType + " with " + this.jsonNode, e.getCause());
        }
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        targetSecurityContext.addElement(this.getElement(), this.orientGraph);
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.internalAddToContext(targetSecurityContext);
        }
        return true;
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.internalRemoveFromContext(targetSecurityContext);
        }
        targetSecurityContext.removeElement(this.getElement(), this.orientGraph);
        return true;
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        JSONArray jsonArray = new JSONArray();
        Iterable iterable = this.orientGraph.getVerticesOfClass(this.elementType, polymorphic);
        for (Vertex vertex : iterable) {
            EntityManagement entityManagement = ERManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Vertex)vertex);
            try {
                JSONObject jsonObject = entityManagement.serializeAsJson();
                jsonArray.put((Object)jsonObject);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        return jsonArray.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String reallyQuery(String relationType, String referenceType, UUID referenceUUID, Direction direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        jsonArray = new JSONArray();
        references = null;
        if (referenceUUID == null) ** GOTO lbl19
        element = ERManagementUtility.getAnyElementByUUID((UUID)referenceUUID);
        if (element instanceof Vertex) {
            entityManagement = ERManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Vertex)((Vertex)element));
            orientVertexType = ((OrientVertex)element).getType();
            elementType = entityManagement.getElementType();
            if (!(elementType.compareTo(referenceType) == 0 || polymorphic && orientVertexType.isSubClassOf(referenceType))) {
                error = String.format("Referenced instace with UUID %s is not a %s", new Object[]{referenceUUID, referenceType});
                throw new InvalidQueryException(error);
            }
            vertexes = new ArrayList<Vertex>();
            vertexes.add((Vertex)element);
            references = vertexes;
        } else {
            error = String.format("Referenced instace with UUID %s is not an %s", new Object[]{referenceUUID, "Entity"});
            throw new InvalidQueryException(error);
lbl19:
            // 1 sources

            references = this.orientGraph.getVerticesOfClass(referenceType, polymorphic);
        }
        for (Vertex v : references) {
            directions = new ArrayList<Direction>();
            if (direction == Direction.BOTH) {
                directions.add(Direction.IN);
                directions.add(Direction.OUT);
            } else {
                directions.add(direction);
            }
            for (Direction d : directions) {
                edges = v.getEdges(d.opposite(), new String[]{relationType});
                for (Edge edge : edges) {
                    orientVertex = vertex = ((OrientEdge)edge).getVertex(d);
                    if (((OrientVertex)v).getIdentity().compareTo((Object)orientVertex.getIdentity()) == 0) continue;
                    if (this.elementType.compareTo(orientVertex.getLabel()) != 0) {
                        orientVertexType = orientVertex.getType();
                        if (!polymorphic || !orientVertexType.isSubClassOf(this.elementType)) continue;
                    }
                    entityManagement = ERManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Vertex)vertex);
                    try {
                        if (entityManagement.getUUID().compareTo(referenceUUID) == 0) continue;
                        jsonObject = entityManagement.serializeAsJson();
                        jsonArray.put((Object)jsonObject);
                    }
                    catch (ResourceRegistryException e) {
                        this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
                    }
                }
            }
        }
        return jsonArray.toString();
    }

    public String reallyQueryTraversal(String relationType, String referenceType, UUID referenceUUID, Direction direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        JSONArray jsonArray = new JSONArray();
        if (referenceUUID != null) {
            constraint.put("header.uuid", referenceUUID.toString());
        }
        StringBuilder selectStringBuilder = new StringBuilder("SELECT FROM (TRAVERSE ");
        selectStringBuilder.append(direction.name().toLowerCase());
        selectStringBuilder.append("E('");
        selectStringBuilder.append(relationType);
        selectStringBuilder.append("'), ");
        selectStringBuilder.append(direction.opposite().name().toLowerCase());
        selectStringBuilder.append("V('");
        selectStringBuilder.append(this.elementType);
        selectStringBuilder.append("') FROM (SELECT FROM ");
        selectStringBuilder.append(referenceType);
        boolean first = true;
        for (String key : constraint.keySet()) {
            if (first) {
                selectStringBuilder.append(" WHERE ");
                first = false;
            } else {
                selectStringBuilder.append(" AND ");
            }
            selectStringBuilder.append(key);
            selectStringBuilder.append("=");
            String value = constraint.get(key).trim();
            selectStringBuilder.append("'");
            selectStringBuilder.append(value);
            selectStringBuilder.append("'");
        }
        selectStringBuilder.append(" ))");
        if (!polymorphic) {
            selectStringBuilder.append(" WHERE @class='");
            selectStringBuilder.append(this.elementType);
            selectStringBuilder.append("'");
        }
        String select = selectStringBuilder.toString();
        this.logger.trace(select);
        OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
        Iterable elements = (Iterable)this.orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
        for (Element element : elements) {
            if (polymorphic) {
                OrientVertexType orientVertexType = null;
                try {
                    OrientElement orientElement = (OrientElement)element;
                    if (orientElement instanceof OrientEdge) continue;
                    orientVertexType = ((OrientVertex)orientElement).getType();
                }
                catch (Exception e) {
                    String error = String.format("Unable to detect type of %s. %s", element.toString(), "This is really strange and should not occur. Please contact the system administrator.");
                    this.logger.error(error, (Throwable)e);
                    throw new ResourceRegistryException(error);
                }
                if (orientVertexType.getName().compareTo(this.elementType) != 0 && !orientVertexType.isSubClassOf(this.elementType)) continue;
            }
            Vertex vertex = (Vertex)element;
            EntityManagement entityManagement = ERManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Vertex)vertex);
            try {
                if (constraint.containsKey("header.uuid")) {
                    String uuid = constraint.get("header.uuid");
                    if (entityManagement.getUUID().compareTo(UUID.fromString(uuid)) == 0) continue;
                }
                JSONObject jsonObject = entityManagement.serializeAsJson();
                jsonArray.put((Object)jsonObject);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        return jsonArray.toString();
    }

    public String query(String relationType, String referenceType, UUID referenceUUID, Direction direction, boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.READER);
            AccessType relationAccessType = ERManagementUtility.getBaseAccessType((String)relationType);
            if (relationAccessType != AccessType.IS_RELATED_TO && relationAccessType != AccessType.CONSISTS_OF) {
                String error = String.format("%s must be a relation type", relationType);
                throw new ResourceRegistryException(error);
            }
            AccessType referenceAccessType = ERManagementUtility.getBaseAccessType((String)referenceType);
            if (referenceAccessType != AccessType.RESOURCE && referenceAccessType != AccessType.FACET) {
                String error = String.format("%s must be a en entity type", referenceType);
                throw new ResourceRegistryException(error);
            }
            if (constraint == null) {
                constraint = new HashMap<String, String>();
            }
            switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$AccessType[this.accessType.ordinal()]) {
                case 1: {
                    if (relationAccessType != AccessType.CONSISTS_OF) break;
                    if (direction != Direction.OUT) {
                        String error = String.format("%s can only goes %s from %s.", relationType, Direction.OUT.name(), this.elementType);
                        throw new InvalidQueryException(error);
                    }
                    if (referenceAccessType == AccessType.FACET) break;
                    String error = String.format("%s can only has as target a %s. Provided instead %s : %s", relationType, "Facet", referenceAccessType, referenceType);
                    throw new InvalidQueryException(error);
                }
                case 2: {
                    if (relationAccessType == AccessType.CONSISTS_OF && direction == Direction.IN && referenceAccessType == AccessType.RESOURCE) break;
                    String error = String.format("%s can only has %s %s from a %s.", this.elementType, Direction.IN.name(), "ConsistsOf", "Resource");
                    throw new InvalidQueryException(error);
                }
            }
            String string = this.reallyQuery(relationType, referenceType, referenceUUID, direction, polymorphic, constraint);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }
}

