/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.dbinitialization;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.gcube.informationsystem.impl.utils.discovery.ISMDiscovery;
import org.gcube.informationsystem.impl.utils.discovery.SchemaAction;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.ContextSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SchemaSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.SchemaActionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseEnvironment {
    private static Logger logger = LoggerFactory.getLogger(DatabaseEnvironment.class);
    private static final String PROPERTY_FILENAME = "config.properties";
    private static final String HOST_VARNAME = "HOST";
    private static final String REMOTE_PROTOCOL;
    private static final String REMOTE_PROTOCOL_VARNAME = "REMOTE_PROTOCOL";
    private static final String DB;
    private static final String DB_VARNAME = "DB";
    private static final String ROOT_USERNAME;
    private static final String ROOT_USERNAME_VARNAME = "ROOT_USERNAME";
    private static final String ROOT_PASSWORD;
    private static final String ROOT_PASSWORD_VARNAME = "ROOT_PASSWORD";
    private static final String DEFAULT_ADMIN_USERNAME;
    private static final String DEFAULT_ADMIN_USERNAME_VARNAME = "DEFAULT_ADMIN_USERNAME";
    public static final String DEFAULT_ADMIN_ROLE = "admin";
    private static final String CHANGED_ADMIN_USERNAME;
    private static final String CHANGED_ADMIN_USERNAME_VARNAME = "CHANGED_ADMIN_USERNAME";
    private static final String DEFAULT_ADMIN_PASSWORD;
    private static final String DEFAULT_ADMIN_PASSWORD_VARNAME = "DEFAULT_ADMIN_PASSWORD";
    private static final String CHANGED_ADMIN_PASSWORD;
    private static final String CHANGED_ADMIN_PASSWORD_VARNAME = "CHANGED_ADMIN_PASSWORD";
    private static final String DEFAULT_CREATED_WRITER_USER_PASSWORD;
    private static final String DEFAULT_CREATED_WRITER_USER_PASSWORD_VARNAME = "DEFAULT_CREATED_WRITER_USER_PASSWORD";
    private static final String DEFAULT_CREATED_READER_USER_PASSWORD;
    private static final String DEFAULT_CREATED_READER_USER_PASSWORD_VARNAME = "DEFAULT_CREATED_READER_USER_PASSWORD";
    public static final Map<SecurityContext.PermissionMode, String> DEFAULT_PASSWORDS;
    private static final String HOSTS;
    private static final String SERVER_URI;
    public static final String DB_URI;
    private static final String DATABASE_TYPE = "graph";
    private static final String STORAGE_MODE = "plocal";
    public static final String O_RESTRICTED_CLASS = "ORestricted";
    public static final OStorageRemote.CONNECTION_STRATEGY CONNECTION_STRATEGY_PARAMETER;
    private static final String ALTER_DATETIME_FORMAT_QUERY_TEMPLATE = "ALTER DATABASE DATETIMEFORMAT \"%s\"";
    private static final String ADMIN_SECURITY_CONTEXT;
    public static final UUID ADMIN_SECURITY_CONTEXT_UUID;
    private static final String SCHEMA_SECURITY_CONTEXT;
    public static final UUID SCHEMA_SECURITY_CONTEXT_UUID;
    private static final String CONTEXT_SECURITY_CONTEXT;
    public static final UUID CONTEXT_SECURITY_CONTEXT_UUID;

    private static boolean initGraphDB() throws Exception {
        OLogManager.instance().setWarnEnabled(false);
        OLogManager.instance().setErrorEnabled(false);
        OLogManager.instance().setInfoEnabled(false);
        OLogManager.instance().setDebugEnabled(false);
        logger.info("Connecting as {} to {}", (Object)ROOT_USERNAME, (Object)DB_URI);
        OServerAdmin serverAdmin = new OServerAdmin(SERVER_URI).connect(ROOT_USERNAME, ROOT_PASSWORD);
        if (!serverAdmin.existsDatabase(DB, "plocal")) {
            logger.info("The database {} does not exist. Going to create it.", (Object)DB_URI);
            serverAdmin.createDatabase(DB, "graph", "plocal");
            logger.trace("Connecting to newly created database {} as {} with default password", (Object)DB_URI, (Object)DEFAULT_ADMIN_USERNAME);
            OrientGraphFactory factory = new OrientGraphFactory(DB_URI, DEFAULT_ADMIN_USERNAME, DEFAULT_ADMIN_PASSWORD).setupPool(1, 10);
            OrientGraphNoTx orientGraphNoTx = factory.getNoTx();
            String query = String.format("ALTER DATABASE DATETIMEFORMAT \"%s\"", "yyyy-MM-dd HH:mm:ss.SSS Z");
            OCommandSQL preparedQuery = new OCommandSQL(query);
            orientGraphNoTx.getRawGraph().command((OCommandRequest)preparedQuery).execute(new Object[0]);
            OMetadataDefault oMetadata = orientGraphNoTx.getRawGraph().getMetadata();
            OSecurity oSecurity = oMetadata.getSecurity();
            logger.trace("Changing {} password", (Object)DEFAULT_ADMIN_USERNAME);
            OUser admin = oSecurity.getUser(DEFAULT_ADMIN_USERNAME);
            admin.setPassword(CHANGED_ADMIN_PASSWORD);
            admin.save();
            logger.trace("Creating new admin named '{}'", (Object)CHANGED_ADMIN_USERNAME);
            ORole adminRole = oSecurity.getRole("admin");
            OUser newAdminUser = oSecurity.createUser(CHANGED_ADMIN_USERNAME, CHANGED_ADMIN_PASSWORD, new ORole[]{adminRole});
            newAdminUser.save();
            for (SecurityContext.PermissionMode permissionMode : DEFAULT_PASSWORDS.keySet()) {
                OUser oUser = oSecurity.getUser(permissionMode.toString());
                oUser.setPassword((String)DEFAULT_PASSWORDS.get(permissionMode));
                oUser.save();
                logger.trace("Updating password for user {}", (Object)permissionMode.toString());
            }
            logger.trace("Setting Record-level Security (see https://orientdb.com/docs/last/Database-Security.html)");
            OSchema oSchema = oMetadata.getSchema();
            OClass oRestricted = oSchema.getClass("ORestricted");
            OrientVertexType v = orientGraphNoTx.getVertexBaseType();
            v.addSuperClass(oRestricted);
            OrientEdgeType e = orientGraphNoTx.getEdgeBaseType();
            e.addSuperClass(oRestricted);
            orientGraphNoTx.shutdown();
            factory.close();
            return true;
        }
        serverAdmin.close();
        return false;
    }

    static {
        CONNECTION_STRATEGY_PARAMETER = OStorageRemote.CONNECTION_STRATEGY.ROUND_ROBIN_CONNECT;
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = DatabaseEnvironment.class.getClassLoader().getResourceAsStream("config.properties");
            properties.load(input);
            HOSTS = properties.getProperty("HOST");
            REMOTE_PROTOCOL = properties.getProperty("REMOTE_PROTOCOL");
            DB = properties.getProperty("DB");
            SERVER_URI = REMOTE_PROTOCOL + HOSTS;
            DB_URI = SERVER_URI + "/" + DB;
            ROOT_USERNAME = properties.getProperty("ROOT_USERNAME");
            ROOT_PASSWORD = properties.getProperty("ROOT_PASSWORD");
            String changedAdminUsername = null;
            try {
                changedAdminUsername = properties.getProperty("CHANGED_ADMIN_USERNAME");
                if (changedAdminUsername == null) {
                    changedAdminUsername = DB;
                }
            }
            catch (Exception e) {
                changedAdminUsername = DB;
            }
            CHANGED_ADMIN_USERNAME = changedAdminUsername;
            CHANGED_ADMIN_PASSWORD = properties.getProperty("CHANGED_ADMIN_PASSWORD");
            DEFAULT_CREATED_WRITER_USER_PASSWORD = properties.getProperty("DEFAULT_CREATED_WRITER_USER_PASSWORD");
            DEFAULT_CREATED_READER_USER_PASSWORD = properties.getProperty("DEFAULT_CREATED_READER_USER_PASSWORD");
            DEFAULT_ADMIN_USERNAME = properties.getProperty("DEFAULT_ADMIN_USERNAME");
            DEFAULT_ADMIN_PASSWORD = properties.getProperty("DEFAULT_ADMIN_PASSWORD");
            DEFAULT_PASSWORDS = new HashMap();
            DEFAULT_PASSWORDS.put(SecurityContext.PermissionMode.WRITER, DEFAULT_CREATED_WRITER_USER_PASSWORD);
            DEFAULT_PASSWORDS.put(SecurityContext.PermissionMode.READER, DEFAULT_CREATED_READER_USER_PASSWORD);
        }
        catch (Exception e) {
            logger.error("Unable to load properties from {}", (Object)"config.properties");
            throw new RuntimeException("Unable to load properties", e);
        }
        ADMIN_SECURITY_CONTEXT = "00000000-0000-0000-0000-000000000000";
        ADMIN_SECURITY_CONTEXT_UUID = UUID.fromString(ADMIN_SECURITY_CONTEXT);
        SCHEMA_SECURITY_CONTEXT = "eeeeeeee-eeee-eeee-eeee-eeeeeeeeeeee";
        SCHEMA_SECURITY_CONTEXT_UUID = UUID.fromString(SCHEMA_SECURITY_CONTEXT);
        CONTEXT_SECURITY_CONTEXT = "ffffffff-ffff-ffff-ffff-ffffffffffff";
        CONTEXT_SECURITY_CONTEXT_UUID = UUID.fromString(CONTEXT_SECURITY_CONTEXT);
        try {
            boolean created = DatabaseEnvironment.initGraphDB();
            ContextUtility contextUtility = ContextUtility.getInstance();
            AdminSecurityContext adminSecurityContext = new AdminSecurityContext();
            contextUtility.addSecurityContext(adminSecurityContext.getUUID().toString(), (SecurityContext)adminSecurityContext);
            ContextSecurityContext contextSecurityContext = new ContextSecurityContext();
            contextUtility.addSecurityContext(contextSecurityContext.getUUID().toString(), (SecurityContext)contextSecurityContext);
            SchemaSecurityContext schemaSecurityContext = new SchemaSecurityContext();
            contextUtility.addSecurityContext(schemaSecurityContext.getUUID().toString(), (SecurityContext)schemaSecurityContext);
            if (created) {
                OrientGraphFactory factory = new OrientGraphFactory(DB_URI, CHANGED_ADMIN_USERNAME, CHANGED_ADMIN_PASSWORD).setupPool(1, 10);
                OrientGraph orientGraph = factory.getTx();
                adminSecurityContext.create(orientGraph);
                orientGraph.commit();
                orientGraph.shutdown();
                factory.close();
                contextSecurityContext.create();
                schemaSecurityContext.create();
                SchemaActionImpl schemaAction = new SchemaActionImpl();
                ISMDiscovery.manageISM((SchemaAction)schemaAction, (Package[])new Package[0]);
            }
        }
        catch (Exception e) {
            logger.error("Error initializing database connection", (Throwable)e);
            throw new RuntimeException("Error initializing database connection", e);
        }
    }
}

