/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtility {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtility.class);
    private Map<String, UUID> contextUUIDs = new HashMap();
    private Map<UUID, SecurityContext> contexts = new HashMap();
    private static ContextUtility contextUtility;
    private static final InheritableThreadLocal<Boolean> hierarchicMode;

    public static ContextUtility getInstance() {
        if (contextUtility == null) {
            contextUtility = new ContextUtility();
        }
        return contextUtility;
    }

    private ContextUtility() {
    }

    public static InheritableThreadLocal<Boolean> getHierarchicMode() {
        return hierarchicMode;
    }

    private static String getCurrentContextFullName() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public static SecurityContext getCurrentSecurityContext() throws ResourceRegistryException {
        String fullName = ContextUtility.getCurrentContextFullName();
        if (fullName == null) {
            throw new ContextException("Null Token and Scope. Please set your token first.");
        }
        return ContextUtility.getInstance().getSecurityContextByFullName(fullName);
    }

    public static AdminSecurityContext getAdminSecurityContext() throws ResourceRegistryException {
        AdminSecurityContext adminSecurityContext = (AdminSecurityContext)ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.ADMIN_SECURITY_CONTEXT_UUID);
        return adminSecurityContext;
    }

    public synchronized void removeFromCache(UUID uuid, boolean fullNameOnly) throws ResourceRegistryException {
        for (String fullName : this.contextUUIDs.keySet()) {
            UUID uuidKey = (UUID)this.contextUUIDs.get(fullName);
            if (uuidKey.compareTo(uuid) != 0) continue;
            this.contextUUIDs.remove(fullName);
            if (!fullNameOnly) {
                this.contexts.remove(uuid);
            }
            return;
        }
    }

    public synchronized void addSecurityContext(SecurityContext securityContext) {
        this.contexts.put(securityContext.getUUID(), securityContext);
    }

    public synchronized void addSecurityContext(String fullname, SecurityContext securityContext) {
        this.contextUUIDs.put(fullname, securityContext.getUUID());
        this.contexts.put(securityContext.getUUID(), securityContext);
    }

    private synchronized SecurityContext getSecurityContextByFullName(String fullName) throws ContextException {
        try {
            SecurityContext securityContext = null;
            logger.trace("Trying to get {} for {}", (Object)SecurityContext.class.getSimpleName(), (Object)fullName);
            UUID uuid = (UUID)this.contextUUIDs.get(fullName);
            if (uuid == null) {
                logger.trace("{} for {} is not in cache. Going to get it", (Object)SecurityContext.class.getSimpleName(), (Object)fullName);
                Vertex contextVertex = this.getContextVertexByFullName(fullName);
                uuid = Utility.getUUID((Element)contextVertex);
                securityContext = this.getSecurityContextByUUID(uuid, contextVertex);
                this.addSecurityContext(fullName, securityContext);
            } else {
                securityContext = (SecurityContext)this.contexts.get(uuid);
            }
            return securityContext;
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Unable to restrive Context UUID from current Context", (Throwable)e);
        }
    }

    public SecurityContext getSecurityContextByUUID(UUID uuid) throws ResourceRegistryException {
        return this.getSecurityContextByUUID(uuid, null);
    }

    private Vertex getContextVertexByUUID(UUID uuid) throws ResourceRegistryException {
        return (Vertex)Utility.getElementByUUID((Graph)ContextUtility.getAdminSecurityContext().getGraph(SecurityContext.PermissionMode.READER), (String)"Context", (UUID)uuid, Vertex.class);
    }

    private SecurityContext getSecurityContextByUUID(UUID uuid, Vertex contextVertex) throws ResourceRegistryException {
        SecurityContext securityContext = (SecurityContext)this.contexts.get(uuid);
        if (securityContext == null) {
            securityContext = new SecurityContext(uuid);
            try {
                Vertex parentVertex;
                if (contextVertex == null) {
                    contextVertex = this.getContextVertexByUUID(uuid);
                }
                if ((parentVertex = (Vertex)contextVertex.getVertices(Direction.IN, new String[]{"IsParentOf"}).iterator().next()) != null) {
                    UUID parentUUID = Utility.getUUID((Element)parentVertex);
                    securityContext.setParentSecurityContext(this.getSecurityContextByUUID(parentUUID, parentVertex));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            this.contexts.put(uuid, securityContext);
        }
        return securityContext;
    }

    protected UUID getContextUUIDFromFullName(String fullName) throws ResourceRegistryException {
        Vertex contextVertex = this.getContextVertexByFullName(fullName);
        return Utility.getUUID((Element)contextVertex);
    }

    private Vertex getContextVertexByFullName(String fullName) throws ResourceRegistryException {
        logger.trace("Going to get {} {} with full name '{}'", new Object[]{"Context", Vertex.class.getSimpleName(), fullName});
        ScopeBean scopeBean = new ScopeBean(fullName);
        String name = scopeBean.name();
        String select = "SELECT FROM " + Context.class.getSimpleName() + " WHERE " + "name" + " = \"" + name + "\"";
        OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
        Iterable vertexes = (Iterable)ContextUtility.getAdminSecurityContext().getGraph(SecurityContext.PermissionMode.READER).command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
        if (vertexes == null || !vertexes.iterator().hasNext()) {
            throw new ContextNotFoundException("Error retrieving context with name " + fullName);
        }
        Iterator iterator = vertexes.iterator();
        Vertex context = (Vertex)iterator.next();
        logger.trace("Context Representing Vertex : {}", (Object)Utility.toJsonString((Element)context, (boolean)true));
        if (iterator.hasNext()) {
            throw new ContextNotFoundException("Found more than one context with name " + name + "but required the one with path" + fullName + ". Please Reimplement the query");
        }
        return context;
    }

    static {
        hierarchicMode = new /* Unavailable Anonymous Inner Class!! */;
    }
}

