/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextManagement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="context")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);
    public static final String ID_PATH_PARAM = "id";

    @PUT
    @Produces(value={"application/json;charset=UTF-8"})
    public Response create(String json) throws ContextAlreadyPresentException, ResourceRegistryException {
        logger.info("Requested to create {} with json {}", (Object)"Context", (Object)json);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setJSON(json);
        String ret = contextManagement.create();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)ret).type("application/json;charset=UTF-8").build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String read(@PathParam(value="id") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        ContextManagement contextManagement = new ContextManagement();
        if (uuid.compareTo("all") == 0) {
            logger.info("Requested to read all {}s", (Object)"Context");
            return contextManagement.all(false);
        }
        logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.read();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(String json) throws ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to update {} with json {} ", (Object)"Context", (Object)json);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setJSON(json);
        return contextManagement.update();
    }

    @DELETE
    @Path(value="{id}")
    public boolean delete(@PathParam(value="id") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        logger.info("Requested to delete {} with id {} ", (Object)"Context", (Object)uuid);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.delete();
    }
}

