/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.AccessType;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceManagement
extends EntityManagement<Resource> {
    private static Logger logger = LoggerFactory.getLogger(ResourceManagement.class);

    public ResourceManagement() {
        super(AccessType.RESOURCE);
    }

    public ResourceManagement(OrientGraph orientGraph) {
        super(AccessType.RESOURCE, orientGraph);
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JSONObject serializeAsJson() throws ResourceRegistryException {
        JSONObject sourceResource = this.serializeSelfOnly();
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = RelationManagement.getRelationManagement((OrientGraph)this.orientGraph, (Edge)edge);
            if (!(relationManagement instanceof ConsistsOfManagement)) continue;
            try {
                JSONObject consistsOf = relationManagement.serializeAsJson();
                sourceResource = ResourceManagement.addConsistsOf((JSONObject)sourceResource, (JSONObject)consistsOf);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. This is really strange and should not occur.", (Object)edge);
                throw e;
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. This is really strange and should not occur.", (Object)edge);
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return sourceResource;
    }

    protected static JSONObject addRelation(JSONObject sourceResource, JSONObject relation, AccessType accessType) throws ResourceRegistryException {
        String arrayKey = accessType.lowerCaseFirstCharacter();
        JSONArray relationArray = null;
        try {
            relationArray = sourceResource.has(arrayKey) ? sourceResource.getJSONArray(arrayKey) : new JSONArray();
            relationArray.put((Object)relation);
            sourceResource.putOpt(arrayKey, (Object)relationArray);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        return sourceResource;
    }

    public static JSONObject addConsistsOf(JSONObject sourceResource, JSONObject consistsOf) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JSONObject)sourceResource, (JSONObject)consistsOf, (AccessType)AccessType.CONSISTS_OF);
    }

    public static JSONObject addIsRelatedTo(JSONObject sourceResource, JSONObject isRelatedTo) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JSONObject)sourceResource, (JSONObject)isRelatedTo, (AccessType)AccessType.IS_RELATED_TO);
    }

    public Vertex reallyCreate() throws ResourceAlreadyPresentException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.createVertex();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode consistOfJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement(this.orientGraph);
                com.setJSON(consistOfJsonNode);
                com.reallyCreate((Vertex)this.element);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement(this.orientGraph);
                irtm.setJSON(relationJsonNode);
                irtm.reallyCreate((Vertex)this.element);
            }
        }
        return (Vertex)this.element;
    }

    public Vertex reallyUpdate() throws ResourceNotFoundException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.getElement();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement(this.orientGraph);
                com.setJSON(relationJsonNode);
                com.reallyCreateOrUdate();
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement(this.orientGraph);
                irtm.setJSON(relationJsonNode);
                irtm.reallyUpdate();
            }
        }
        ((OrientVertex)this.element).save();
        return (Vertex)this.element;
    }

    public boolean reallyDelete() throws ResourceNotFoundException, ResourceRegistryException {
        this.getElement();
        Iterable iterable = ((Vertex)this.element).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : iterable) {
            OrientEdgeType orientEdgeType = ((OrientEdge)edge).getType();
            IsRelatedToManagement relationManagement = null;
            if (orientEdgeType.isSubClassOf("IsRelatedTo")) {
                relationManagement = new IsRelatedToManagement(this.orientGraph);
            } else if (orientEdgeType.isSubClassOf("ConsistsOf")) {
                relationManagement = new ConsistsOfManagement(this.orientGraph);
            } else {
                logger.warn("{} is not a {} nor a {}. This is really strange ad should not occur. Please Investigate it.", new Object[]{Utility.toJsonString((Element)edge, (boolean)true), "IsRelatedTo", "ConsistsOf"});
            }
            if (relationManagement == null) continue;
            relationManagement.setElement((Element)edge);
            relationManagement.reallyDelete();
        }
        ((Vertex)this.element).remove();
        return true;
    }

    public String all(boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic, constraint);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String reallyGetAll(boolean polymorphic, Map<String, String> constraint) throws ResourceRegistryException {
        JSONArray jsonArray = new JSONArray();
        String relationType = constraint.get("relationType");
        constraint.remove("relationType");
        String facetType = constraint.get("facetType");
        constraint.remove("facetType");
        boolean first = true;
        StringBuilder selectStringBuilder = new StringBuilder("SELECT FROM (TRAVERSE inE('");
        selectStringBuilder.append(relationType);
        selectStringBuilder.append("'), outV('");
        selectStringBuilder.append(this.erType);
        selectStringBuilder.append("') FROM (SELECT FROM ");
        selectStringBuilder.append(facetType);
        for (String key : constraint.keySet()) {
            if (first) {
                selectStringBuilder.append(" WHERE ");
                first = false;
            } else {
                selectStringBuilder.append(" AND ");
            }
            selectStringBuilder.append(key);
            selectStringBuilder.append("=");
            String value = constraint.get(key).trim();
            selectStringBuilder.append("'");
            selectStringBuilder.append(value);
            selectStringBuilder.append("'");
        }
        selectStringBuilder.append(" ))");
        if (!polymorphic) {
            selectStringBuilder.append(" WHERE @class='");
            selectStringBuilder.append(this.erType);
            selectStringBuilder.append("'");
        }
        String select = selectStringBuilder.toString();
        logger.trace(select);
        OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
        Iterable elements = (Iterable)this.orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
        for (Element element : elements) {
            if (polymorphic) {
                OrientVertexType orientVertexType = null;
                try {
                    OrientElement orientElement = (OrientElement)element;
                    if (orientElement instanceof OrientEdge) continue;
                    orientVertexType = ((OrientVertex)orientElement).getType();
                }
                catch (Exception e) {
                    String error = String.format("Unable to detect type of %s. This is really strage please contact the administrator.", element.toString());
                    logger.error(error, (Throwable)e);
                    throw new ResourceRegistryException(error);
                }
                if (orientVertexType.getName().compareTo(this.erType) != 0 && !orientVertexType.isSubClassOf(this.erType)) continue;
            }
            Vertex vertex = (Vertex)element;
            EntityManagement entityManagement = EntityManagement.getEntityManagement((OrientGraph)this.orientGraph, (Vertex)vertex);
            try {
                JSONObject jsonObject = entityManagement.serializeAsJson();
                jsonArray.put((Object)jsonObject);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. This is really strange and should not occur.", (Object)vertex.toString());
            }
        }
        return jsonArray.toString();
    }
}

