/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.util.ODateHelper;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.AccessType;
import org.gcube.informationsystem.model.ER;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.EmbeddedMangement;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.utils.HeaderOrient;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ERManagement<ERType extends ER, El extends Element> {
    private static Logger logger = LoggerFactory.getLogger(ERManagement.class);
    public final String AT = "@";
    public final String UNDERSCORE = "_";
    protected final Set<String> ignoreKeys;
    protected final Set<String> ignoreStartWithKeys;
    protected Class<El> elementClass;
    protected AccessType accessType;
    protected OrientGraph orientGraph;
    protected UUID uuid;
    protected JsonNode jsonNode;
    protected OClass oClass;
    protected String erType;
    protected El element;

    public static ERManagement getERManagement(AccessType querableType) throws ResourceRegistryException {
        switch (1.$SwitchMap$org$gcube$informationsystem$model$AccessType[querableType.ordinal()]) {
            case 1: {
                return new FacetManagement();
            }
            case 2: {
                return new ResourceManagement();
            }
            case 3: {
                return new IsRelatedToManagement();
            }
            case 4: {
                return new ConsistsOfManagement();
            }
        }
        throw new ResourceRegistryException(String.format("%s is not querable", querableType.toString()));
    }

    public static ERManagement getERManagement(String type) throws ResourceRegistryException {
        OClass oClass = SchemaManagementImpl.getTypeSchema((String)type, null);
        ResourceManagement erManagement = null;
        if (oClass.isSubClassOf("Resource")) {
            erManagement = new ResourceManagement();
        } else if (oClass.isSubClassOf("Facet")) {
            erManagement = new FacetManagement();
        } else if (oClass.isSubClassOf("ConsistsOf")) {
            erManagement = new ConsistsOfManagement();
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            erManagement = new IsRelatedToManagement();
        }
        if (erManagement == null) {
            throw new ResourceRegistryException(String.format("%s is not querable", type.toString()));
        }
        erManagement.setElementType(type);
        return erManagement;
    }

    public static ERManagement getERManagement(OrientGraph orientGraph, Element element) throws ResourceRegistryException {
        if (element instanceof Vertex) {
            return EntityManagement.getEntityManagement((OrientGraph)orientGraph, (Vertex)((Vertex)element));
        }
        if (element instanceof Edge) {
            return RelationManagement.getRelationManagement((OrientGraph)orientGraph, (Edge)((Edge)element));
        }
        throw new ResourceRegistryException(String.format("%s is not a %s nor a %s", element.getClass().getSimpleName(), "Entity", "Relation"));
    }

    public static Element getAnyElementByUUID(UUID uuid) throws ERNotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, Vertex.class);
        }
        catch (ERNotFoundException e) {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, Edge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static ERManagement getERManagementFromUUID(OrientGraph orientGraph, UUID uuid) throws ResourceRegistryException {
        try {
            Element element = ERManagement.getAnyElementByUUID((UUID)uuid);
            return ERManagement.getERManagement((OrientGraph)orientGraph, (Element)element);
        }
        catch (Exception e) {
            throw new ResourceRegistryException(String.format("%s does not belong to an %s nor to a %s", uuid.toString(), "Entity", "Relation"));
        }
    }

    protected ERManagement(AccessType accessType) {
        this.accessType = accessType;
        this.ignoreKeys = new HashSet();
        this.ignoreStartWithKeys = new HashSet();
        this.ignoreStartWithKeys.add("@");
        this.ignoreStartWithKeys.add("_");
    }

    protected ERManagement(AccessType accessType, OrientGraph orientGraph) {
        this(accessType);
        this.orientGraph = orientGraph;
    }

    public void setUUID(UUID uuid) throws ResourceRegistryException {
        this.uuid = uuid;
        if (this.jsonNode != null) {
            this.checkUUIDMatch();
        }
    }

    public void setJSON(JsonNode jsonNode) throws ResourceRegistryException {
        this.jsonNode = jsonNode;
        this.checkJSON();
    }

    public void setJSON(String jsonRepresentation) throws ResourceRegistryException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.jsonNode = mapper.readTree(jsonRepresentation);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        this.checkJSON();
    }

    protected OClass getOClass() throws SchemaException {
        if (this.oClass == null) {
            if (this.element != null) {
                OrientElement orientElement = (OrientElement)this.element;
                OMetadataDefault oMetadata = orientElement.getGraph().getRawGraph().getMetadata();
                OSchema oSchema = oMetadata.getSchema();
                String type = orientElement.getRecord().getClassName();
                this.oClass = oSchema.getClass(type);
            } else {
                this.oClass = SchemaManagementImpl.getTypeSchema((String)this.erType, (AccessType)this.accessType);
            }
        }
        return this.oClass;
    }

    public void setElementType(String erType) throws ResourceRegistryException {
        this.erType = erType;
        if (erType == null || erType.compareTo("") == 0) {
            erType = this.accessType.getName();
        }
        if (this.jsonNode != null) {
            this.checkERMatch();
        }
    }

    protected void checkJSON() throws ResourceRegistryException {
        if (this.uuid == null) {
            try {
                this.uuid = org.gcube.informationsystem.impl.utils.Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode);
            }
            catch (Exception exception) {}
        } else {
            this.checkUUIDMatch();
        }
        if (this.erType == null) {
            this.erType = ERManagement.getClassProperty((JsonNode)this.jsonNode);
            this.getOClass();
        } else {
            this.checkERMatch();
        }
    }

    protected void checkERMatch() throws ResourceRegistryException {
        String type;
        if (this.jsonNode != null && (type = ERManagement.getClassProperty((JsonNode)this.jsonNode)) != null && type.compareTo(this.erType) != 0) {
            String error = String.format("Declared resourceType does not match with json representation %s!=%s", this.erType, type);
            logger.trace(error);
            throw new ResourceRegistryException(error);
        }
        this.getOClass();
    }

    protected void checkUUIDMatch() throws ResourceRegistryException {
        UUID resourceUUID;
        Header header = null;
        try {
            header = HeaderUtility.getHeader((JsonNode)this.jsonNode, (boolean)false);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        if (header != null && (resourceUUID = header.getUUID()).compareTo(this.uuid) != 0) {
            String error = String.format("UUID provided in header (%s) differs from the one (%s) used to identify the %s instance", resourceUUID.toString(), this.uuid.toString(), this.erType);
            throw new ResourceRegistryException(error);
        }
    }

    public JSONObject serializeSelfOnly() throws ResourceRegistryException {
        try {
            return this.toJSONObject();
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String serialize() throws ResourceRegistryException;

    public abstract JSONObject serializeAsJson() throws ResourceRegistryException;

    public abstract El reallyCreate() throws ERAlreadyPresentException, ResourceRegistryException;

    public abstract El reallyUpdate() throws ERNotFoundException, ResourceRegistryException;

    public abstract boolean reallyDelete() throws ERNotFoundException, ResourceRegistryException;

    public abstract boolean reallyAddToContext() throws ContextException, ResourceRegistryException;

    public abstract boolean reallyRemoveFromContext() throws ContextException, ResourceRegistryException;

    public void setElement(El element) throws ResourceRegistryException {
        if (element == null) {
            throw new ResourceRegistryException("Trying to set null " + this.elementClass.getSimpleName() + " in " + this);
        }
        this.element = element;
        this.uuid = HeaderUtility.getHeader(element).getUUID();
    }

    protected ERNotFoundException getSpecificElementNotFoundException(ERNotFoundException e) {
        switch (1.$SwitchMap$org$gcube$informationsystem$model$AccessType[this.accessType.ordinal()]) {
            case 2: {
                return new ResourceNotFoundException(e.getMessage(), e.getCause());
            }
            case 1: {
                return new FacetNotFoundException(e.getMessage(), e.getCause());
            }
            case 3: {
                return new RelationNotFoundException(e.getMessage(), e.getCause());
            }
            case 4: {
                return new RelationNotFoundException(e.getMessage(), e.getCause());
            }
        }
        return e;
    }

    protected ERAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        switch (1.$SwitchMap$org$gcube$informationsystem$model$AccessType[this.accessType.ordinal()]) {
            case 2: {
                return new ResourceAvailableInAnotherContextException(message);
            }
            case 1: {
                return new FacetAvailableInAnotherContextException(message);
            }
            case 3: {
                return new RelationAvailableInAnotherContextException(message);
            }
            case 4: {
                return new RelationAvailableInAnotherContextException(message);
            }
        }
        return new ERAvailableInAnotherContextException(message);
    }

    protected ERAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        switch (1.$SwitchMap$org$gcube$informationsystem$model$AccessType[this.accessType.ordinal()]) {
            case 2: {
                return new ResourceAlreadyPresentException(message);
            }
            case 1: {
                return new FacetAlreadyPresentException(message);
            }
            case 3: {
                return new RelationAlreadyPresentException(message);
            }
            case 4: {
                return new RelationAlreadyPresentException(message);
            }
        }
        return new ERAlreadyPresentException(message);
    }

    public El getElement() throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        if (this.element == null) {
            try {
                this.element = this.retrieveElement();
            }
            catch (ERNotFoundException e) {
                try {
                    this.retrieveElementFromAnyContext();
                    throw this.getSpecificERAvailableInAnotherContextException(this.erType == null ? this.accessType.getName() : this.erType + " with UUID " + this.uuid + " is available in another " + Context.class.getSimpleName());
                }
                catch (ERAvailableInAnotherContextException e1) {
                    throw e1;
                }
                catch (Exception e1) {
                    throw e;
                }
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return (El)this.element;
    }

    public El retrieveElement() throws ERNotFoundException, ResourceRegistryException {
        try {
            return (El)Utility.getElementByUUID((OrientBaseGraph)this.orientGraph, (String)(this.erType == null ? this.accessType.getName() : this.erType), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (ERNotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public El retrieveElementFromAnyContext() throws ERNotFoundException, ResourceRegistryException {
        try {
            return (El)Utility.getElementByUUIDAsAdmin((String)(this.erType == null ? this.accessType.getName() : this.erType), (UUID)this.uuid, (Class)this.elementClass);
        }
        catch (ERNotFoundException e) {
            throw this.getSpecificElementNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public abstract String reallyGetAll(boolean var1) throws ResourceRegistryException;

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean exists() throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            this.getElement();
            boolean bl = true;
            return bl;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String create() throws ERAlreadyPresentException, ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            this.element = this.reallyCreate();
            this.orientGraph.commit();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String read() throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            this.getElement();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public String update() throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        try {
            this.orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            this.element = this.reallyUpdate();
            this.orientGraph.commit();
            String string = this.serialize();
            return string;
        }
        catch (ResourceRegistryException e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean delete() throws ERNotFoundException, ERAvailableInAnotherContextException, ResourceRegistryException {
        logger.debug("Going to delete {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
        try {
            this.orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            boolean deleted = this.reallyDelete();
            if (deleted) {
                this.orientGraph.commit();
                logger.info("{} with UUID {} was successfully deleted.", (Object)this.accessType.getName(), (Object)this.uuid);
            } else {
                logger.info("{} with UUID {} was NOT deleted.", (Object)this.accessType.getName(), (Object)this.uuid);
                this.orientGraph.rollback();
            }
            boolean bl = deleted;
            return bl;
        }
        catch (ResourceRegistryException e) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean addToContext() throws ERNotFoundException, ContextException {
        logger.debug("Going to add {} with UUID {} to actual Context", (Object)this.accessType.getName(), (Object)this.uuid);
        try {
            this.orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            boolean added = this.reallyAddToContext();
            this.orientGraph.commit();
            logger.info("{} with UUID {} successfully added to actual Context", (Object)this.accessType.getName(), (Object)this.uuid);
            boolean bl = added;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} to actual Context", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public boolean removeFromContext() throws ERNotFoundException, ContextException {
        logger.debug("Going to remove {} with UUID {} from actual Context", (Object)this.accessType.getName(), (Object)this.uuid);
        try {
            this.orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            boolean removed = this.reallyRemoveFromContext();
            this.orientGraph.commit();
            logger.info("{} with UUID {} successfully removed from actual Context", (Object)this.accessType.getName(), (Object)this.uuid);
            boolean bl = removed;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unable to remove {} with UUID {} from actual Context", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }

    public static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    public static Object getObjectFromElement(JsonNode value) throws ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return EmbeddedMangement.getEmbeddedType((JsonNode)value);
            }
            case 2: {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator arrayElement = value.elements();
                while (arrayElement.hasNext()) {
                    JsonNode arrayNode = (JsonNode)arrayElement.next();
                    Object objectNode = ERManagement.getObjectFromElement((JsonNode)arrayNode);
                    if (objectNode == null) continue;
                    list.add(objectNode);
                }
                return list;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public static Map<String, Object> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWith) throws JsonProcessingException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (ignoreStartWith == null) {
            ignoreStartWith = new HashSet<String>();
        }
        Iterator fields = jsonNode.fields();
        block2: while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWith) {
                if (!key.startsWith(prefix)) continue;
                continue block2;
            }
            JsonNode value = (JsonNode)entry.getValue();
            Object object = null;
            try {
                object = ERManagement.getObjectFromElement((JsonNode)value);
                if (object == null) continue;
                map.put(key, object);
            }
            catch (ResourceRegistryException e) {
                logger.warn("An invalidy property has been provided. It will be ignored.");
            }
        }
        return map;
    }

    public static Element updateProperties(OClass oClass, Element element, JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWithKeys) throws ResourceRegistryException {
        Map properties;
        Set oldKeys = element.getPropertyKeys();
        if (element instanceof Vertex || element instanceof Edge) {
            try {
                properties = ERManagement.getPropertyMap((JsonNode)jsonNode, ignoreKeys, ignoreStartWithKeys);
            }
            catch (IOException e) {
                throw new ResourceRegistryException((Throwable)e);
            }
        } else {
            String error = String.format("Error while updating %s properties", element.toString());
            throw new ResourceRegistryException(error);
        }
        oldKeys.removeAll(properties.keySet());
        for (String key : properties.keySet()) {
            try {
                Object object = properties.get(key);
                if (!oClass.existsProperty(key)) {
                    boolean set = false;
                    if (object instanceof ODocument) {
                        ODocument oDocument = (ODocument)object;
                        ((OrientElement)element).setProperty(key, (Object)oDocument, OType.EMBEDDED);
                        set = true;
                    }
                    if (object instanceof Set) {
                        ((OrientElement)element).setProperty(key, object, OType.EMBEDDEDSET);
                        set = true;
                    }
                    if (object instanceof List) {
                        ((OrientElement)element).setProperty(key, object, OType.EMBEDDEDLIST);
                        set = true;
                    }
                    if (set) continue;
                    element.setProperty(key, object);
                    continue;
                }
                element.setProperty(key, object);
            }
            catch (Exception e) {
                String error = String.format("Error while setting property %s : %s (%s)", key, properties.get(key).toString(), e.getMessage());
                logger.error(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
        }
        block5: for (String key : oldKeys) {
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                continue block5;
            }
            element.removeProperty(key);
        }
        ((OrientElement)element).save();
        return element;
    }

    protected Object getPropertyForJson(String key, Object object) throws ResourceRegistryException {
        try {
            if (key.compareTo("header") == 0) {
                HeaderOrient headerOrient = HeaderUtility.getHeaderOrient((ODocument)((ODocument)object));
                JSONObject headerObject = new JSONObject(headerOrient.toJSON("class"));
                return headerObject;
            }
            if (this.ignoreKeys.contains(key)) {
                return null;
            }
            for (String prefix : this.ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                return null;
            }
            if (object instanceof ODocument) {
                String json = ((ODocument)object).toJSON("class");
                JSONObject jsonObject = new JSONObject(json);
                return jsonObject;
            }
            if (object instanceof Date) {
                OProperty oProperty = this.getOClass().getProperty(key);
                OType oType = oProperty.getType();
                DateFormat dateFormat = ODateHelper.getDateTimeFormatInstance();
                switch (1.$SwitchMap$com$orientechnologies$orient$core$metadata$schema$OType[oType.ordinal()]) {
                    case 1: {
                        dateFormat = ODateHelper.getDateFormatInstance();
                        break;
                    }
                    case 2: {
                        dateFormat = ODateHelper.getDateTimeFormatInstance();
                        break;
                    }
                }
                return dateFormat.format((Date)object);
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                JSONArray jsonArray = new JSONArray();
                for (Object o : collection) {
                    Object obj = this.getPropertyForJson("PLACEHOLDER", o);
                    jsonArray.put(obj);
                }
                return jsonArray;
            }
            return object.toString();
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + key + "=" + object.toString() + " in " + this.getElement().toString(), (Throwable)e);
        }
    }

    protected Collection<String> getSuperclasses() throws SchemaException {
        Collection allSuperClasses = this.getOClass().getAllSuperClasses();
        HashSet<String> superClasses = new HashSet<String>();
        for (OClass oSuperClass : allSuperClasses) {
            String name = oSuperClass.getName();
            if (name.compareTo("v".toUpperCase()) == 0 || name.compareTo("e".toUpperCase()) == 0 || name.compareTo("ORestricted") == 0) continue;
            superClasses.add(name);
        }
        return superClasses;
    }

    public JSONObject toJSONObject() throws ResourceRegistryException {
        try {
            OrientElement orientElement = (OrientElement)this.getElement();
            Map properties = orientElement.getProperties();
            for (String key : orientElement.getPropertyKeys()) {
                Object object = properties.get(key);
                if ((object = this.getPropertyForJson(key, object)) != null) {
                    properties.put(key, object);
                    continue;
                }
                properties.remove(key);
            }
            JSONObject jsonObject = new JSONObject(properties);
            String type = orientElement.getRecord().getClassName();
            jsonObject.put("@class", (Object)type);
            Collection superClasses = this.getSuperclasses();
            JSONArray jsonArray = new JSONArray(superClasses);
            jsonObject.put("@superClasses", (Object)jsonArray);
            return jsonObject;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Error while serializing " + this.getElement().toString(), (Throwable)e);
        }
    }
}

