/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.rest.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="er")
public class ERManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    public static final String ID_PATH_PARAM = "id";
    public static final String TYPE_PATH_PARAM = "type";
    public static final String SOURCE_ID_PATH_PARAM = "sourceId";
    public static final String TARGET_ID_PATH_PARAM = "targetId";

    @PUT
    @Path(value="facet/{type}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String createFacet(@PathParam(value="type") String type, String json) throws ResourceRegistryException {
        logger.info("requested facet creation for type {} defined by {} ", (Object)type, (Object)json);
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setElementType(type);
        facetManagement.setJSON(json);
        return facetManagement.create();
    }

    @POST
    @Path(value="facet/{id}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String updateFacet(@PathParam(value="id") String uuid, String json) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("requested facet update for id {} with {}", (Object)uuid, (Object)json);
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        facetManagement.setJSON(json);
        return facetManagement.update();
    }

    @DELETE
    @Path(value="facet/{id}")
    public boolean deleteFacet(@PathParam(value="id") String uuid) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("Requested to delete Facet with id {}", (Object)uuid);
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        return facetManagement.delete();
    }

    @PUT
    @Path(value="resource/{type}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String createResource(@PathParam(value="type") String type, String json) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("requested resource creation for type {} with json {}", (Object)type, (Object)json);
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setElementType(type);
        resourceManagement.setJSON(json);
        return resourceManagement.create();
    }

    @POST
    @Path(value="resource/{id}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String updateResource(@PathParam(value="id") String uuid, String json) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("requested resource update for id {} with {}", (Object)uuid, (Object)json);
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        resourceManagement.setJSON(json);
        return resourceManagement.update();
    }

    @DELETE
    @Path(value="resource/{id}")
    public boolean deleteResource(@PathParam(value="id") String uuid) throws ResourceNotFoundException, Exception {
        logger.info("requested resource deletion for id {}", (Object)uuid);
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        return resourceManagement.delete();
    }

    @PUT
    @Path(value="consistsOf/source/{sourceId}/target/{targetId}/{type}")
    @Produces(value={"application/json"})
    public String attachFacet(@PathParam(value="sourceId") String resourceUUID, @PathParam(value="targetId") String facetUUID, @PathParam(value="type") String type, String json) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        logger.info("requested to attach resource {} to facet {} ({} Type {}) with properties {}", new Object[]{resourceUUID, facetUUID, ConsistsOf.class.getSimpleName(), type, json});
        ConsistsOfManagement consistsOfManagement = new ConsistsOfManagement();
        consistsOfManagement.setElementType(type);
        consistsOfManagement.setJSON(json);
        return consistsOfManagement.create(UUID.fromString(resourceUUID), UUID.fromString(facetUUID));
    }

    @DELETE
    @Path(value="consistsOf/{id}")
    public boolean detachFacet(@PathParam(value="id") String consistOfUUID) throws ResourceRegistryException {
        logger.info("requested to detach {}", (Object)consistOfUUID);
        ConsistsOfManagement consistsOfManagement = new ConsistsOfManagement();
        consistsOfManagement.setUUID(UUID.fromString(consistOfUUID));
        return consistsOfManagement.delete();
    }

    @PUT
    @Path(value="isRelatedTo/source/{sourceId}/target/{targetId}/{type}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String attachResource(@PathParam(value="sourceId") String sourceResourceUUID, @PathParam(value="targetId") String targetResourceUUID, @PathParam(value="type") String type, String json) throws ResourceNotFoundException, ResourceRegistryException {
        logger.info("requested to attach source {} {} and target {} {} ({} Type {}) with properties {}", new Object[]{"Resource", sourceResourceUUID, "Resource", targetResourceUUID, IsRelatedTo.class.getSimpleName(), type, json});
        IsRelatedToManagement isRelatedToManagement = new IsRelatedToManagement();
        isRelatedToManagement.setElementType(type);
        isRelatedToManagement.setJSON(json);
        return isRelatedToManagement.create(UUID.fromString(sourceResourceUUID), UUID.fromString(targetResourceUUID));
    }

    @DELETE
    @Path(value="isRelatedTo/{id}")
    public boolean detachResource(@PathParam(value="id") String relatedToUUID) throws ResourceRegistryException {
        logger.info("requested to detach {}", (Object)relatedToUUID);
        IsRelatedToManagement isRelatedToManagement = new IsRelatedToManagement();
        isRelatedToManagement.setUUID(UUID.fromString(relatedToUUID));
        return isRelatedToManagement.delete();
    }

    @POST
    @Path(value="add/resource/{id}")
    public boolean addResourceToContext(@PathParam(value="id") String uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("requested to add {} with UUID {} to current context {}", new Object[]{"Resource", uuid, ContextUtility.getCurrentContext()});
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        return resourceManagement.addToContext();
    }

    @POST
    @Path(value="add/facet/{id}")
    public boolean addFacetToContext(@PathParam(value="id") String uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("requested to add {} with UUID {} to current context {}", new Object[]{"Facet", uuid, ContextUtility.getCurrentContext()});
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        return facetManagement.addToContext();
    }

    @POST
    @Path(value="remove/resource/{id}")
    public boolean removeResourceFromContext(@PathParam(value="id") String uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("requested to remove {} with UUID {} from current context {}", new Object[]{"Resource", uuid, ContextUtility.getCurrentContext()});
        ResourceManagement resourceManagement = new ResourceManagement();
        resourceManagement.setUUID(UUID.fromString(uuid));
        return resourceManagement.removeFromContext();
    }

    @POST
    @Path(value="remove/facet/{id}")
    public boolean removeFacetFromContext(@PathParam(value="id") String uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("requested to remove {} with UUID {} from current context {}", new Object[]{"Facet", uuid, ContextUtility.getCurrentContext()});
        FacetManagement facetManagement = new FacetManagement();
        facetManagement.setUUID(UUID.fromString(uuid));
        return facetManagement.removeFromContext();
    }
}

