/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElementType;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.types.TypeBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SchemaManagementImpl
implements SchemaManagement {
    private static Logger logger = LoggerFactory.getLogger(SchemaManagementImpl.class);

    protected static OClass getEntityOClass(OrientBaseGraph orientBaseGraph, String entityType) throws SchemaException {
        OMetadataDefault oMetadata = orientBaseGraph.getRawGraph().getMetadata();
        OSchema oSchema = oMetadata.getSchema();
        return oSchema.getClass(entityType);
    }

    protected static OClass getTypeSchema(OrientBaseGraph orientBaseGraph, String type, String baseType) throws SchemaNotFoundException {
        try {
            OClass oClass = SchemaManagementImpl.getEntityOClass((OrientBaseGraph)orientBaseGraph, (String)type);
            if (baseType != null && baseType.compareTo("Embedded") != 0 && !oClass.isSubClassOf(baseType)) {
                throw new SchemaException("The requested type is not a " + baseType);
            }
            return oClass;
        }
        catch (SchemaNotFoundException snfe) {
            throw snfe;
        }
        catch (Exception e) {
            throw new SchemaNotFoundException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OClass getTypeSchema(String type, String baseType) throws SchemaNotFoundException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            logger.debug("Getting {} Type {} schema", (Object)(baseType != null ? baseType : ""), (Object)type);
            orientGraphNoTx = orientGraphFactory.getNoTx();
            OClass oClass = SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraphNoTx, (String)type, (String)baseType);
            return oClass;
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    protected static String serializeOClass(OClass oClass) throws SchemaException {
        ODocument oDocument = ((OClassImpl)oClass).toStream();
        return oDocument.toJSON();
    }

    protected List<OClass> getSuperclassesAndCheckCompliancy(OrientGraphNoTx orientGraphNoTx, TypeBinder.TypeDefinition typeDefinition, String baseType) throws SchemaException {
        Set superClasses = typeDefinition.getSuperclasses();
        if (baseType != null && (superClasses == null || superClasses.size() == 0)) {
            throw new RuntimeException(String.format("No Superclass found in schema %s. The Type Definition must extend %s", typeDefinition, baseType));
        }
        ArrayList<OClass> oSuperclasses = new ArrayList<OClass>();
        for (String superClass : superClasses) {
            OClass oSuperClass = SchemaManagementImpl.getEntityOClass((OrientBaseGraph)orientGraphNoTx, (String)superClass);
            if (baseType != null && typeDefinition.getName().compareTo(baseType) != 0 && !oSuperClass.isSubClassOf(baseType)) {
                throw new RuntimeException(superClass + " is not a subsclass of " + baseType + ". Each Superclass MUST be a subclass of " + baseType);
            }
            oSuperclasses.add(oSuperClass);
        }
        return oSuperclasses;
    }

    protected String getTypeSchemaAsString(String type, String baseType) throws SchemaNotFoundException {
        try {
            OClass oClass = SchemaManagementImpl.getTypeSchema((String)type, (String)baseType);
            return SchemaManagementImpl.serializeOClass((OClass)oClass);
        }
        catch (Exception e) {
            throw new SchemaNotFoundException((Throwable)e);
        }
    }

    protected String registerTypeSchema(String jsonSchema, Class<?> baseType) throws SchemaException {
        OrientGraphFactory orientGraphFactory = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            logger.info("Trying to register {} {}", (Object)baseType.getSimpleName(), (Object)jsonSchema);
            ObjectMapper mapper = new ObjectMapper();
            TypeBinder.TypeDefinition typeDefinition = (TypeBinder.TypeDefinition)mapper.readValue(jsonSchema, TypeBinder.TypeDefinition.class);
            orientGraphNoTx = orientGraphFactory.getNoTx();
            OrientVertexType oClass = null;
            if (Entity.class.isAssignableFrom(baseType)) {
                oClass = orientGraphNoTx.createVertexType(typeDefinition.getName());
            } else if (Relation.class.isAssignableFrom(baseType)) {
                oClass = orientGraphNoTx.createEdgeType(typeDefinition.getName());
            } else if (Embedded.class.isAssignableFrom(baseType)) {
                ODatabaseDocumentTx oDatabaseDocumentTx = orientGraphNoTx.getRawGraph();
                OMetadataDefault oMetadata = oDatabaseDocumentTx.getMetadata();
                OSchema oSchema = oMetadata.getSchema();
                oClass = oSchema.createClass(typeDefinition.getName());
            }
            oClass.setDescription(typeDefinition.getDescription());
            try {
                oClass.setAbstract(typeDefinition.isAbstractType());
            }
            catch (Exception e) {
                logger.error("Unable to set the Vertex Type {} as abstract. This is an OrientDB <= 2.2.12 bug. The Type will be created as it is not abstarct.", (Object)typeDefinition.getName());
            }
            List oSuperclasses = this.getSuperclassesAndCheckCompliancy(orientGraphNoTx, typeDefinition, baseType == Embedded.class ? null : baseType.getSimpleName());
            oClass.setSuperClasses(oSuperclasses);
            if (Resource.class.isAssignableFrom(baseType)) {
                Set properties = typeDefinition.getProperties();
                if (properties != null && properties.size() > 0) {
                    throw new Exception("A Resource cannot contains any properties.");
                }
            } else {
                for (TypeBinder.Property property : typeDefinition.getProperties()) {
                    OProperty op = oClass.createProperty(property.getName(), OType.getById((byte)property.getType().byteValue()));
                    op.setDescription(property.getDescription());
                    op.setMandatory(false);
                    op.setNotNull(false);
                    op.setReadonly(property.isReadonly());
                    op.setRegexp(property.getRegexpr());
                    if (property.getLinkedClass() != null) {
                        OClass linkedClass = SchemaManagementImpl.getEntityOClass((OrientBaseGraph)orientGraphNoTx, (String)property.getLinkedClass());
                        if (linkedClass == null) {
                            logger.trace("class {} not found in schema", (Object)property.getLinkedClass());
                            throw new Exception("class " + property.getLinkedClass() + " not found in schema");
                        }
                        if (linkedClass.isEdgeType() || linkedClass.isVertexType()) {
                            throw new Exception("An Embedded Field cannot be an Entity or a Relation");
                        }
                        op.setLinkedClass(linkedClass);
                        continue;
                    }
                    if (property.getLinkedType() == null) continue;
                    op.setLinkedType(OType.getById((byte)property.getLinkedType().byteValue()));
                }
            }
            OrientVertexType toBeSerializedOClass = oClass;
            if (oClass instanceof OrientElementType) {
                toBeSerializedOClass = SchemaManagementImpl.getEntityOClass((OrientBaseGraph)orientGraphNoTx, (String)typeDefinition.getName());
            }
            String ret = SchemaManagementImpl.serializeOClass((OClass)toBeSerializedOClass);
            logger.info("{} type registered successfully: {}", (Object)baseType.getSimpleName(), (Object)jsonSchema);
            String string = ret;
            return string;
        }
        catch (Exception e) {
            throw new SchemaException((Throwable)e);
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    public String registerEntitySchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, Entity.class);
    }

    public String getEntitySchema(String entityType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(entityType, "Entity");
    }

    public String updateEntitySchema(String entityType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteEntitySchema(String entityType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerFacetSchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, Facet.class);
    }

    public String getFacetSchema(String facetType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(facetType, "Facet");
    }

    public String updateFacetSchema(String facetType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteFacetSchema(String facetType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerResourceSchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, Resource.class);
    }

    public String getResourceSchema(String resourceType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(resourceType, "Resource");
    }

    public String updateResourceSchema(String resourceType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteResourceSchema(String resourceType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerEmbeddedTypeSchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, Embedded.class);
    }

    public String getEmbeddedTypeSchema(String embeddedType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(embeddedType, null);
    }

    public String updateEmbeddedTypeSchema(String embeddedType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteEmbeddedTypeSchema(String embeddedType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerRelationSchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, Relation.class);
    }

    public String getRelationSchema(String relationType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(relationType, "Relation");
    }

    public String updateRelationSchema(String relationType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteRelationSchema(String relationType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerConsistOfSchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, ConsistsOf.class);
    }

    public String getConsistOfSchema(String consistOfType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(consistOfType, "ConsistsOf");
    }

    public String updateConsistOfSchema(String consistOfType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteConsistOfSchema(String consistOfType) throws SchemaNotFoundException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String registerRelatedToSchema(String jsonSchema) throws SchemaException {
        return this.registerTypeSchema(jsonSchema, IsRelatedTo.class);
    }

    public String getRelatedToSchema(String relatedToType) throws SchemaNotFoundException {
        return this.getTypeSchemaAsString(relatedToType, "IsRelatedTo");
    }

    public String updateRelatedToSchema(String relatedToType, String jsonSchema) throws SchemaNotFoundException, SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }

    public String deleteRelatedToSchema(String relatedToType) throws SchemaException {
        throw new UnsupportedOperationException("Not Yet implemented");
    }
}

