/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.Relation;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.utils.ContextUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityManagementImpl
implements EntityManagement {
    public static final Set<String> RELATION_IGNORE_KEYS = new HashSet();
    public static final Set<String> RELATION_IGNORE_START_WITH_KEYS;
    public static final Set<String> ENTITY_IGNORE_KEYS;
    public static final Set<String> ENTITY_IGNORE_START_WITH_KEYS;
    public static final Set<String> EMBEDDED_IGNORE_KEYS;
    public static final Set<String> EMBEDDED_IGNORE_START_WITH_KEYS;
    public static final String AT = "@";
    public static final String UNDERSCORE = "_";
    private static Logger logger;

    protected Vertex getEntity(OrientGraph orientGraph, UUID uuid, String entityType, Class<? extends Entity> entityClass) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            if (entityType == null || entityType.compareTo("") == 0) {
                if (Facet.class.isAssignableFrom(entityClass)) {
                    entityType = "Facet";
                }
                if (Resource.class.isAssignableFrom(entityClass)) {
                    entityType = "Resource";
                }
            }
            return (Vertex)Utility.getElementByUUID((OrientGraph)orientGraph, (String)entityType, (UUID)uuid, Vertex.class);
        }
        catch (ResourceRegistryException e) {
            if (Facet.class.isAssignableFrom(entityClass)) {
                throw new FacetNotFoundException(e.getMessage());
            }
            if (Resource.class.isAssignableFrom(entityClass)) {
                throw new ResourceNotFoundException(e.getMessage());
            }
            throw e;
        }
    }

    protected Vertex getEntity(OrientGraph orientGraph, JsonNode jsonNode, UUID uuid, Class<? extends Entity> entityClass) throws JsonParseException, JsonMappingException, IOException, FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        String classProperty = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
        SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraph, (String)classProperty, (String)classProperty);
        Header header = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)false);
        UUID resourceUUID = header.getUUID();
        Vertex vertex = this.getEntity(orientGraph, resourceUUID, classProperty, entityClass);
        return vertex;
    }

    public Edge getRelation(OrientGraph orientGraph, UUID uuid, String relationType, Class<? extends Relation> relationClass) throws ResourceRegistryException {
        try {
            if (relationType == null || relationType.compareTo("") == 0) {
                if (IsRelatedTo.class.isAssignableFrom(relationClass)) {
                    relationType = "IsRelatedTo";
                }
                if (ConsistsOf.class.isAssignableFrom(relationClass)) {
                    relationType = "ConsistsOf";
                }
            }
            return (Edge)Utility.getElementByUUID((OrientGraph)orientGraph, (String)relationType, (UUID)uuid, Edge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected Edge getRelation(OrientGraph orientGraph, JsonNode jsonNode, String relationType, Class<? extends Relation> relationClass) throws JsonParseException, JsonMappingException, IOException, ResourceRegistryException {
        if (relationType == null || relationType.compareTo("") == 0) {
            String error = String.format("Invalid %s type : %s", relationClass.getSimpleName(), relationType);
            throw new ResourceRegistryException(error);
        }
        String classProperty = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
        if (relationType.compareTo(classProperty) != 0) {
            SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraph, (String)relationType, (String)classProperty);
        }
        Header header = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)false);
        UUID relationUUID = header.getUUID();
        Edge edge = this.getRelation(orientGraph, relationUUID, relationType, relationClass);
        return edge;
    }

    private static String lowerCaseFirstCharacter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    private static String getClassProperty(JsonNode jsonNode) {
        if (jsonNode.has("@class")) {
            return jsonNode.get("@class").asText();
        }
        return null;
    }

    private static ODocument getEmbeddedType(JsonNode jsonNode) throws ResourceRegistryException {
        if (jsonNode.has("@class")) {
            String type = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            SchemaManagementImpl.getTypeSchema((String)type, (String)"Embedded");
            Header header = null;
            try {
                header = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)false);
            }
            catch (Exception e) {
                logger.warn("An invalid Header has been provided. An embedded object cannot have an Header.  It will be ignored.");
                throw new ResourceRegistryException("An embedded object cannot have an Header");
            }
            if (header != null) {
                logger.warn("An embedded object cannot have an Header. It will be ignored.");
                throw new ResourceRegistryException("An embedded object cannot have an Header");
            }
            ODocument oDocument = new ODocument(type);
            return oDocument.fromJSON(jsonNode.toString());
        }
        return null;
    }

    public static Object getObjectFromElement(JsonNode value) throws ResourceRegistryException {
        JsonNodeType jsonNodeType = value.getNodeType();
        switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
            case 1: {
                return EntityManagementImpl.getEmbeddedType((JsonNode)value);
            }
            case 2: {
                ArrayList<Object> array = new ArrayList<Object>();
                Iterator arrayElement = value.elements();
                while (arrayElement.hasNext()) {
                    JsonNode arrayNode = (JsonNode)arrayElement.next();
                    Object objectNode = EntityManagementImpl.getObjectFromElement((JsonNode)arrayNode);
                    if (objectNode == null) continue;
                    array.add(objectNode);
                }
                return array;
            }
            case 3: {
                break;
            }
            case 4: {
                return value.asBoolean();
            }
            case 5: {
                break;
            }
            case 6: {
                if (value.isDouble() || value.isFloat()) {
                    return value.asDouble();
                }
                if (value.isBigInteger() || value.isShort() || value.isInt()) {
                    return value.asInt();
                }
                if (!value.isLong()) break;
                return value.asLong();
            }
            case 7: {
                return value.asText();
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
        }
        return null;
    }

    public static Map<String, Object> getPropertyMap(JsonNode jsonNode, Set<String> ignoreKeys, Set<String> ignoreStartWith) throws JsonProcessingException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (ignoreStartWith == null) {
            ignoreStartWith = new HashSet<String>();
        }
        Iterator fields = jsonNode.fields();
        block2: while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String key = (String)entry.getKey();
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWith) {
                if (!key.startsWith(prefix)) continue;
                continue block2;
            }
            JsonNode value = (JsonNode)entry.getValue();
            Object object = null;
            try {
                object = EntityManagementImpl.getObjectFromElement((JsonNode)value);
                if (object == null) continue;
                map.put(key, object);
            }
            catch (ResourceRegistryException e) {
                logger.warn("An invalidy property has been provided. It will be ignored.");
            }
        }
        return map;
    }

    private Map<String, Object> getVertexProperties(JsonNode node) throws ResourceRegistryException {
        Map vertexProperties = null;
        try {
            vertexProperties = EntityManagementImpl.getPropertyMap((JsonNode)node, (Set)ENTITY_IGNORE_KEYS, (Set)ENTITY_IGNORE_START_WITH_KEYS);
        }
        catch (Exception e) {
            String error = "Error while parsing json to get Relation properties";
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        return vertexProperties;
    }

    private Map<String, Object> getEdgeProperties(JsonNode node) throws ResourceRegistryException {
        Map edgeProperties = null;
        try {
            edgeProperties = EntityManagementImpl.getPropertyMap((JsonNode)node, (Set)RELATION_IGNORE_KEYS, (Set)RELATION_IGNORE_START_WITH_KEYS);
        }
        catch (Exception e) {
            String error = "Error while parsing json to get Relation properties";
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        return edgeProperties;
    }

    private Element updateProperties(Element element, JsonNode jsonNode) throws ResourceRegistryException {
        Map properties;
        Set ignoreKeys = null;
        Set ignoreStartWithKeys = null;
        Set oldKeys = element.getPropertyKeys();
        if (element instanceof Vertex) {
            properties = this.getVertexProperties(jsonNode);
            ignoreKeys = ENTITY_IGNORE_KEYS;
            ignoreStartWithKeys = ENTITY_IGNORE_START_WITH_KEYS;
        } else if (element instanceof Edge) {
            properties = this.getEdgeProperties(jsonNode);
            ignoreKeys = RELATION_IGNORE_KEYS;
            ignoreStartWithKeys = RELATION_IGNORE_START_WITH_KEYS;
        } else {
            String error = String.format("Error while updating {} properties", element.toString());
            throw new ResourceRegistryException(error);
        }
        oldKeys.removeAll(properties.keySet());
        for (String key : properties.keySet()) {
            try {
                element.setProperty(key, properties.get(key));
            }
            catch (Exception e) {
                String error = String.format("Error while setting property %s : %s", key, properties.get(key).toString());
                logger.error(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
        }
        block3: for (String key : oldKeys) {
            if (ignoreKeys.contains(key)) continue;
            for (String prefix : ignoreStartWithKeys) {
                if (!key.startsWith(prefix)) continue;
                continue block3;
            }
            element.removeProperty(key);
        }
        return element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vertex getOrCreateTargetVertex(OrientGraph orientGraph, Class<? extends Relation> relation, JsonNode target) throws ResourceRegistryException {
        Header targetHeader = null;
        try {
            targetHeader = HeaderUtility.getHeader((JsonNode)target, (boolean)false);
        }
        catch (IOException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        Vertex targetVertex = null;
        if (targetHeader == null) {
            if (!ConsistsOf.class.isAssignableFrom(relation)) {
                String error = String.format("%s %s must already exist. The UUID must be provided in the %s of %s json respresentation", "target", "Resource", "Header", "IsRelatedTo");
                logger.error(error);
                throw new ResourceRegistryException(error);
            }
        } else {
            Class<Facet> targetClass = null;
            if (ConsistsOf.class.isAssignableFrom(relation)) {
                targetClass = Facet.class;
            } else if (IsRelatedTo.class.isAssignableFrom(relation)) {
                targetClass = Resource.class;
            } else {
                String error = String.format("%s Unsupported %s creation", relation.toString(), "Relation");
                logger.error(error);
                throw new ResourceRegistryException(error);
            }
            UUID targetUUID = targetHeader.getUUID();
            String entityType = EntityManagementImpl.getClassProperty((JsonNode)target);
            return this.getEntity(orientGraph, targetUUID, entityType, targetClass);
        }
        targetVertex = this.createVertexEntity(orientGraph, EntityManagementImpl.getClassProperty((JsonNode)target), Facet.class, target.toString());
        targetHeader = (Header)targetVertex.getProperty("header");
        return targetVertex;
    }

    private void createRelations(OrientGraph orientGraph, Vertex resource, JsonNode relationArray, Class<? extends Relation> relation) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        Iterator iterator = relationArray.elements();
        while (iterator.hasNext()) {
            JsonNode node = (JsonNode)iterator.next();
            JsonNode target = node.get("target");
            Vertex targetVertex = this.getOrCreateTargetVertex(orientGraph, relation, target);
            String relationType = EntityManagementImpl.getClassProperty((JsonNode)node);
            Map edgeProperties = this.getEdgeProperties(node);
            this.createEdgeRelation(orientGraph, resource, targetVertex, relationType, relation, edgeProperties);
        }
    }

    private Vertex createVertexEntity(OrientGraph orientGraph, String entityType, Class<? extends Entity> entity, String jsonRepresentation) throws ResourceRegistryException {
        logger.trace("Going to create {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), entity.getClass().getSimpleName(), entityType, jsonRepresentation});
        try {
            SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraph, (String)entityType, (String)entity.getSimpleName());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            String type = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            if (type != null && type.compareTo(entityType) != 0) {
                String error = String.format("Declared resourceType does not match with json representation %s!=%s", entityType, type);
                logger.trace(error);
                throw new ResourceRegistryException(error);
            }
            OrientVertex vertex = orientGraph.addVertex((Object)("class:" + entityType));
            Header entityHeader = HeaderUtility.getHeader((JsonNode)jsonNode, (boolean)true);
            if (entityHeader != null) {
                vertex.setProperty("header", (Object)entityHeader);
            } else {
                entityHeader = HeaderUtility.addHeader((Vertex)vertex, null);
            }
            if (!Resource.class.isAssignableFrom(entity)) {
                Map properties = this.getVertexProperties(jsonNode);
                for (String key : properties.keySet()) {
                    try {
                        vertex.setProperty(key, properties.get(key));
                    }
                    catch (Exception e) {
                        String error = String.format("Error while setting property %s : %s", key, properties.get(key).toString());
                        logger.error(error);
                        throw new ResourceRegistryException(error, (Throwable)e);
                    }
                }
            }
            ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)vertex);
            vertex.save();
            logger.info("Created {} is {}", (Object)Vertex.class.getSimpleName(), (Object)Utility.toJsonString((OrientElement)vertex, (boolean)true));
            return vertex;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{Vertex.class.getSimpleName(), entity.getClass().getSimpleName(), entityType, jsonRepresentation, e});
            throw new ResourceRegistryException("Error Creating " + entityType + " with " + jsonRepresentation, e.getCause());
        }
    }

    private Edge createEdgeRelation(OrientGraph orientGraph, UUID sourceUUID, Class<? extends Entity> sourceClass, UUID targetUUID, Class<? extends Entity> targetClass, String relationType, Class<? extends Relation> relationBaseClass, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        logger.trace("Trying to create {} with {}", (Object)relationType, (Object)jsonProperties);
        try {
            if (relationType == null || relationType.compareTo("") == 0) {
                throw new ResourceRegistryException(Relation.class.getSimpleName() + "type cannot be empty or null");
            }
            Vertex source = this.getEntity(orientGraph, sourceUUID, null, sourceClass);
            Vertex target = this.getEntity(orientGraph, targetUUID, null, targetClass);
            Map edgeProperties = new HashMap();
            if (jsonProperties != null && jsonProperties.compareTo("") != 0) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode jsonNode = mapper.readTree(jsonProperties);
                    edgeProperties = this.getEdgeProperties(jsonNode);
                }
                catch (Exception e) {
                    throw new ResourceRegistryException("Error while setting Relation Properties", (Throwable)e);
                }
            }
            return this.createEdgeRelation(orientGraph, source, target, relationType, relationBaseClass, edgeProperties);
        }
        catch (ResourceRegistryException e) {
            logger.trace("Error Creating {} with {}", new Object[]{relationType, jsonProperties, e});
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error Creating {} with {}", new Object[]{relationType, jsonProperties, e});
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    private Edge createEdgeRelation(OrientGraph orientGraph, Vertex source, Vertex target, String relationType, Class<? extends Relation> relationBaseClass, Map<String, Object> edgeProperties) throws ResourceRegistryException {
        logger.debug("Trying to create {} with properties {}", (Object)relationType, edgeProperties);
        if (relationType == null || relationType.compareTo("") == 0) {
            throw new ResourceRegistryException(Relation.class.getSimpleName() + " Type cannot be empty or null");
        }
        SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraph, (String)relationType, (String)relationBaseClass.getSimpleName());
        logger.trace("Creating {} ({}) beetween {} -> {}", new Object[]{Relation.class.getSimpleName(), relationType, Utility.toJsonString((Element)source, (boolean)true), Utility.toJsonString((Element)target, (boolean)true)});
        OrientEdge edge = orientGraph.addEdge(null, source, target, relationType);
        for (String key : edgeProperties.keySet()) {
            try {
                edge.setProperty(key, edgeProperties.get(key));
            }
            catch (Exception e) {
                String error = String.format("Error while setting property %s : %s", key, edgeProperties.get(key).toString());
                logger.error(error);
                throw new ResourceRegistryException(error, (Throwable)e);
            }
        }
        HeaderUtility.addHeader((Edge)edge, null);
        ContextUtility.addToActualContext((OrientGraph)orientGraph, (Edge)edge);
        edge.save();
        logger.info("{} with properties {} successfully created", (Object)relationType, edgeProperties);
        return edge;
    }

    private Edge updateRelation(OrientGraph orientGraph, JsonNode jsonNode, Class<? extends Relation> relationClass) throws ResourceRegistryException {
        logger.debug("Trying to update {} : {}", (Object)relationClass.getSimpleName(), (Object)jsonNode);
        try {
            String relationType = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
            if (relationType == null || relationType.compareTo("") == 0) {
                throw new ResourceRegistryException(Relation.class.getSimpleName() + " Type cannot be empty or null");
            }
            SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraph, (String)relationType, (String)relationClass.getSimpleName());
            UUID uuid = org.gcube.informationsystem.impl.utils.Utility.getUUIDFromJsonNode((JsonNode)jsonNode);
            Edge edge = (Edge)Utility.getElementByUUID((OrientGraph)orientGraph, (String)relationType, (UUID)uuid, Edge.class);
            edge = (Edge)this.updateProperties((Element)edge, jsonNode);
            ((OrientEdge)edge).save();
            JsonNode target = jsonNode.get("target");
            if (target != null) {
                UUID targetUUID = org.gcube.informationsystem.impl.utils.Utility.getUUIDFromJsonNode((JsonNode)target);
                this.updateFacet(orientGraph, targetUUID, target);
            }
            logger.info("{} {} successfully updated", (Object)relationType, (Object)jsonNode);
            return edge;
        }
        catch (ResourceRegistryException rre) {
            logger.error("Error Updating {} {} ", new Object[]{relationClass, jsonNode, rre});
            throw rre;
        }
        catch (Exception e) {
            logger.error("Error Creating {} {}", new Object[]{relationClass, jsonNode, e});
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String createFacet(String facetType, String jsonRepresentation) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex vertex = this.createVertexEntity(orientGraph, facetType, Facet.class, jsonRepresentation);
            String string = Utility.toJsonString((OrientElement)((OrientVertex)vertex), (boolean)false);
            return string;
        }
        catch (ResourceRegistryException e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String readFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.readFacet(uuid, "Facet");
    }

    public String readFacet(UUID uuid, String facetType) throws FacetNotFoundException, ResourceRegistryException {
        logger.debug("Going to read {} ({}) with UUID {}", new Object[]{"Facet", facetType, uuid});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex facet = this.getEntity(orientGraph, uuid, facetType, Facet.class);
            logger.info("{} of type {} with UUID {} is {}", new Object[]{"Facet", facetType, uuid, Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true)});
            String string = Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true);
            return string;
        }
        catch (FacetNotFoundException fnfe) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Facet", facetType, uuid, fnfe});
            throw fnfe;
        }
        catch (Exception e) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Facet", facetType, uuid, e});
            throw new ResourceRegistryException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    protected Vertex updateFacet(OrientGraph orientGraph, UUID uuid, JsonNode jsonNode) throws ResourceRegistryException {
        logger.debug("Trying to update {} with UUID {} usign {}", new Object[]{"Facet", uuid, jsonNode});
        String entityType = EntityManagementImpl.getClassProperty((JsonNode)jsonNode);
        Vertex facet = this.getEntity(orientGraph, uuid, entityType, Facet.class);
        facet = (Vertex)this.updateProperties((Element)facet, jsonNode);
        ((OrientVertex)facet).save();
        return facet;
    }

    public String updateFacet(UUID uuid, String jsonRepresentation) throws ResourceRegistryException {
        logger.debug("Trying to update {} with UUID {} usign {}", new Object[]{"Facet", uuid, jsonRepresentation});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            Vertex facet = this.updateFacet(orientGraph, uuid, jsonNode);
            orientGraph.commit();
            logger.info("{} with UUID {} has been updated {}", new Object[]{"Facet", uuid, Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)true)});
            String string = Utility.toJsonString((OrientElement)((OrientVertex)facet), (boolean)false);
            return string;
        }
        catch (ResourceRegistryException e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            logger.debug("Unable to update {} with UUID {} usign {}", new Object[]{"Facet", uuid, jsonRepresentation, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException("Error Updating Facet", e.getCause());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        logger.debug("Going to delete {} with UUID {}", (Object)"Facet", (Object)uuid);
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex facet = this.getEntity(orientGraph, uuid, "Facet", Facet.class);
            facet.remove();
            orientGraph.commit();
            logger.info("{} with UUID {} was successfully deleted.", (Object)"Facet", (Object)uuid);
        }
        catch (FacetNotFoundException fnfe) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Facet", uuid, fnfe});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Facet", uuid, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    public String attachFacet(UUID resourceUUID, UUID facetUUID, String consistOfType, String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        return this.createEdgeRelation(resourceUUID, Resource.class, facetUUID, Facet.class, consistOfType, ConsistsOf.class, jsonProperties);
    }

    public boolean detachFacet(UUID consistsOfUUID) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        logger.debug("Going to remove {} {} with UUID {}. {} will be detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, consistsOfUUID, "ConsistsOf", ConsistsOf.class);
            edge.remove();
            orientGraph.commit();
            logger.info("{} {} with UUID {} successfully removed. {} has been detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
        }
        catch (FacetNotFoundException fnfe) {
            logger.error("Unable to remove {} {} with UUID {}. {} has not been detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw fnfe;
        }
        catch (Exception e) {
            logger.error("Unable to remove {} {} with UUID {}. {} has not been detached from its {}.", new Object[]{"ConsistsOf", "Relation", consistsOfUUID, "Facet", "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    private String createEdgeRelation(UUID sourceUUID, Class<? extends Entity> sourceClass, UUID targetUUID, Class<? extends Entity> targetClass, String relationType, Class<? extends Relation> relationClass, String jsonProperties) throws ResourceRegistryException {
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.createEdgeRelation(orientGraph, sourceUUID, sourceClass, targetUUID, targetClass, relationType, relationClass, jsonProperties);
            orientGraph.commit();
            String string = Utility.toJsonString((OrientElement)((OrientEdge)edge), (boolean)false);
            return string;
        }
        catch (ResourceRegistryException e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String attachResource(UUID sourceResourceUuid, UUID targetResourceUuid, String isRelatedToType, String jsonProperties) throws ResourceNotFoundException, ResourceRegistryException {
        return this.createEdgeRelation(sourceResourceUuid, Resource.class, targetResourceUuid, Resource.class, isRelatedToType, IsRelatedTo.class, jsonProperties);
    }

    public boolean detachResource(UUID isRelatedToUUID) throws ResourceRegistryException {
        logger.debug("Going to remove {} {} with UUID {}. Related {}s will be detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Edge edge = this.getRelation(orientGraph, isRelatedToUUID, "IsRelatedTo", IsRelatedTo.class);
            edge.remove();
            orientGraph.commit();
            logger.info("{} {} with UUID {} successfully removed. Related {}s were detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
        }
        catch (ResourceRegistryException rre) {
            logger.error("Unable to remove {} {} with UUID. Related {}s will not be detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            logger.error("Unable to remove {} {} with UUID {}. Related {}s will not be detached.", new Object[]{"IsRelatedTo", "Relation", isRelatedToUUID, "Resource"});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
        return true;
    }

    private static String marshallResource(OrientGraph orientGraph, Vertex vertex) throws JSONException {
        JSONObject jsonObject = Utility.toJsonObject((OrientElement)((OrientVertex)vertex), (boolean)true);
        JSONArray consistsOfArray = new JSONArray();
        Iterable edges = vertex.getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            String edgeType = edge.getLabel();
            try {
                SchemaManagementImpl.getTypeSchema((OrientBaseGraph)orientGraph, (String)edgeType, (String)"ConsistsOf");
            }
            catch (SchemaNotFoundException e) {
                continue;
            }
            JSONObject jsonObjectEdge = Utility.toJsonObject((OrientElement)((OrientEdge)edge), (boolean)true);
            Vertex facetVertex = edge.getVertex(Direction.IN);
            jsonObjectEdge.put("target", (Object)Utility.toJsonObject((OrientElement)((OrientVertex)facetVertex), (boolean)true));
            consistsOfArray.put((Object)jsonObjectEdge);
        }
        jsonObject.put(EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf"), (Object)consistsOfArray);
        return jsonObject.toString();
    }

    public String createResource(String resourceType, String jsonRepresentation) throws ResourceRegistryException {
        logger.debug("Trying to create {} using {}", (Object)resourceType, (Object)jsonRepresentation);
        OrientGraph orientGraph = null;
        try {
            JsonNode jsonNodeArray;
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.createVertexEntity(orientGraph, resourceType, Resource.class, jsonRepresentation);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            String property = EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf");
            if (jsonNode.has(property)) {
                jsonNodeArray = jsonNode.get(property);
                this.createRelations(orientGraph, resource, jsonNodeArray, ConsistsOf.class);
            }
            if (jsonNode.has(property = EntityManagementImpl.lowerCaseFirstCharacter((String)"IsRelatedTo"))) {
                jsonNodeArray = jsonNode.get(property);
                this.createRelations(orientGraph, resource, jsonNodeArray, IsRelatedTo.class);
            }
            orientGraph.commit();
            String resourceString = EntityManagementImpl.marshallResource((OrientGraph)orientGraph, (Vertex)resource);
            logger.info("{} ({}) successfully created {}", new Object[]{"Resource", resourceType, resourceString});
            String string = resourceString;
            return string;
        }
        catch (ResourceRegistryException rre) {
            logger.error("Unable to create {} ({}) using {}", new Object[]{"Resource", resourceType, jsonRepresentation, rre});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            logger.error("Unable to create {} ({}) using {}", new Object[]{"Resource", resourceType, jsonRepresentation, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String readResource(UUID uuid) throws ResourceNotFoundException {
        return this.readResource(uuid, "Resource");
    }

    public String readResource(UUID uuid, String resourceType) throws ResourceNotFoundException {
        logger.debug("Going to read {} ({}) with UUID {}", new Object[]{"Resource", resourceType, uuid});
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            Vertex resource = this.getEntity(orientGraph, uuid, resourceType, Resource.class);
            logger.info("{} of type {} with UUID {} is {}", new Object[]{"Resource", resourceType, uuid, Utility.toJsonString((OrientElement)((OrientVertex)resource), (boolean)true)});
            String string = EntityManagementImpl.marshallResource((OrientGraph)orientGraph, (Vertex)resource);
            return string;
        }
        catch (ResourceNotFoundException rnfe) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Resource", resourceType, uuid, rnfe});
            throw rnfe;
        }
        catch (Exception e) {
            logger.error("Unable to read {} ({}) with UUID {}", new Object[]{"Resource", resourceType, uuid, e});
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public String updateResource(UUID resourceUUID, String jsonRepresentation) throws ResourceNotFoundException, ResourceRegistryException {
        logger.debug("Trying to update {} using {}", (Object)resourceUUID, (Object)jsonRepresentation);
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonRepresentation);
            Vertex resource = this.getEntity(orientGraph, jsonNode, resourceUUID, Resource.class);
            String property = EntityManagementImpl.lowerCaseFirstCharacter((String)"ConsistsOf");
            if (jsonNode.has(property)) {
                JsonNode jsonNodeArray = jsonNode.get(property);
                for (JsonNode relationJsonNode : jsonNodeArray) {
                    this.updateRelation(orientGraph, relationJsonNode, ConsistsOf.class);
                }
            }
            ((OrientVertex)resource).save();
            orientGraph.commit();
            String resourceString = EntityManagementImpl.marshallResource((OrientGraph)orientGraph, (Vertex)resource);
            logger.info("{} with UUID {} has been updated {}", new Object[]{"Resource", resourceUUID, Utility.toJsonString((OrientElement)((OrientVertex)resource), (boolean)true)});
            String string = resourceString;
            return string;
        }
        catch (ResourceRegistryException rre) {
            logger.debug("Unable to update {} with UUID {} usign {}", new Object[]{"Resource", resourceUUID, jsonRepresentation, rre});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rre;
        }
        catch (Exception e) {
            logger.debug("Unable to update {} with UUID {} usign {}", new Object[]{"Resource", resourceUUID, jsonRepresentation, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean deleteResource(UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        logger.debug("Going to delete {} with UUID {}", (Object)"Resource", (Object)uuid);
        OrientGraph orientGraph = null;
        try {
            orientGraph = ContextUtility.getActualSecurityContextGraph((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER);
            Vertex resource = this.getEntity(orientGraph, uuid, null, Resource.class);
            resource.remove();
            orientGraph.commit();
            logger.info("{} with UUID {} was successfully deleted.", (Object)"Resource", (Object)uuid);
            boolean bl = true;
            return bl;
        }
        catch (ResourceNotFoundException rnfe) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Resource", uuid, rnfe});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw rnfe;
        }
        catch (Exception e) {
            logger.error("Unable to delete {} with UUID {}", new Object[]{"Resource", uuid, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ResourceNotFoundException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    protected <E extends Entity> boolean addEntityToContext(Class<E> clz, UUID uuid) throws FacetNotFoundException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.debug("Going to add {} with UUID {} to actual Context", (Object)clz.getSimpleName(), (Object)uuid);
        OrientGraph orientGraph = null;
        try {
            orientGraph = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
            Vertex vertex = this.getEntity(orientGraph, uuid, null, clz);
            UUID contextUUID = ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)vertex);
            if (Resource.class.isAssignableFrom(clz)) {
                Iterable facets = vertex.getVertices(Direction.OUT, new String[]{"ConsistsOf"});
                for (Vertex facet : facets) {
                    ContextUtility.addToActualContext((OrientGraph)orientGraph, (Vertex)facet);
                }
            }
            orientGraph.commit();
            logger.info("{} with UUID {} successfully added to actual Context with UUID {}", new Object[]{clz.getSimpleName(), uuid, contextUUID});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} successfully added to actual Context", new Object[]{clz.getSimpleName(), uuid, e});
            if (orientGraph != null) {
                orientGraph.rollback();
            }
            throw new ContextException(e.getMessage());
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public boolean addResourceToContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addEntityToContext(Resource.class, uuid);
    }

    public boolean addFacetToContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addEntityToContext(Facet.class, uuid);
    }

    static {
        RELATION_IGNORE_KEYS.add("header");
        RELATION_IGNORE_KEYS.add("target");
        RELATION_IGNORE_KEYS.add("source");
        RELATION_IGNORE_KEYS.add("in".toLowerCase());
        RELATION_IGNORE_KEYS.add("out".toLowerCase());
        RELATION_IGNORE_KEYS.add("in".toUpperCase());
        RELATION_IGNORE_KEYS.add("out".toUpperCase());
        RELATION_IGNORE_START_WITH_KEYS = new HashSet();
        RELATION_IGNORE_START_WITH_KEYS.add("@");
        RELATION_IGNORE_START_WITH_KEYS.add("_");
        ENTITY_IGNORE_KEYS = new HashSet();
        ENTITY_IGNORE_KEYS.add("header");
        ENTITY_IGNORE_START_WITH_KEYS = new HashSet();
        ENTITY_IGNORE_START_WITH_KEYS.add("in_".toLowerCase());
        ENTITY_IGNORE_START_WITH_KEYS.add("out_".toLowerCase());
        ENTITY_IGNORE_START_WITH_KEYS.add("in_".toUpperCase());
        ENTITY_IGNORE_START_WITH_KEYS.add("out_".toUpperCase());
        ENTITY_IGNORE_START_WITH_KEYS.add("@");
        ENTITY_IGNORE_START_WITH_KEYS.add("_");
        EMBEDDED_IGNORE_KEYS = new HashSet();
        EMBEDDED_IGNORE_START_WITH_KEYS = new HashSet();
        ENTITY_IGNORE_START_WITH_KEYS.add("@");
        ENTITY_IGNORE_START_WITH_KEYS.add("_");
        logger = LoggerFactory.getLogger(EntityManagementImpl.class);
    }
}

