/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.SchemaManager;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.gcube.informationsystem.resourceregistry.resources.utils.ContextUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="entity")
public class EntityManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    public static final String ID_PATH_PARAM = "id";
    public static final String TYPE_PATH_PARAM = "type";
    public static final String SOURCE_ID_PATH_PARAM = "sourceId";
    public static final String TARGET_ID_PATH_PARAM = "targetId";
    protected EntityManagement entityManager = new EntityManagementImpl();

    @PUT
    @Path(value="facet/{type}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String createFacet(@PathParam(value="type") String type, String json) throws EntityException, ResourceRegistryException {
        logger.info("requested facet creation for type {} defined by {} ", (Object)type, (Object)json);
        return this.entityManager.createFacet(type, json);
    }

    @POST
    @Path(value="facet/{id}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String updateFacet(@PathParam(value="id") String uuid, String json) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("requested facet update for id {} with {}", (Object)uuid, (Object)json);
        return this.entityManager.updateFacet(UUID.fromString(uuid), json);
    }

    @DELETE
    @Path(value="facet/{id}")
    public boolean deleteFacet(@PathParam(value="id") String uuid) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("Requested to delete Facet with id {}", (Object)uuid);
        return this.entityManager.deleteFacet(UUID.fromString(uuid));
    }

    @PUT
    @Path(value="resource/{type}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String createResource(@PathParam(value="type") String type, String json) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("requested resource creation for type {} with json {}", (Object)type, (Object)json);
        return this.entityManager.createResource(type, json);
    }

    @POST
    @Path(value="resource/{id}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String updateResource(@PathParam(value="id") String uuid, String json) throws FacetNotFoundException, ResourceRegistryException {
        logger.info("requested resource update for id {} with {}", (Object)uuid, (Object)json);
        return this.entityManager.updateResource(UUID.fromString(uuid), json);
    }

    @DELETE
    @Path(value="resource/{id}")
    public boolean deleteResource(@PathParam(value="id") String uuid) throws ResourceNotFoundException, Exception {
        logger.info("requested resource deletion for id {}", (Object)uuid);
        return this.entityManager.deleteResource(UUID.fromString(uuid));
    }

    @PUT
    @Path(value="consistsOf/source/{sourceId}/target/{targetId}/{type}")
    @Produces(value={"application/json"})
    public String attachFacet(@PathParam(value="sourceId") String resourceUUID, @PathParam(value="targetId") String facetUUID, @PathParam(value="type") String type, String json) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        logger.info("requested to attach resource {} to facet {} ({} Type {}) with properties {}", new Object[]{resourceUUID, facetUUID, ConsistsOf.class.getSimpleName(), type, json});
        return this.entityManager.attachFacet(UUID.fromString(resourceUUID), UUID.fromString(facetUUID), type, json);
    }

    @DELETE
    @Path(value="consistsOf/{id}")
    public boolean detachFacet(@PathParam(value="id") String consistOfUUID) throws ResourceRegistryException {
        logger.info("requested to detach {}", (Object)consistOfUUID);
        return this.entityManager.detachFacet(UUID.fromString(consistOfUUID));
    }

    @PUT
    @Path(value="isRelatedTo/source/{sourceId}/target/{targetId}/{type}")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"application/json"})
    public String attachResource(@PathParam(value="sourceId") String sourceResourceUUID, @PathParam(value="targetId") String targetResourceUUID, @PathParam(value="type") String type, String json) throws ResourceNotFoundException, ResourceRegistryException {
        logger.info("requested to attach source {} {} and target {} {} ({} Type {}) with properties {}", new Object[]{"Resource", sourceResourceUUID, "Resource", targetResourceUUID, IsRelatedTo.class.getSimpleName(), type, json});
        return this.entityManager.attachResource(UUID.fromString(sourceResourceUUID), UUID.fromString(targetResourceUUID), type, json);
    }

    @DELETE
    @Path(value="isRelatedTo/{id}")
    public boolean detachResource(@PathParam(value="id") String relatedToUUID) throws ResourceRegistryException {
        logger.info("requested to detach {}", (Object)relatedToUUID);
        return this.entityManager.detachResource(UUID.fromString(relatedToUUID));
    }

    @POST
    @Path(value="add/resource/{id}")
    public boolean addResourceToContext(@PathParam(value="id") String uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("requested to add {} with UUID {} to current context {}", new Object[]{"Resource", uuid, ContextUtility.getCurrentContext()});
        return this.entityManager.addResourceToContext(UUID.fromString(uuid));
    }

    @POST
    @Path(value="add/facet/{id}")
    public boolean addFacetToContext(@PathParam(value="id") String uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        logger.info("requested to add {} with UUID {} to current context {}", new Object[]{"Facet", uuid, ContextUtility.getCurrentContext()});
        return this.entityManager.addFacetToContext(UUID.fromString(uuid));
    }
}

